/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift;

import io.trino.hive.jdbc.;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.HiveAuthFactory;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.CLIServiceClient;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.FetchOrientation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.GetInfoType;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.GetInfoValue;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.HiveSQLException;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.OperationHandle;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.OperationState;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.OperationStatus;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.RowSet;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.RowSetFactory;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.SessionHandle;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.TableSchema;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TCancelDelegationTokenReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TCancelDelegationTokenResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TCancelOperationReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TCancelOperationResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TCloseOperationReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TCloseOperationResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TCloseSessionReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TCloseSessionResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TExecuteStatementReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TExecuteStatementResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TFetchResultsReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TFetchResultsResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetCatalogsReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetCatalogsResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetColumnsReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetColumnsResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetDelegationTokenReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetDelegationTokenResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetFunctionsReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetFunctionsResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetInfoReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetInfoResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetOperationStatusReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetOperationStatusResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetResultSetMetadataReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetResultSetMetadataResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetSchemasReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetSchemasResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetTableTypesReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetTableTypesResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetTablesReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetTablesResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetTypeInfoReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TGetTypeInfoResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TOpenSessionReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TOpenSessionResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TProtocolVersion;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TRenewDelegationTokenReq;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TRenewDelegationTokenResp;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TStatus;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TStatusCode;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TException;
import java.util.List;
import java.util.Map;

public class ThriftCLIServiceClient
extends CLIServiceClient {
    private final .TCLIService.Iface cliService;

    public ThriftCLIServiceClient(.TCLIService.Iface cliService) {
        this.cliService = cliService;
    }

    public void checkStatus(TStatus status) throws HiveSQLException {
        if (TStatusCode.ERROR_STATUS.equals(status.getStatusCode())) {
            throw new HiveSQLException(status);
        }
    }

    @Override
    public SessionHandle openSession(String username, String password, Map<String, String> configuration) throws HiveSQLException {
        try {
            TOpenSessionReq req = new TOpenSessionReq();
            req.setUsername(username);
            req.setPassword(password);
            req.setConfiguration(configuration);
            TOpenSessionResp resp = this.cliService.OpenSession(req);
            this.checkStatus(resp.getStatus());
            return new SessionHandle(resp.getSessionHandle(), resp.getServerProtocolVersion());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public SessionHandle openSessionWithImpersonation(String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        throw new HiveSQLException("open with impersonation operation is not supported in the client");
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        try {
            TCloseSessionReq req = new TCloseSessionReq(sessionHandle.toTSessionHandle());
            TCloseSessionResp resp = this.cliService.CloseSession(req);
            this.checkStatus(resp.getStatus());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType infoType) throws HiveSQLException {
        try {
            TGetInfoReq req = new TGetInfoReq(sessionHandle.toTSessionHandle(), infoType.toTGetInfoType());
            TGetInfoResp resp = this.cliService.GetInfo(req);
            this.checkStatus(resp.getStatus());
            return new GetInfoValue(resp.getInfoValue());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(sessionHandle, statement, confOverlay, false);
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(sessionHandle, statement, confOverlay, true);
    }

    private OperationHandle executeStatementInternal(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay, boolean isAsync) throws HiveSQLException {
        try {
            TExecuteStatementReq req = new TExecuteStatementReq(sessionHandle.toTSessionHandle(), statement);
            req.setConfOverlay(confOverlay);
            req.setRunAsync(isAsync);
            TExecuteStatementResp resp = this.cliService.ExecuteStatement(req);
            this.checkStatus(resp.getStatus());
            TProtocolVersion protocol = sessionHandle.getProtocolVersion();
            return new OperationHandle(resp.getOperationHandle(), protocol);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getTypeInfo(SessionHandle sessionHandle) throws HiveSQLException {
        try {
            TGetTypeInfoReq req = new TGetTypeInfoReq(sessionHandle.toTSessionHandle());
            TGetTypeInfoResp resp = this.cliService.GetTypeInfo(req);
            this.checkStatus(resp.getStatus());
            TProtocolVersion protocol = sessionHandle.getProtocolVersion();
            return new OperationHandle(resp.getOperationHandle(), protocol);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getCatalogs(SessionHandle sessionHandle) throws HiveSQLException {
        try {
            TGetCatalogsReq req = new TGetCatalogsReq(sessionHandle.toTSessionHandle());
            TGetCatalogsResp resp = this.cliService.GetCatalogs(req);
            this.checkStatus(resp.getStatus());
            TProtocolVersion protocol = sessionHandle.getProtocolVersion();
            return new OperationHandle(resp.getOperationHandle(), protocol);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getSchemas(SessionHandle sessionHandle, String catalogName, String schemaName) throws HiveSQLException {
        try {
            TGetSchemasReq req = new TGetSchemasReq(sessionHandle.toTSessionHandle());
            req.setCatalogName(catalogName);
            req.setSchemaName(schemaName);
            TGetSchemasResp resp = this.cliService.GetSchemas(req);
            this.checkStatus(resp.getStatus());
            TProtocolVersion protocol = sessionHandle.getProtocolVersion();
            return new OperationHandle(resp.getOperationHandle(), protocol);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getTables(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        try {
            TGetTablesReq req = new TGetTablesReq(sessionHandle.toTSessionHandle());
            req.setTableName(tableName);
            req.setTableTypes(tableTypes);
            req.setSchemaName(schemaName);
            TGetTablesResp resp = this.cliService.GetTables(req);
            this.checkStatus(resp.getStatus());
            TProtocolVersion protocol = sessionHandle.getProtocolVersion();
            return new OperationHandle(resp.getOperationHandle(), protocol);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getTableTypes(SessionHandle sessionHandle) throws HiveSQLException {
        try {
            TGetTableTypesReq req = new TGetTableTypesReq(sessionHandle.toTSessionHandle());
            TGetTableTypesResp resp = this.cliService.GetTableTypes(req);
            this.checkStatus(resp.getStatus());
            TProtocolVersion protocol = sessionHandle.getProtocolVersion();
            return new OperationHandle(resp.getOperationHandle(), protocol);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getColumns(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        try {
            TGetColumnsReq req = new TGetColumnsReq();
            req.setSessionHandle(sessionHandle.toTSessionHandle());
            req.setCatalogName(catalogName);
            req.setSchemaName(schemaName);
            req.setTableName(tableName);
            req.setColumnName(columnName);
            TGetColumnsResp resp = this.cliService.GetColumns(req);
            this.checkStatus(resp.getStatus());
            TProtocolVersion protocol = sessionHandle.getProtocolVersion();
            return new OperationHandle(resp.getOperationHandle(), protocol);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getFunctions(SessionHandle sessionHandle, String catalogName, String schemaName, String functionName) throws HiveSQLException {
        try {
            TGetFunctionsReq req = new TGetFunctionsReq(sessionHandle.toTSessionHandle(), functionName);
            req.setCatalogName(catalogName);
            req.setSchemaName(schemaName);
            TGetFunctionsResp resp = this.cliService.GetFunctions(req);
            this.checkStatus(resp.getStatus());
            TProtocolVersion protocol = sessionHandle.getProtocolVersion();
            return new OperationHandle(resp.getOperationHandle(), protocol);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationStatus getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        try {
            TGetOperationStatusReq req = new TGetOperationStatusReq(opHandle.toTOperationHandle());
            TGetOperationStatusResp resp = this.cliService.GetOperationStatus(req);
            this.checkStatus(resp.getStatus());
            OperationState opState = OperationState.getOperationState(resp.getOperationState());
            HiveSQLException opException = null;
            if (opState == OperationState.ERROR) {
                opException = new HiveSQLException(resp.getErrorMessage(), resp.getSqlState(), resp.getErrorCode());
            }
            return new OperationStatus(opState, opException);
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        try {
            TCancelOperationReq req = new TCancelOperationReq(opHandle.toTOperationHandle());
            TCancelOperationResp resp = this.cliService.CancelOperation(req);
            this.checkStatus(resp.getStatus());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        try {
            TCloseOperationReq req = new TCloseOperationReq(opHandle.toTOperationHandle());
            TCloseOperationResp resp = this.cliService.CloseOperation(req);
            this.checkStatus(resp.getStatus());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        try {
            TGetResultSetMetadataReq req = new TGetResultSetMetadataReq(opHandle.toTOperationHandle());
            TGetResultSetMetadataResp resp = this.cliService.GetResultSetMetadata(req);
            this.checkStatus(resp.getStatus());
            return new TableSchema(resp.getSchema());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        try {
            TFetchResultsReq req = new TFetchResultsReq();
            req.setOperationHandle(opHandle.toTOperationHandle());
            req.setOrientation(orientation.toTFetchOrientation());
            req.setMaxRows(maxRows);
            TFetchResultsResp resp = this.cliService.FetchResults(req);
            this.checkStatus(resp.getStatus());
            return RowSetFactory.create(resp.getResults(), opHandle.getProtocolVersion());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        return this.fetchResults(opHandle, FetchOrientation.FETCH_NEXT, 10000L);
    }

    @Override
    public String getDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        TGetDelegationTokenReq req = new TGetDelegationTokenReq(sessionHandle.toTSessionHandle(), owner, renewer);
        try {
            TGetDelegationTokenResp tokenResp = this.cliService.GetDelegationToken(req);
            this.checkStatus(tokenResp.getStatus());
            return tokenResp.getDelegationToken();
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public void cancelDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        TCancelDelegationTokenReq cancelReq = new TCancelDelegationTokenReq(sessionHandle.toTSessionHandle(), tokenStr);
        try {
            TCancelDelegationTokenResp cancelResp = this.cliService.CancelDelegationToken(cancelReq);
            this.checkStatus(cancelResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public void renewDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        TRenewDelegationTokenReq cancelReq = new TRenewDelegationTokenReq(sessionHandle.toTSessionHandle(), tokenStr);
        try {
            TRenewDelegationTokenResp renewResp = this.cliService.RenewDelegationToken(cancelReq);
            this.checkStatus(renewResp.getStatus());
            return;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }
}

