/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.server;

import io.trino.hive.jdbc.;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.common.LogUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.conf.HiveConf;
import io.trino.hive.jdbc.$internal.org.apache.hive.common.util.HiveStringUtils;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.CompositeService;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.CLIService;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.ThriftCLIService;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.server.ServerOptionsProcessor;

public class HiveServer2
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(HiveServer2.class);
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;

    public HiveServer2() {
        super("HiveServer2");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.cliService = new CLIService();
        this.addService(this.cliService);
        String transportMode = System.getenv("HIVE_SERVER2_TRANSPORT_MODE");
        if (transportMode == null) {
            transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        }
        this.thriftCLIService = transportMode != null && transportMode.equalsIgnoreCase("http") ? new ThriftHttpCLIService(this.cliService) : new ThriftBinaryCLIService(this.cliService);
        this.addService(this.thriftCLIService);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        HiveConf hiveConf = this.getHiveConf();
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) {
            try {
                .TezSessionPoolManager.getInstance().stop();
            }
            catch (Exception e) {
                LOG.error("Tez session pool manager stop had an error during stop of hive server");
                e.printStackTrace();
            }
        }
    }

    private static void startHiveServer2() throws Throwable {
        long attempts = 0L;
        long maxAttempts = 1L;
        while (true) {
            HiveConf hiveConf = new HiveConf();
            maxAttempts = hiveConf.getLongVar(HiveConf.ConfVars.HIVE_SERVER2_MAX_START_ATTEMPTS);
            HiveServer2 server = null;
            try {
                server = new HiveServer2();
                server.init(hiveConf);
                server.start();
                if (!hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) break;
                .TezSessionPoolManager sessionPool = .TezSessionPoolManager.getInstance();
                sessionPool.setupPool(hiveConf);
                sessionPool.startPool();
            }
            catch (Throwable throwable) {
                if (++attempts >= maxAttempts) {
                    throw new Error("Max start attempts " + maxAttempts + " exhausted", throwable);
                }
                LOG.warn("Error starting HiveServer2 on attempt " + attempts + ", will retry in 60 seconds", throwable);
                try {
                    if (server != null) {
                        server.stop();
                        server = null;
                    }
                }
                catch (Exception e) {
                    LOG.info("Exception caught when calling stop of HiveServer2 before retrying start", e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        try {
            ServerOptionsProcessor oproc = new ServerOptionsProcessor("hiveserver2");
            if (!oproc.process(args)) {
                System.err.println("Error starting HiveServer2 with given arguments");
                System.exit(-1);
            }
            String initLog4jMessage = LogUtils.initHiveLog4j();
            LOG.debug(initLog4jMessage);
            HiveStringUtils.startupShutdownMessage(HiveServer2.class, args, LOG);
            LOG.debug(oproc.getDebugMessage().toString());
            HiveServer2.startHiveServer2();
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.error("Error initializing log: " + e.getMessage(), e);
            System.exit(-1);
        }
        catch (Throwable t) {
            LOG.fatal("Error starting HiveServer2", t);
            System.exit(-1);
        }
    }
}

