/*
 * Copyright (C) 2011 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.trino.hive.jdbc.$internal.com.google.common.util.concurrent;

import io.trino.hive.jdbc.$internal.com.google.common.annotations.Beta;
import io.trino.hive.jdbc.$internal.com.google.common.annotations.GwtCompatible;

/**
 * Unchecked variant of {@link java.util.concurrent.ExecutionException}. As with
 * {@code ExecutionException}, the exception's {@linkplain #getCause() cause}
 * comes from a failed task, possibly run in another thread.
 *
 * <p>{@code UncheckedExecutionException} is intended as an alternative to
 * {@code ExecutionException} when the exception thrown by a task is an
 * unchecked exception. This allows the client code to continue to distinguish
 * between checked and unchecked exceptions, even when they come from other
 * threads.
 *
 * <p>When wrapping an {@code Error} from another thread, prefer {@link
 * ExecutionError}.
 *
 * @author Charles Fry
 * @since 10.0
 */
@Beta
@GwtCompatible
public class UncheckedExecutionException extends RuntimeException {
  /**
   * Creates a new instance with {@code null} as its detail message.
   */
  protected UncheckedExecutionException() {}

  /**
   * Creates a new instance with the given detail message.
   */
  protected UncheckedExecutionException(String message) {
    super(message);
  }

  /**
   * Creates a new instance with the given detail message and cause.
   */
  public UncheckedExecutionException(String message, Throwable cause) {
    super(message, cause);
  }

  /**
   * Creates a new instance with the given cause.
   */
  public UncheckedExecutionException(Throwable cause) {
    super(cause);
  }

  private static final long serialVersionUID = 0;
}
