/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.service;

/**
 * HiveInterface extends 2 interfaces, ThriftHive and ThriftHiveMetastore.
 * 
 * ThriftHive.Iface is defined in:
 * service/src/gen-javabean/io.trino.hive.jdbc.$internal.org.apache.hadoop/hive/service/ThriftHive.java
 * ThriftHiveMetastore.Iface is defined in:
 * metastore/src/gen-javabean/org/apache
 * /hadoop/hive/metastore/api/ThriftHiveMetastore.java
 * 
 * These interfaces are generated by Thrift. The thrift files are in:
 * ThriftHive: service/if/hive_service.thrift ThriftHiveMetastore:
 * metastore/if/hive_metastore.thrift
 */
public interface HiveInterface extends ThriftHive.Iface,
    io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore.Iface {
}
