/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.fs;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FsUrlStreamHandler;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;

public class FsUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private Configuration conf;
    private Map<String, Boolean> protocols = new HashMap<String, Boolean>();
    private URLStreamHandler handler;

    public FsUrlStreamHandlerFactory() {
        this.conf = new Configuration();
        this.conf.getClass("fs.file.impl", null);
        this.handler = new FsUrlStreamHandler(this.conf);
    }

    public FsUrlStreamHandlerFactory(Configuration conf) {
        this.conf = new Configuration(conf);
        this.conf.getClass("fs.file.impl", null);
        this.handler = new FsUrlStreamHandler(this.conf);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (!this.protocols.containsKey(protocol)) {
            boolean known = this.conf.getClass("fs." + protocol + ".impl", null) != null;
            this.protocols.put(protocol, known);
        }
        if (this.protocols.get(protocol).booleanValue()) {
            return this.handler;
        }
        return null;
    }
}

