/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.fs;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.BlockLocation;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataInputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FSInputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FilterFileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsPermission;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.LineReader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.Progressable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class HarFileSystem
extends FilterFileSystem {
    public static final int VERSION = 1;
    private URI uri;
    private int version;
    private URI underLyingURI;
    private Path archivePath;
    private Path masterIndex;
    private Path archiveIndex;
    private String harAuth;

    public HarFileSystem() {
    }

    public HarFileSystem(FileSystem fs) {
        super(fs);
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        this.underLyingURI = this.decodeHarURI(name, conf);
        Path harPath = this.archivePath(new Path(name.toString()));
        if (harPath == null) {
            throw new IOException("Invalid path for the Har Filesystem. " + name.toString());
        }
        if (this.fs == null) {
            this.fs = FileSystem.get(this.underLyingURI, conf);
        }
        this.uri = harPath.toUri();
        this.archivePath = new Path(this.uri.getPath());
        this.harAuth = this.getHarAuth(this.underLyingURI);
        this.masterIndex = new Path(this.archivePath, "_masterindex");
        this.archiveIndex = new Path(this.archivePath, "_index");
        if (!this.fs.exists(this.masterIndex) || !this.fs.exists(this.archiveIndex)) {
            throw new IOException("Invalid path for the Har Filesystem. No index file in " + harPath);
        }
        try {
            this.version = this.getHarVersion();
        }
        catch (IOException io) {
            throw new IOException("Unable to read the version of the Har file system: " + this.archivePath);
        }
        if (this.version != 1) {
            throw new IOException("Invalid version " + this.version + " expected " + 1);
        }
    }

    public int getHarVersion() throws IOException {
        FSDataInputStream masterIn = this.fs.open(this.masterIndex);
        LineReader lmaster = new LineReader((InputStream)masterIn, this.getConf());
        Text line = new Text();
        lmaster.readLine(line);
        try {
            masterIn.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String versionLine = line.toString();
        String[] arr = versionLine.split(" ");
        int version = Integer.parseInt(arr[0]);
        return version;
    }

    private Path archivePath(Path p) {
        Path retPath = null;
        Path tmp = p;
        for (int i = 0; i < p.depth(); ++i) {
            if (tmp.toString().endsWith(".har")) {
                retPath = tmp;
                break;
            }
            tmp = tmp.getParent();
        }
        return retPath;
    }

    private URI decodeHarURI(URI rawURI, Configuration conf) throws IOException {
        String tmpAuth = rawURI.getAuthority();
        if (tmpAuth == null) {
            return FileSystem.getDefaultUri(conf);
        }
        String host = rawURI.getHost();
        String[] str = host.split("-", 2);
        if (str[0] == null) {
            throw new IOException("URI: " + rawURI + " is an invalid Har URI.");
        }
        String underLyingScheme = str[0];
        String underLyingHost = str.length > 1 ? str[1] : null;
        int underLyingPort = rawURI.getPort();
        String auth = underLyingHost == null && underLyingPort == -1 ? null : underLyingHost + ":" + underLyingPort;
        URI tmp = null;
        if (rawURI.getQuery() != null) {
            throw new IOException("query component in Path not supported  " + rawURI);
        }
        try {
            tmp = new URI(underLyingScheme, auth, rawURI.getPath(), rawURI.getQuery(), rawURI.getFragment());
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return tmp;
    }

    @Override
    public Path getWorkingDirectory() {
        return new Path(this.uri.toString());
    }

    private String getHarAuth(URI underLyingUri) {
        String auth = underLyingUri.getScheme() + "-";
        if (underLyingUri.getHost() != null) {
            auth = auth + underLyingUri.getHost() + ":";
            if (underLyingUri.getPort() != -1) {
                auth = auth + underLyingUri.getPort();
            }
        } else {
            auth = auth + ":";
        }
        return auth;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    private Path getPathInHar(Path path) {
        Path harPath = new Path(path.toUri().getPath());
        if (this.archivePath.compareTo(harPath) == 0) {
            return new Path("/");
        }
        Path tmp = new Path(harPath.getName());
        Path parent = harPath.getParent();
        while (parent.compareTo(this.archivePath) != 0) {
            if (parent.toString().equals("/")) {
                tmp = null;
                break;
            }
            tmp = new Path(parent.getName(), tmp);
            parent = parent.getParent();
        }
        if (tmp != null) {
            tmp = new Path("/", tmp);
        }
        return tmp;
    }

    private Path makeRelative(String initial, Path p) {
        Path root = new Path("/");
        if (root.compareTo(p) == 0) {
            return new Path(initial);
        }
        Path retPath = new Path(p.getName());
        Path parent = p.getParent();
        for (int i = 0; i < p.depth() - 1; ++i) {
            retPath = new Path(parent.getName(), retPath);
            parent = parent.getParent();
        }
        return new Path(initial, retPath.toString());
    }

    @Override
    public Path makeQualified(Path path) {
        Path fsPath = path;
        if (!path.isAbsolute()) {
            fsPath = new Path(this.archivePath, path);
        }
        URI tmpURI = fsPath.toUri();
        return new Path(this.uri.getScheme(), this.harAuth, tmpURI.getPath());
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        Path p = this.makeQualified(file.getPath());
        Path harPath = this.getPathInHar(p);
        String line = this.fileStatusInIndex(harPath);
        if (line == null) {
            throw new FileNotFoundException("File " + file.getPath() + " not found");
        }
        HarStatus harStatus = new HarStatus(line);
        if (harStatus.isDir()) {
            return new BlockLocation[0];
        }
        FileStatus fsFile = this.fs.getFileStatus(new Path(this.archivePath, harStatus.getPartName()));
        BlockLocation[] rawBlocks = this.fs.getFileBlockLocations(fsFile, harStatus.getStartIndex() + start, len);
        return this.fakeBlockLocations(rawBlocks, harStatus.getStartIndex());
    }

    private BlockLocation[] fakeBlockLocations(BlockLocation[] rawBlocks, long startIndex) {
        for (BlockLocation block : rawBlocks) {
            long rawOffset = block.getOffset();
            block.setOffset(rawOffset - startIndex);
        }
        return rawBlocks;
    }

    public static int getHarHash(Path p) {
        return p.toString().hashCode() & Integer.MAX_VALUE;
    }

    private String fileStatusInIndex(Path harPath) throws IOException {
        int hashCode = HarFileSystem.getHarHash(harPath);
        FSDataInputStream in = this.fs.open(this.masterIndex);
        FileStatus masterStat = this.fs.getFileStatus(this.masterIndex);
        LineReader lin = new LineReader((InputStream)in, this.getConf());
        Text line = new Text();
        long read = lin.readLine(line);
        String[] readStr = null;
        ArrayList<Store> stores = new ArrayList<Store>();
        while (read < masterStat.getLen()) {
            int b = lin.readLine(line);
            read += (long)b;
            readStr = line.toString().split(" ");
            int startHash = Integer.parseInt(readStr[0]);
            int endHash = Integer.parseInt(readStr[1]);
            if (startHash <= hashCode && hashCode <= endHash) {
                stores.add(new Store(Long.parseLong(readStr[2]), Long.parseLong(readStr[3]), startHash, endHash));
            }
            line.clear();
        }
        try {
            lin.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        FSDataInputStream aIn = this.fs.open(this.archiveIndex);
        String retStr = null;
        for (Store s : stores) {
            read = 0L;
            aIn.seek(s.begin);
            LineReader aLin = new LineReader((InputStream)aIn, this.getConf());
            while (read + s.begin < s.end) {
                int tmp = aLin.readLine(line);
                read += (long)tmp;
                String lineFeed = line.toString();
                String[] parsed = lineFeed.split(" ");
                if (harPath.compareTo(new Path(parsed[0])) == 0) {
                    retStr = lineFeed;
                    break;
                }
                line.clear();
            }
            if (retStr == null) continue;
            break;
        }
        try {
            aIn.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        return retStr;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus archiveStatus = this.fs.getFileStatus(this.archiveIndex);
        Path p = this.makeQualified(f);
        Path harPath = this.getPathInHar(p);
        if (harPath == null) {
            throw new IOException("Invalid file name: " + f + " in " + this.uri);
        }
        String readStr = this.fileStatusInIndex(harPath);
        if (readStr == null) {
            throw new FileNotFoundException("File: " + f + " does not exist in " + this.uri);
        }
        HarStatus hstatus = null;
        hstatus = new HarStatus(readStr);
        return new FileStatus(hstatus.isDir() ? 0L : hstatus.getLength(), hstatus.isDir(), archiveStatus.getReplication(), archiveStatus.getBlockSize(), archiveStatus.getModificationTime(), archiveStatus.getAccessTime(), new FsPermission(archiveStatus.getPermission()), archiveStatus.getOwner(), archiveStatus.getGroup(), this.makeRelative(this.uri.toString(), new Path(hstatus.name)));
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        Path p = this.makeQualified(f);
        Path harPath = this.getPathInHar(p);
        if (harPath == null) {
            throw new IOException("Invalid file name: " + f + " in " + this.uri);
        }
        String readStr = this.fileStatusInIndex(harPath);
        if (readStr == null) {
            throw new FileNotFoundException(f + ": not found in " + this.archivePath);
        }
        HarStatus hstatus = new HarStatus(readStr);
        if (hstatus.isDir()) {
            throw new FileNotFoundException(f + " : not a file in " + this.archivePath);
        }
        return new HarFSDataInputStream(this.fs, new Path(this.archivePath, hstatus.getPartName()), hstatus.getStartIndex(), hstatus.getLength(), bufferSize);
    }

    public FSDataOutputStream create(Path f, int bufferSize) throws IOException {
        throw new IOException("Har: Create not allowed");
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Har: create not allowed.");
    }

    @Override
    public void close() throws IOException {
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean setReplication(Path src, short replication) throws IOException {
        throw new IOException("Har: setreplication not allowed");
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Har: delete not allowed");
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        FileStatus archiveStatus = this.fs.getFileStatus(this.archiveIndex);
        Path tmpPath = this.makeQualified(f);
        Path harPath = this.getPathInHar(tmpPath);
        String readStr = this.fileStatusInIndex(harPath);
        if (readStr == null) {
            throw new FileNotFoundException("File " + f + " not found in " + this.archivePath);
        }
        HarStatus hstatus = new HarStatus(readStr);
        if (!hstatus.isDir()) {
            statuses.add(new FileStatus(hstatus.getLength(), hstatus.isDir(), archiveStatus.getReplication(), archiveStatus.getBlockSize(), archiveStatus.getModificationTime(), archiveStatus.getAccessTime(), new FsPermission(archiveStatus.getPermission()), archiveStatus.getOwner(), archiveStatus.getGroup(), this.makeRelative(this.uri.toString(), new Path(hstatus.name))));
        } else {
            for (String child : hstatus.children) {
                FileStatus tmp = this.getFileStatus(new Path(tmpPath, child));
                statuses.add(tmp);
            }
        }
        return statuses.toArray(new FileStatus[statuses.size()]);
    }

    @Override
    public Path getHomeDirectory() {
        return new Path(this.uri.toString());
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Har: mkdirs not allowed");
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        throw new IOException("Har: copyfromlocalfile not allowed");
    }

    @Override
    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, HarFileSystem.getLocal(this.getConf()), dst, false, this.getConf());
    }

    @Override
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        throw new IOException("Har: startLocalOutput not allowed");
    }

    @Override
    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        throw new IOException("Har: completeLocalOutput not allowed");
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        throw new IOException("Har: setowner not allowed");
    }

    @Override
    public void setPermission(Path p, FsPermission permisssion) throws IOException {
        throw new IOException("Har: setPermission not allowed");
    }

    private static class HarFSDataInputStream
    extends FSDataInputStream {
        public HarFSDataInputStream(FileSystem fs, Path p, long start, long length, int bufsize) throws IOException {
            super(new HarFsInputStream(fs, p, start, length, bufsize));
        }

        public HarFSDataInputStream(FileSystem fs, Path p, long start, long length) throws IOException {
            super(new HarFsInputStream(fs, p, start, length, 0));
        }

        private static class HarFsInputStream
        extends FSInputStream {
            private long position;
            private long start;
            private long end;
            private FSDataInputStream underLyingStream;
            private byte[] oneBytebuff = new byte[1];

            HarFsInputStream(FileSystem fs, Path path, long start, long length, int bufferSize) throws IOException {
                this.underLyingStream = fs.open(path, bufferSize);
                this.underLyingStream.seek(start);
                this.start = start;
                this.position = start;
                this.end = start + length;
            }

            @Override
            public synchronized int available() throws IOException {
                long remaining = this.end - this.underLyingStream.getPos();
                if (remaining > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return (int)remaining;
            }

            @Override
            public synchronized void close() throws IOException {
                this.underLyingStream.close();
                super.close();
            }

            @Override
            public void mark(int readLimit) {
            }

            @Override
            public void reset() throws IOException {
                throw new IOException("reset not implemented.");
            }

            @Override
            public synchronized int read() throws IOException {
                int ret = this.read(this.oneBytebuff, 0, 1);
                return ret <= 0 ? -1 : this.oneBytebuff[0] & 0xFF;
            }

            @Override
            public synchronized int read(byte[] b) throws IOException {
                int ret = this.read(b, 0, b.length);
                if (ret != -1) {
                    this.position += (long)ret;
                }
                return ret;
            }

            @Override
            public synchronized int read(byte[] b, int offset, int len) throws IOException {
                int newlen = len;
                int ret = -1;
                if (this.position + (long)len > this.end) {
                    newlen = (int)(this.end - this.position);
                }
                if (newlen == 0) {
                    return ret;
                }
                ret = this.underLyingStream.read(b, offset, newlen);
                this.position += (long)ret;
                return ret;
            }

            @Override
            public synchronized long skip(long n) throws IOException {
                long tmpN = n;
                if (tmpN > 0L) {
                    if (this.position + tmpN > this.end) {
                        tmpN = this.end - this.position;
                    }
                    this.underLyingStream.seek(tmpN + this.position);
                    this.position += tmpN;
                    return tmpN;
                }
                return tmpN < 0L ? -1L : 0L;
            }

            @Override
            public synchronized long getPos() throws IOException {
                return this.position - this.start;
            }

            @Override
            public synchronized void seek(long pos) throws IOException {
                if (pos < 0L || this.start + pos > this.end) {
                    throw new IOException("Failed to seek: EOF");
                }
                this.position = this.start + pos;
                this.underLyingStream.seek(this.position);
            }

            @Override
            public boolean seekToNewSource(long targetPos) throws IOException {
                return false;
            }

            @Override
            public int read(long pos, byte[] b, int offset, int length) throws IOException {
                int nlength = length;
                if (this.start + (long)nlength + pos > this.end) {
                    nlength = (int)(this.end - (this.start + pos));
                }
                return this.underLyingStream.read(pos + this.start, b, offset, nlength);
            }

            @Override
            public void readFully(long pos, byte[] b, int offset, int length) throws IOException {
                if (this.start + (long)length + pos > this.end) {
                    throw new IOException("Not enough bytes to read.");
                }
                this.underLyingStream.readFully(pos + this.start, b, offset, length);
            }

            @Override
            public void readFully(long pos, byte[] b) throws IOException {
                this.readFully(pos, b, 0, b.length);
            }
        }
    }

    private static class HarStatus {
        boolean isDir;
        String name;
        List<String> children;
        String partName;
        long startIndex;
        long length;

        public HarStatus(String harString) {
            String[] splits = harString.split(" ");
            this.name = splits[0];
            this.isDir = "dir".equals(splits[1]);
            this.partName = splits[2];
            this.startIndex = Long.parseLong(splits[3]);
            this.length = Long.parseLong(splits[4]);
            if (this.isDir) {
                this.children = new ArrayList<String>();
                for (int i = 5; i < splits.length; ++i) {
                    this.children.add(splits[i]);
                }
            }
        }

        public boolean isDir() {
            return this.isDir;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getChildren() {
            return this.children;
        }

        public String getFileName() {
            return this.name;
        }

        public String getPartName() {
            return this.partName;
        }

        public long getStartIndex() {
            return this.startIndex;
        }

        public long getLength() {
            return this.length;
        }
    }

    static class Store {
        public long begin;
        public long end;
        public int startHash;
        public int endHash;

        public Store() {
            this.endHash = 0;
            this.startHash = 0;
            this.begin = this.end = (long)0;
        }

        public Store(long begin, long end, int startHash, int endHash) {
            this.begin = begin;
            this.end = end;
            this.startHash = startHash;
            this.endHash = endHash;
        }
    }
}

