/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.fs;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FilterFileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.LocalFileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.shims.ShimLoader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.Shell;
import java.io.IOException;
import java.net.URI;

public class ProxyLocalFileSystem
extends FilterFileSystem {
    protected LocalFileSystem localFs;

    public ProxyLocalFileSystem() {
        this.localFs = new LocalFileSystem();
    }

    public ProxyLocalFileSystem(FileSystem fs) {
        throw new RuntimeException("Unsupported Constructor");
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        String scheme = name.getScheme();
        String nameUriString = name.toString();
        if (Shell.WINDOWS) {
            nameUriString = nameUriString.replaceAll("%5C", "/").replaceFirst("/[c-zC-Z]:", "/").replaceFirst("^[c-zC-Z]:", "");
            name = URI.create(nameUriString);
        }
        String authority = name.getAuthority() != null ? name.getAuthority() : "";
        String proxyUriString = nameUriString + "://" + authority + "/";
        this.fs = ShimLoader.getHadoopShims().createProxyFileSystem(this.localFs, URI.create(proxyUriString));
        this.fs.initialize(name, conf);
    }
}

