/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsAction;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FsPermission
implements Writable {
    static final WritableFactory FACTORY = new WritableFactory(){

        @Override
        public Writable newInstance() {
            return new FsPermission();
        }
    };
    private FsAction useraction = null;
    private FsAction groupaction = null;
    private FsAction otheraction = null;
    public static final String UMASK_LABEL = "dfs.umask";
    public static final int DEFAULT_UMASK = 18;

    public static FsPermission createImmutable(short permission) {
        return new FsPermission(permission){

            @Override
            public FsPermission applyUMask(FsPermission umask) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void readFields(DataInput in) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private FsPermission() {
    }

    public FsPermission(FsAction u, FsAction g, FsAction o) {
        this.set(u, g, o);
    }

    public FsPermission(short mode) {
        this.fromShort(mode);
    }

    public FsPermission(FsPermission other) {
        this.useraction = other.useraction;
        this.groupaction = other.groupaction;
        this.otheraction = other.otheraction;
    }

    public FsAction getUserAction() {
        return this.useraction;
    }

    public FsAction getGroupAction() {
        return this.groupaction;
    }

    public FsAction getOtherAction() {
        return this.otheraction;
    }

    private void set(FsAction u, FsAction g, FsAction o) {
        this.useraction = u;
        this.groupaction = g;
        this.otheraction = o;
    }

    public void fromShort(short n) {
        FsAction[] v = FsAction.values();
        this.set(v[n >>> 6 & 7], v[n >>> 3 & 7], v[n & 7]);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.toShort());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.fromShort(in.readShort());
    }

    public static FsPermission read(DataInput in) throws IOException {
        FsPermission p = new FsPermission();
        p.readFields(in);
        return p;
    }

    public short toShort() {
        int s = this.useraction.ordinal() << 6 | this.groupaction.ordinal() << 3 | this.otheraction.ordinal();
        return (short)s;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FsPermission) {
            FsPermission that = (FsPermission)obj;
            return this.useraction == that.useraction && this.groupaction == that.groupaction && this.otheraction == that.otheraction;
        }
        return false;
    }

    public int hashCode() {
        return this.toShort();
    }

    public String toString() {
        return this.useraction.SYMBOL + this.groupaction.SYMBOL + this.otheraction.SYMBOL;
    }

    public FsPermission applyUMask(FsPermission umask) {
        return new FsPermission(this.useraction.and(umask.useraction.not()), this.groupaction.and(umask.groupaction.not()), this.otheraction.and(umask.otheraction.not()));
    }

    public static FsPermission getUMask(Configuration conf) {
        int umask = 18;
        if (conf != null) {
            umask = conf.getInt(UMASK_LABEL, 18);
        }
        return new FsPermission((short)umask);
    }

    public static void setUMask(Configuration conf, FsPermission umask) {
        conf.setInt(UMASK_LABEL, umask.toShort());
    }

    public static FsPermission getDefault() {
        return new FsPermission(511);
    }

    public static FsPermission valueOf(String unixSymbolicPermission) {
        if (unixSymbolicPermission == null) {
            return null;
        }
        if (unixSymbolicPermission.length() != 10) {
            throw new IllegalArgumentException("length != 10(unixSymbolicPermission=" + unixSymbolicPermission + ")");
        }
        int n = 0;
        for (int i = 1; i < unixSymbolicPermission.length(); ++i) {
            n <<= 1;
            char c = unixSymbolicPermission.charAt(i);
            n += c == '-' || c == 'T' || c == 'S' ? 0 : 1;
        }
        return new FsPermission((short)n);
    }

    static {
        WritableFactories.setFactory(FsPermission.class, FACTORY);
    }
}

