/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.GenerationStamp;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;

public class Block
implements Writable,
Comparable<Block> {
    public static final long GRANDFATHER_GENERATION_STAMP = 0L;
    private long blockId;
    private long numBytes;
    private long generationStamp;

    public static boolean isBlockFilename(File f) {
        String name = f.getName();
        return name.startsWith("blk_") && name.indexOf(46) < 0;
    }

    static long filename2id(String name) {
        return Long.parseLong(name.substring("blk_".length()));
    }

    public Block() {
        this(0L, 0L, 0L);
    }

    public Block(long blkid, long len, long generationStamp) {
        this.set(blkid, len, generationStamp);
    }

    public Block(long blkid) {
        this(blkid, 0L, 1L);
    }

    public Block(Block blk) {
        this(blk.blockId, blk.numBytes, blk.generationStamp);
    }

    public Block(File f, long len, long genstamp) {
        this(Block.filename2id(f.getName()), len, genstamp);
    }

    public void set(long blkid, long len, long genStamp) {
        this.blockId = blkid;
        this.numBytes = len;
        this.generationStamp = genStamp;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public void setBlockId(long bid) {
        this.blockId = bid;
    }

    public String getBlockName() {
        return "blk_" + String.valueOf(this.blockId);
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public void setNumBytes(long len) {
        this.numBytes = len;
    }

    public long getGenerationStamp() {
        return this.generationStamp;
    }

    public void setGenerationStamp(long stamp) {
        this.generationStamp = stamp;
    }

    public String toString() {
        return this.getBlockName() + "_" + this.getGenerationStamp();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.blockId);
        out.writeLong(this.numBytes);
        out.writeLong(this.generationStamp);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.blockId = in.readLong();
        this.numBytes = in.readLong();
        this.generationStamp = in.readLong();
        if (this.numBytes < 0L) {
            throw new IOException("Unexpected block size: " + this.numBytes);
        }
    }

    static void validateGenerationStamp(long generationstamp) {
        if (generationstamp == 1L) {
            throw new IllegalStateException("generationStamp (=" + generationstamp + ") == GenerationStamp.WILDCARD_STAMP");
        }
    }

    @Override
    public int compareTo(Block b) {
        Block.validateGenerationStamp(this.generationStamp);
        Block.validateGenerationStamp(b.generationStamp);
        if (this.blockId < b.blockId) {
            return -1;
        }
        if (this.blockId == b.blockId) {
            return GenerationStamp.compare(this.generationStamp, b.generationStamp);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Block)) {
            return false;
        }
        Block that = (Block)o;
        return this.blockId == that.blockId && GenerationStamp.equalsWithWildcard(this.generationStamp, that.generationStamp);
    }

    public int hashCode() {
        return 629 + (int)(this.blockId ^ this.blockId >>> 32);
    }

    static {
        WritableFactories.setFactory(Block.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new Block();
            }
        });
    }
}

