/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.HdfsConstants;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.UpgradeObject;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode.DataNode;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;

public abstract class UpgradeObjectDatanode
extends UpgradeObject
implements Runnable {
    private DataNode dataNode = null;

    @Override
    public HdfsConstants.NodeType getType() {
        return HdfsConstants.NodeType.DATA_NODE;
    }

    protected DataNode getDatanode() {
        return this.dataNode;
    }

    void setDatanode(DataNode dataNode) {
        this.dataNode = dataNode;
    }

    public abstract void doUpgrade() throws IOException;

    boolean preUpgradeAction(NamespaceInfo nsInfo) throws IOException {
        int nsUpgradeVersion = nsInfo.getDistributedUpgradeVersion();
        if (nsUpgradeVersion >= this.getVersion()) {
            return false;
        }
        String errorMsg = "\n   Data-node missed a distributed upgrade and will shutdown.\n   " + this.getDescription() + "." + " Name-node version = " + nsInfo.getLayoutVersion() + ".";
        DataNode.LOG.fatal(errorMsg);
        try {
            this.dataNode.namenode.errorReport(this.dataNode.dnRegistration, 0, errorMsg);
        }
        catch (SocketTimeoutException e) {
            DataNode.LOG.info("Problem connecting to server: " + this.dataNode.getNameNodeAddr());
        }
        throw new IOException(errorMsg);
    }

    @Override
    public void run() {
        assert (this.dataNode != null) : "UpgradeObjectDatanode.dataNode is null";
        if (this.dataNode.shouldRun) {
            try {
                this.doUpgrade();
            }
            catch (Exception e) {
                DataNode.LOG.error(StringUtils.stringifyException(e));
            }
        }
        if (this.getUpgradeStatus() < 100) {
            DataNode.LOG.info("\n   Distributed upgrade for DataNode version " + this.getVersion() + " to current LV " + -18 + " cannot be completed.");
        }
        try {
            this.dataNode.upgradeManager.completeUpgrade();
        }
        catch (IOException e) {
            DataNode.LOG.error(StringUtils.stringifyException(e));
        }
    }

    @Override
    public UpgradeCommand completeUpgrade() throws IOException {
        return new UpgradeCommand(100, this.getVersion(), 100);
    }
}

