/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.DFSClient;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.DatanodeID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.JspHelper;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.security.UnixUserGroupInformation;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.security.UserGroupInformation;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

abstract class DfsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static final Log LOG = LogFactory.getLog(DfsServlet.class.getCanonicalName());

    DfsServlet() {
    }

    protected UnixUserGroupInformation getUGI(HttpServletRequest request) {
        String ugi = request.getParameter("ugi");
        try {
            return new UnixUserGroupInformation(ugi.split(","));
        }
        catch (Exception e) {
            LOG.warn("Invalid ugi (= " + ugi + ")");
            return JspHelper.webUGI;
        }
    }

    protected ClientProtocol createNameNodeProxy(UnixUserGroupInformation ugi) throws IOException {
        ServletContext context = this.getServletContext();
        InetSocketAddress nnAddr = (InetSocketAddress)context.getAttribute("name.node.address");
        Configuration conf = new Configuration((Configuration)context.getAttribute("name.conf"));
        UnixUserGroupInformation.saveToConf(conf, "hadoop.job.ugi", ugi);
        return DFSClient.createNamenode(nnAddr, conf);
    }

    protected URI createRedirectUri(String servletpath, UserGroupInformation ugi, DatanodeID host, HttpServletRequest request) throws URISyntaxException {
        String hostname = host instanceof DatanodeInfo ? ((DatanodeInfo)host).getHostName() : host.getHost();
        String scheme = request.getScheme();
        int port = "https".equals(scheme) ? ((Integer)this.getServletContext().getAttribute("datanode.https.port")).intValue() : host.getInfoPort();
        String filename = request.getPathInfo();
        return new URI(scheme, null, hostname, port, servletpath, "filename=" + filename + "&ugi=" + ugi, null);
    }

    protected String getFilename(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filename = request.getParameter("filename");
        if (filename == null || filename.length() == 0) {
            throw new IOException("Invalid filename");
        }
        return filename;
    }
}

