/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsPermission;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.PermissionStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.Block;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.DatanodeID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.HdfsConstants;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.Storage;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.StorageInfo;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INode;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INodeFile;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.NameNode;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.UpgradeManagerNamenode;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.UTF8;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;

public class FSImage
extends Storage {
    private static final SimpleDateFormat DATE_FORM = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected long checkpointTime = -1L;
    private FSEditLog editLog = null;
    private boolean isUpgradeFinalized = false;
    protected List<Storage.StorageDirectory> removedStorageDirs = new ArrayList<Storage.StorageDirectory>();
    private Collection<File> checkpointDirs;
    private Collection<File> checkpointEditsDirs;
    private volatile CheckpointStates ckptState = CheckpointStates.START;
    private static final FsPermission FILE_PERM = new FsPermission(0);
    private static final byte[] PATH_SEPARATOR = INode.string2Bytes("/");
    private static final UTF8 U_STR = new UTF8();

    FSImage() {
        super(HdfsConstants.NodeType.NAME_NODE);
        this.editLog = new FSEditLog(this);
    }

    FSImage(Collection<File> fsDirs, Collection<File> fsEditsDirs) throws IOException {
        this();
        this.setStorageDirectories(fsDirs, fsEditsDirs);
    }

    public FSImage(StorageInfo storageInfo) {
        super(HdfsConstants.NodeType.NAME_NODE, storageInfo);
    }

    public FSImage(File imageDir) throws IOException {
        this();
        ArrayList<File> dirs = new ArrayList<File>(1);
        ArrayList<File> editsDirs = new ArrayList<File>(1);
        dirs.add(imageDir);
        editsDirs.add(imageDir);
        this.setStorageDirectories(dirs, editsDirs);
    }

    void setStorageDirectories(Collection<File> fsNameDirs, Collection<File> fsEditsDirs) throws IOException {
        this.storageDirs = new ArrayList();
        this.removedStorageDirs = new ArrayList<Storage.StorageDirectory>();
        for (File dirName : fsNameDirs) {
            boolean isAlsoEdits = false;
            for (File editsDirName : fsEditsDirs) {
                if (editsDirName.compareTo(dirName) != 0) continue;
                isAlsoEdits = true;
                fsEditsDirs.remove(editsDirName);
                break;
            }
            NameNodeDirType dirType = isAlsoEdits ? NameNodeDirType.IMAGE_AND_EDITS : NameNodeDirType.IMAGE;
            this.addStorageDir(new Storage.StorageDirectory(dirName, dirType));
        }
        for (File dirName : fsEditsDirs) {
            this.addStorageDir(new Storage.StorageDirectory(dirName, NameNodeDirType.EDITS));
        }
    }

    void setCheckpointDirectories(Collection<File> dirs, Collection<File> editsDirs) {
        this.checkpointDirs = dirs;
        this.checkpointEditsDirs = editsDirs;
    }

    static File getImageFile(Storage.StorageDirectory sd, NameNodeFile type) {
        return new File(sd.getCurrentDir(), type.getName());
    }

    List<Storage.StorageDirectory> getRemovedStorageDirs() {
        return this.removedStorageDirs;
    }

    File getEditFile(Storage.StorageDirectory sd) {
        return FSImage.getImageFile(sd, NameNodeFile.EDITS);
    }

    File getEditNewFile(Storage.StorageDirectory sd) {
        return FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW);
    }

    File[] getFileNames(NameNodeFile type, NameNodeDirType dirType) {
        Iterator<Storage.StorageDirectory> it;
        ArrayList<File> list = new ArrayList<File>();
        Iterator<Storage.StorageDirectory> iterator = it = dirType == null ? this.dirIterator() : this.dirIterator(dirType);
        while (it.hasNext()) {
            list.add(FSImage.getImageFile(it.next(), type));
        }
        return list.toArray(new File[list.size()]);
    }

    File[] getImageFiles() {
        return this.getFileNames(NameNodeFile.IMAGE, NameNodeDirType.IMAGE);
    }

    File[] getEditsFiles() {
        return this.getFileNames(NameNodeFile.EDITS, NameNodeDirType.EDITS);
    }

    File[] getTimeFiles() {
        return this.getFileNames(NameNodeFile.TIME, null);
    }

    boolean recoverTransitionRead(Collection<File> dataDirs, Collection<File> editsDirs, HdfsConstants.StartupOption startOpt) throws IOException {
        Storage.StorageState curState;
        Storage.StorageDirectory sd;
        assert (startOpt != HdfsConstants.StartupOption.FORMAT) : "NameNode formatting should be performed before reading the image";
        if (dataDirs.size() == 0 || editsDirs.size() == 0) {
            throw new IOException("All specified directories are not accessible or do not exist.");
        }
        if (startOpt == HdfsConstants.StartupOption.IMPORT && (this.checkpointDirs == null || this.checkpointDirs.isEmpty())) {
            throw new IOException("Cannot import image from a checkpoint. \"fs.checkpoint.dir\" is not set.");
        }
        if (startOpt == HdfsConstants.StartupOption.IMPORT && (this.checkpointEditsDirs == null || this.checkpointEditsDirs.isEmpty())) {
            throw new IOException("Cannot import image from a checkpoint. \"fs.checkpoint.edits.dir\" is not set.");
        }
        this.setStorageDirectories(dataDirs, editsDirs);
        HashMap<Storage.StorageDirectory, Storage.StorageState> dataDirStates = new HashMap<Storage.StorageDirectory, Storage.StorageState>();
        boolean isFormatted = false;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            try {
                curState = sd.analyzeStorage(startOpt);
                switch (curState) {
                    case NON_EXISTENT: {
                        throw new InconsistentFSStateException(sd.getRoot(), "storage directory does not exist or is not accessible.");
                    }
                    case NOT_FORMATTED: {
                        break;
                    }
                    case NORMAL: {
                        break;
                    }
                    default: {
                        sd.doRecover(curState);
                    }
                }
                if (curState != Storage.StorageState.NOT_FORMATTED && startOpt != HdfsConstants.StartupOption.ROLLBACK) {
                    sd.read();
                    isFormatted = true;
                }
                if (startOpt == HdfsConstants.StartupOption.IMPORT && isFormatted) {
                    throw new IOException("Cannot import image from a checkpoint.  NameNode already contains an image in " + sd.getRoot());
                }
            }
            catch (IOException ioe) {
                sd.unlock();
                throw ioe;
            }
            dataDirStates.put(sd, curState);
        }
        if (!isFormatted && startOpt != HdfsConstants.StartupOption.ROLLBACK && startOpt != HdfsConstants.StartupOption.IMPORT) {
            throw new IOException("NameNode is not formatted.");
        }
        if (this.layoutVersion < -3) {
            FSImage.checkVersionUpgradable(this.layoutVersion);
        }
        if (startOpt != HdfsConstants.StartupOption.UPGRADE && this.layoutVersion < -3 && this.layoutVersion != -18) {
            throw new IOException("\nFile system image contains an old layout version " + this.layoutVersion + ".\nAn upgrade to version " + -18 + " is required.\nPlease restart NameNode with -upgrade option.");
        }
        this.verifyDistributedUpgradeProgress(startOpt);
        this.checkpointTime = 0L;
        it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            curState = (Storage.StorageState)((Object)dataDirStates.get(sd));
            switch (curState) {
                case NON_EXISTENT: {
                    assert (false) : (Object)((Object)Storage.StorageState.NON_EXISTENT) + " state cannot be here";
                }
                case NOT_FORMATTED: {
                    LOG.info("Storage directory " + sd.getRoot() + " is not formatted.");
                    LOG.info("Formatting ...");
                    sd.clearDirectory();
                    break;
                }
            }
        }
        switch (startOpt) {
            case UPGRADE: {
                this.doUpgrade();
                return false;
            }
            case IMPORT: {
                this.doImportCheckpoint();
                return true;
            }
            case ROLLBACK: {
                this.doRollback();
                break;
            }
        }
        return this.loadFSImage();
    }

    private void doUpgrade() throws IOException {
        if (this.getDistributedUpgradeState()) {
            this.loadFSImage();
            this.initializeDistributedUpgrade();
            return;
        }
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (!sd.getPreviousDir().exists()) continue;
            throw new InconsistentFSStateException(sd.getRoot(), "previous fs state should not exist during upgrade. Finalize or rollback first.");
        }
        this.loadFSImage();
        long oldCTime = this.getCTime();
        this.cTime = FSNamesystem.now();
        int oldLV = this.getLayoutVersion();
        this.layoutVersion = -18;
        this.checkpointTime = FSNamesystem.now();
        Iterator<Storage.StorageDirectory> it2 = this.dirIterator();
        while (it2.hasNext()) {
            Storage.StorageDirectory sd = it2.next();
            LOG.info("Upgrading image directory " + sd.getRoot() + ".\n   old LV = " + oldLV + "; old CTime = " + oldCTime + ".\n   new LV = " + this.getLayoutVersion() + "; new CTime = " + this.getCTime());
            File curDir = sd.getCurrentDir();
            File prevDir = sd.getPreviousDir();
            File tmpDir = sd.getPreviousTmp();
            assert (curDir.exists()) : "Current directory must exist.";
            assert (!prevDir.exists()) : "prvious directory must not exist.";
            assert (!tmpDir.exists()) : "prvious.tmp directory must not exist.";
            FSImage.rename(curDir, tmpDir);
            if (!curDir.mkdir()) {
                throw new IOException("Cannot create directory " + curDir);
            }
            this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE));
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
            sd.write();
            FSImage.rename(tmpDir, prevDir);
            this.isUpgradeFinalized = false;
            LOG.info("Upgrade of " + sd.getRoot() + " is complete.");
        }
        this.initializeDistributedUpgrade();
        this.editLog.open();
    }

    private void doRollback() throws IOException {
        File prevDir;
        Storage.StorageDirectory sd;
        boolean canRollback = false;
        FSImage prevState = new FSImage();
        prevState.layoutVersion = -18;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            prevDir = sd.getPreviousDir();
            if (!prevDir.exists()) {
                LOG.info("Storage directory " + sd.getRoot() + " does not contain previous fs state.");
                sd.read();
                continue;
            }
            FSImage fSImage = prevState;
            fSImage.getClass();
            Storage.StorageDirectory sdPrev = fSImage.new Storage.StorageDirectory(sd.getRoot());
            sdPrev.read(sdPrev.getPreviousVersionFile());
            canRollback = true;
        }
        if (!canRollback) {
            throw new IOException("Cannot rollback. None of the storage directories contain previous fs state.");
        }
        it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            prevDir = sd.getPreviousDir();
            if (!prevDir.exists()) continue;
            LOG.info("Rolling back storage directory " + sd.getRoot() + ".\n   new LV = " + prevState.getLayoutVersion() + "; new CTime = " + prevState.getCTime());
            File tmpDir = sd.getRemovedTmp();
            assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
            File curDir = sd.getCurrentDir();
            assert (curDir.exists()) : "Current directory must exist.";
            FSImage.rename(curDir, tmpDir);
            FSImage.rename(prevDir, curDir);
            FSImage.deleteDir(tmpDir);
            LOG.info("Rollback of " + sd.getRoot() + " is complete.");
        }
        this.isUpgradeFinalized = true;
        this.verifyDistributedUpgradeProgress(HdfsConstants.StartupOption.REGULAR);
    }

    private void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            LOG.info("Directory " + prevDir + " does not exist.");
            LOG.info("Finalize upgrade for " + sd.getRoot() + " is not required.");
            return;
        }
        LOG.info("Finalizing upgrade for storage directory " + sd.getRoot() + "." + (this.getLayoutVersion() == 0 ? "" : "\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime()));
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        File tmpDir = sd.getFinalizedTmp();
        FSImage.rename(prevDir, tmpDir);
        FSImage.deleteDir(tmpDir);
        this.isUpgradeFinalized = true;
        LOG.info("Finalize upgrade for " + sd.getRoot() + " is complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doImportCheckpoint() throws IOException {
        FSImage ckptImage = new FSImage();
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        FSImage realImage = fsNamesys.getFSImage();
        assert (realImage == this);
        fsNamesys.dir.fsImage = ckptImage;
        try {
            ckptImage.recoverTransitionRead(this.checkpointDirs, this.checkpointEditsDirs, HdfsConstants.StartupOption.REGULAR);
        }
        finally {
            ckptImage.close();
        }
        realImage.setStorageInfo(ckptImage);
        fsNamesys.dir.fsImage = realImage;
        this.saveFSImage();
    }

    void finalizeUpgrade() throws IOException {
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            this.doFinalize(it.next());
        }
    }

    boolean isUpgradeFinalized() {
        return this.isUpgradeFinalized;
    }

    @Override
    protected void getFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.getFields(props, sd);
        if (this.layoutVersion == 0) {
            throw new IOException("NameNode directory " + sd.getRoot() + " is not formatted.");
        }
        String sDUS = props.getProperty("distributedUpgradeState");
        String sDUV = props.getProperty("distributedUpgradeVersion");
        this.setDistributedUpgradeState(sDUS == null ? false : Boolean.parseBoolean(sDUS), sDUV == null ? this.getLayoutVersion() : Integer.parseInt(sDUV));
        this.checkpointTime = this.readCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        long timeStamp = 0L;
        if (timeFile.exists() && timeFile.canRead()) {
            DataInputStream in = new DataInputStream(new FileInputStream(timeFile));
            try {
                timeStamp = in.readLong();
            }
            finally {
                in.close();
            }
        }
        return timeStamp;
    }

    @Override
    protected void setFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFields(props, sd);
        boolean uState = this.getDistributedUpgradeState();
        int uVersion = this.getDistributedUpgradeVersion();
        if (uState && uVersion != this.getLayoutVersion()) {
            props.setProperty("distributedUpgradeState", Boolean.toString(uState));
            props.setProperty("distributedUpgradeVersion", Integer.toString(uVersion));
        }
        this.writeCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        if (this.checkpointTime < 0L) {
            return;
        }
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        if (timeFile.exists()) {
            timeFile.delete();
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(timeFile));
        try {
            out.writeLong(this.checkpointTime);
        }
        finally {
            out.close();
        }
    }

    void incrementCheckpointTime() {
        ++this.checkpointTime;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                this.writeCheckpointTime(sd);
            }
            catch (IOException e) {
                if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                    this.editLog.processIOError(sd);
                }
                this.removedStorageDirs.add(sd);
                it.remove();
            }
        }
    }

    void processIOError(File dirName) {
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (!sd.getRoot().getPath().equals(dirName.getPath())) continue;
            LOG.info(" removing " + dirName.getPath());
            this.removedStorageDirs.add(sd);
            it.remove();
        }
    }

    public FSEditLog getEditLog() {
        return this.editLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConversionNeeded(Storage.StorageDirectory sd) throws IOException {
        File oldImageDir = new File(sd.getRoot(), "image");
        if (!oldImageDir.exists()) {
            if (sd.getVersionFile().exists()) {
                throw new InconsistentFSStateException(sd.getRoot(), oldImageDir + " does not exist.");
            }
            return false;
        }
        File oldF = new File(oldImageDir, "fsimage");
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        try {
            oldFile.seek(0L);
            int odlVersion = oldFile.readInt();
            if (odlVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldFile.close();
        }
        return true;
    }

    boolean recoverInterruptedCheckpoint(Storage.StorageDirectory nameSD, Storage.StorageDirectory editsSD) throws IOException {
        boolean needToSave = false;
        File curFile = FSImage.getImageFile(nameSD, NameNodeFile.IMAGE);
        File ckptFile = FSImage.getImageFile(nameSD, NameNodeFile.IMAGE_NEW);
        if (ckptFile.exists()) {
            needToSave = true;
            if (FSImage.getImageFile(editsSD, NameNodeFile.EDITS_NEW).exists()) {
                if (!ckptFile.delete()) {
                    throw new IOException("Unable to delete " + ckptFile);
                }
            } else if (!ckptFile.renameTo(curFile)) {
                if (!curFile.delete()) {
                    LOG.warn("Unable to delete dir " + curFile + " before rename");
                }
                if (!ckptFile.renameTo(curFile)) {
                    throw new IOException("Unable to rename " + ckptFile + " to " + curFile);
                }
            }
        }
        return needToSave;
    }

    boolean loadFSImage() throws IOException {
        long latestNameCheckpointTime = Long.MIN_VALUE;
        long latestEditsCheckpointTime = Long.MIN_VALUE;
        Storage.StorageDirectory latestNameSD = null;
        Storage.StorageDirectory latestEditsSD = null;
        boolean needToSave = false;
        this.isUpgradeFinalized = true;
        ArrayList<String> imageDirs = new ArrayList<String>();
        ArrayList<String> editsDirs = new ArrayList<String>();
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (!sd.getVersionFile().exists()) {
                needToSave |= true;
                continue;
            }
            boolean imageExists = false;
            boolean editsExists = false;
            if (sd.getStorageDirType().isOfType(NameNodeDirType.IMAGE)) {
                imageExists = FSImage.getImageFile(sd, NameNodeFile.IMAGE).exists();
                imageDirs.add(sd.getRoot().getCanonicalPath());
            }
            if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                editsExists = FSImage.getImageFile(sd, NameNodeFile.EDITS).exists();
                editsDirs.add(sd.getRoot().getCanonicalPath());
            }
            this.checkpointTime = this.readCheckpointTime(sd);
            if (this.checkpointTime != Long.MIN_VALUE && (this.checkpointTime != latestNameCheckpointTime || this.checkpointTime != latestEditsCheckpointTime)) {
                needToSave |= true;
            }
            if (sd.getStorageDirType().isOfType(NameNodeDirType.IMAGE) && latestNameCheckpointTime < this.checkpointTime && imageExists) {
                latestNameCheckpointTime = this.checkpointTime;
                latestNameSD = sd;
            }
            if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS) && latestEditsCheckpointTime < this.checkpointTime && editsExists) {
                latestEditsCheckpointTime = this.checkpointTime;
                latestEditsSD = sd;
            }
            if (this.checkpointTime <= 0L) {
                needToSave |= true;
            }
            this.isUpgradeFinalized = this.isUpgradeFinalized && !sd.getPreviousDir().exists();
        }
        if (latestNameSD == null) {
            throw new IOException("Image file is not found in " + imageDirs);
        }
        if (latestEditsSD == null) {
            throw new IOException("Edits file is not found in " + editsDirs);
        }
        if (latestNameCheckpointTime != latestEditsCheckpointTime) {
            throw new IOException("Inconsitent storage detected, name and edits storage do not match");
        }
        needToSave |= this.recoverInterruptedCheckpoint(latestNameSD, latestEditsSD);
        long startTime = FSNamesystem.now();
        long imageSize = FSImage.getImageFile(latestNameSD, NameNodeFile.IMAGE).length();
        latestNameSD.read();
        needToSave |= this.loadFSImage(FSImage.getImageFile(latestNameSD, NameNodeFile.IMAGE));
        LOG.info("Image file of size " + imageSize + " loaded in " + (FSNamesystem.now() - startTime) / 1000L + " seconds.");
        return needToSave |= this.loadFSEdits(latestEditsSD) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadFSImage(File curFile) throws IOException {
        assert (this.getLayoutVersion() < 0) : "Negative layout version is expected.";
        assert (curFile != null) : "curFile is null";
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        FSDirectory fsDir = fsNamesys.dir;
        boolean needToSave = true;
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(curFile)));
        try {
            int imgVersion = in.readInt();
            this.namespaceID = in.readInt();
            long numFiles = imgVersion <= -16 ? in.readLong() : (long)in.readInt();
            this.layoutVersion = imgVersion;
            if (imgVersion <= -12) {
                long genstamp = in.readLong();
                fsNamesys.setGenerationStamp(genstamp);
            }
            needToSave = imgVersion != -18;
            short replication = FSNamesystem.getFSNamesystem().getDefaultReplication();
            LOG.info("Number of files = " + numFiles);
            String parentPath = "";
            INodeDirectory parentINode = fsDir.rootDir;
            for (long i = 0L; i < numFiles; ++i) {
                long modificationTime = 0L;
                long atime = 0L;
                long blockSize = 0L;
                String path = FSImage.readString(in);
                replication = in.readShort();
                replication = FSEditLog.adjustReplication(replication);
                modificationTime = in.readLong();
                if (imgVersion <= -17) {
                    atime = in.readLong();
                }
                if (imgVersion <= -8) {
                    blockSize = in.readLong();
                }
                int numBlocks = in.readInt();
                Block[] blocks = null;
                if (-9 <= imgVersion && numBlocks > 0 || imgVersion < -9 && numBlocks >= 0) {
                    blocks = new Block[numBlocks];
                    for (int j = 0; j < numBlocks; ++j) {
                        blocks[j] = new Block();
                        if (-14 < imgVersion) {
                            blocks[j].set(in.readLong(), in.readLong(), 0L);
                            continue;
                        }
                        blocks[j].readFields(in);
                    }
                }
                if (-8 <= imgVersion && blockSize == 0L) {
                    if (numBlocks > 1) {
                        blockSize = blocks[0].getNumBytes();
                    } else {
                        long first = numBlocks == 1 ? blocks[0].getNumBytes() : 0L;
                        blockSize = Math.max(fsNamesys.getDefaultBlockSize(), first);
                    }
                }
                long nsQuota = -1L;
                if (imgVersion <= -16 && blocks == null) {
                    nsQuota = in.readLong();
                }
                long dsQuota = -1L;
                if (imgVersion <= -18 && blocks == null) {
                    dsQuota = in.readLong();
                }
                PermissionStatus permissions = fsNamesys.getUpgradePermission();
                if (imgVersion <= -11) {
                    permissions = PermissionStatus.read(in);
                }
                if (path.length() == 0) {
                    if (nsQuota != -1L || dsQuota != -1L) {
                        fsDir.rootDir.setQuota(nsQuota, dsQuota);
                    }
                    fsDir.rootDir.setModificationTime(modificationTime);
                    fsDir.rootDir.setPermissionStatus(permissions);
                    continue;
                }
                if (!this.isParent(path, parentPath)) {
                    parentINode = null;
                    parentPath = this.getParent(path);
                }
                parentINode = fsDir.addToParent(path, parentINode, permissions, blocks, replication, modificationTime, atime, nsQuota, dsQuota, blockSize);
            }
            this.loadDatanodes(imgVersion, in);
            this.loadFilesUnderConstruction(imgVersion, in, fsNamesys);
        }
        finally {
            in.close();
        }
        return needToSave;
    }

    String getParent(String path) {
        return path.substring(0, path.lastIndexOf("/"));
    }

    private boolean isParent(String path, String parent) {
        return parent != null && path != null && path.indexOf(parent) == 0 && path.lastIndexOf("/") == parent.length();
    }

    int loadFSEdits(Storage.StorageDirectory sd) throws IOException {
        int numEdits = 0;
        FSEditLog.EditLogFileInputStream edits = new FSEditLog.EditLogFileInputStream(FSImage.getImageFile(sd, NameNodeFile.EDITS));
        numEdits = FSEditLog.loadFSEdits(edits);
        edits.close();
        File editsNew = FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW);
        if (editsNew.exists() && editsNew.length() > 0L) {
            edits = new FSEditLog.EditLogFileInputStream(editsNew);
            numEdits += FSEditLog.loadFSEdits(edits);
            edits.close();
        }
        FSNamesystem.getFSNamesystem().dir.updateCountForINodeWithQuota();
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFSImage(File newFile) throws IOException {
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        FSDirectory fsDir = fsNamesys.dir;
        long startTime = FSNamesystem.now();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
        try {
            out.writeInt(-18);
            out.writeInt(this.namespaceID);
            out.writeLong(fsDir.rootDir.numItemsInTree());
            out.writeLong(fsNamesys.getGenerationStamp());
            byte[] byteStore = new byte[32000];
            ByteBuffer strbuf = ByteBuffer.wrap(byteStore);
            FSImage.saveINode2Image(strbuf, fsDir.rootDir, out);
            FSImage.saveImage(strbuf, 0, fsDir.rootDir, out);
            fsNamesys.saveFilesUnderConstruction(out);
            strbuf = null;
        }
        finally {
            out.close();
        }
        LOG.info("Image file of size " + newFile.length() + " saved in " + (FSNamesystem.now() - startTime) / 1000L + " seconds.");
    }

    public void saveFSImage() throws IOException {
        this.editLog.createNewIfMissing();
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            NameNodeDirType dirType = (NameNodeDirType)sd.getStorageDirType();
            if (dirType.isOfType(NameNodeDirType.IMAGE)) {
                this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW));
            }
            if (!dirType.isOfType(NameNodeDirType.EDITS)) continue;
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
            File editsNew = FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW);
            if (!editsNew.exists()) continue;
            this.editLog.createEditLogFile(editsNew);
        }
        this.ckptState = CheckpointStates.UPLOAD_DONE;
        this.rollFSImage();
    }

    private int newNamespaceID() {
        Random r = new Random();
        r.setSeed(FSNamesystem.now());
        int newID = 0;
        while (newID == 0) {
            newID = r.nextInt(Integer.MAX_VALUE);
        }
        return newID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void format(Storage.StorageDirectory sd) throws IOException {
        sd.clearDirectory();
        sd.lock();
        try {
            NameNodeDirType dirType = (NameNodeDirType)sd.getStorageDirType();
            if (dirType.isOfType(NameNodeDirType.IMAGE)) {
                this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE));
            }
            if (dirType.isOfType(NameNodeDirType.EDITS)) {
                this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
            }
            sd.write();
        }
        finally {
            sd.unlock();
        }
        LOG.info("Storage directory " + sd.getRoot() + " has been successfully formatted.");
    }

    public void format() throws IOException {
        this.layoutVersion = -18;
        this.namespaceID = this.newNamespaceID();
        this.cTime = 0L;
        this.checkpointTime = FSNamesystem.now();
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            this.format(sd);
        }
    }

    private static void saveINode2Image(ByteBuffer name, INode node, DataOutputStream out) throws IOException {
        int nameLen = name.position();
        out.writeShort(nameLen);
        out.write(name.array(), name.arrayOffset(), nameLen);
        if (!node.isDirectory()) {
            INodeFile fileINode = (INodeFile)node;
            out.writeShort(fileINode.getReplication());
            out.writeLong(fileINode.getModificationTime());
            out.writeLong(fileINode.getAccessTime());
            out.writeLong(fileINode.getPreferredBlockSize());
            BlocksMap.BlockInfo[] blocks = fileINode.getBlocks();
            out.writeInt(blocks.length);
            for (BlocksMap.BlockInfo blk : blocks) {
                blk.write(out);
            }
            FILE_PERM.fromShort(fileINode.getFsPermissionShort());
            PermissionStatus.write(out, fileINode.getUserName(), fileINode.getGroupName(), FILE_PERM);
        } else {
            out.writeShort(0);
            out.writeLong(node.getModificationTime());
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeInt(-1);
            out.writeLong(node.getNsQuota());
            out.writeLong(node.getDsQuota());
            FILE_PERM.fromShort(node.getFsPermissionShort());
            PermissionStatus.write(out, node.getUserName(), node.getGroupName(), FILE_PERM);
        }
    }

    private static void saveImage(ByteBuffer parentPrefix, int prefixLength, INodeDirectory current, DataOutputStream out) throws IOException {
        int newPrefixLength = prefixLength;
        if (current.getChildrenRaw() == null) {
            return;
        }
        for (INode child : current.getChildren()) {
            parentPrefix.position(prefixLength);
            parentPrefix.put(PATH_SEPARATOR).put(child.getLocalNameBytes());
            FSImage.saveINode2Image(parentPrefix, child, out);
        }
        for (INode child : current.getChildren()) {
            if (!child.isDirectory()) continue;
            parentPrefix.position(prefixLength);
            parentPrefix.put(PATH_SEPARATOR).put(child.getLocalNameBytes());
            newPrefixLength = parentPrefix.position();
            FSImage.saveImage(parentPrefix, newPrefixLength, (INodeDirectory)child, out);
        }
        parentPrefix.position(prefixLength);
    }

    void loadDatanodes(int version, DataInputStream in) throws IOException {
        if (version > -3) {
            return;
        }
        if (version <= -12) {
            return;
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            DatanodeImage nodeImage = new DatanodeImage();
            nodeImage.readFields(in);
        }
    }

    private void loadFilesUnderConstruction(int version, DataInputStream in, FSNamesystem fs) throws IOException {
        FSDirectory fsDir = fs.dir;
        if (version > -13) {
            return;
        }
        int size = in.readInt();
        LOG.info("Number of files under construction = " + size);
        for (int i = 0; i < size; ++i) {
            INodeFileUnderConstruction cons = FSImage.readINodeUnderConstruction(in);
            String path = cons.getLocalName();
            INodeFile old = fsDir.getFileINode(path);
            if (old == null) {
                throw new IOException("Found lease for non-existent file " + path);
            }
            if (((INode)old).isDirectory()) {
                throw new IOException("Found lease for directory " + path);
            }
            INodeFile oldnode = old;
            fsDir.replaceNode(path, oldnode, cons);
            fs.leaseManager.addLease(cons.clientName, path);
        }
    }

    static INodeFileUnderConstruction readINodeUnderConstruction(DataInputStream in) throws IOException {
        byte[] name = FSImage.readBytes(in);
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlocksMap.BlockInfo[] blocks = new BlocksMap.BlockInfo[numBlocks];
        Block blk = new Block();
        for (int i = 0; i < numBlocks; ++i) {
            blk.readFields(in);
            blocks[i] = new BlocksMap.BlockInfo(blk, blockReplication);
        }
        PermissionStatus perm = PermissionStatus.read(in);
        String clientName = FSImage.readString(in);
        String clientMachine = FSImage.readString(in);
        int numLocs = in.readInt();
        DatanodeDescriptor[] locations = new DatanodeDescriptor[numLocs];
        for (int i = 0; i < numLocs; ++i) {
            locations[i] = new DatanodeDescriptor();
            locations[i].readFields(in);
        }
        return new INodeFileUnderConstruction(name, blockReplication, modificationTime, preferredBlockSize, blocks, perm, clientName, clientMachine, null);
    }

    static void writeINodeUnderConstruction(DataOutputStream out, INodeFileUnderConstruction cons, String path) throws IOException {
        FSImage.writeString(path, out);
        out.writeShort(cons.getReplication());
        out.writeLong(cons.getModificationTime());
        out.writeLong(cons.getPreferredBlockSize());
        int nrBlocks = cons.getBlocks().length;
        out.writeInt(nrBlocks);
        for (int i = 0; i < nrBlocks; ++i) {
            cons.getBlocks()[i].write(out);
        }
        cons.getPermissionStatus().write(out);
        FSImage.writeString(cons.getClientName(), out);
        FSImage.writeString(cons.getClientMachine(), out);
        out.writeInt(0);
    }

    void rollFSImage() throws IOException {
        File ckpt;
        Storage.StorageDirectory sd;
        if (this.ckptState != CheckpointStates.UPLOAD_DONE) {
            throw new IOException("Cannot roll fsImage before rolling edits log.");
        }
        if (!this.editLog.existsNew()) {
            throw new IOException("New Edits file does not exist");
        }
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            sd = it.next();
            ckpt = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
            if (ckpt.exists()) continue;
            throw new IOException("Checkpoint file " + ckpt + " does not exist");
        }
        this.editLog.purgeEditLog();
        it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            File curFile;
            sd = it.next();
            ckpt = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
            if (ckpt.renameTo(curFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE))) continue;
            curFile.delete();
            if (ckpt.renameTo(curFile)) continue;
            if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                this.editLog.processIOError(sd);
            }
            this.removedStorageDirs.add(sd);
            it.remove();
        }
        this.layoutVersion = -18;
        this.checkpointTime = FSNamesystem.now();
        it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
            if (!sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                File editsFile = FSImage.getImageFile(sd, NameNodeFile.EDITS);
                editsFile.delete();
            }
            if (!sd.getStorageDirType().isOfType(NameNodeDirType.IMAGE)) {
                File imageFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE);
                imageFile.delete();
            }
            try {
                sd.write();
            }
            catch (IOException e) {
                LOG.error("Cannot write file " + sd.getRoot(), e);
                if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                    this.editLog.processIOError(sd);
                }
                this.removedStorageDirs.add(sd);
                it.remove();
            }
        }
        this.ckptState = CheckpointStates.START;
    }

    CheckpointSignature rollEditLog() throws IOException {
        this.getEditLog().rollEditLog();
        this.ckptState = CheckpointStates.ROLLED_EDITS;
        return new CheckpointSignature(this);
    }

    void validateCheckpointUpload(CheckpointSignature sig) throws IOException {
        if (this.ckptState != CheckpointStates.ROLLED_EDITS) {
            throw new IOException("Namenode is not expecting an new image " + (Object)((Object)this.ckptState));
        }
        long modtime = this.getEditLog().getFsEditTime();
        if (sig.editsTime != modtime) {
            throw new IOException("Namenode has an edit log with timestamp of " + DATE_FORM.format(new Date(modtime)) + " but new checkpoint was created using editlog " + " with timestamp " + DATE_FORM.format(new Date(sig.editsTime)) + ". Checkpoint Aborted.");
        }
        sig.validateStorageInfo(this);
        this.ckptState = CheckpointStates.UPLOAD_START;
    }

    synchronized void checkpointUploadDone() {
        this.ckptState = CheckpointStates.UPLOAD_DONE;
    }

    void close() throws IOException {
        this.getEditLog().close();
        this.unlockAll();
    }

    File getFsImageName() {
        Storage.StorageDirectory sd = null;
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            sd = it.next();
        }
        return FSImage.getImageFile(sd, NameNodeFile.IMAGE);
    }

    public File getFsEditName() throws IOException {
        return this.getEditLog().getFsEditName();
    }

    File getFsTimeName() {
        Storage.StorageDirectory sd = null;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            sd = it.next();
        }
        return FSImage.getImageFile(sd, NameNodeFile.TIME);
    }

    File[] getFsImageNameCheckpoint() {
        ArrayList<File> list = new ArrayList<File>();
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            list.add(FSImage.getImageFile(it.next(), NameNodeFile.IMAGE_NEW));
        }
        return list.toArray(new File[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void corruptPreUpgradeStorage(File rootDir) throws IOException {
        File oldImageDir = new File(rootDir, "image");
        if (!oldImageDir.exists() && !oldImageDir.mkdir()) {
            throw new IOException("Cannot create directory " + oldImageDir);
        }
        File oldImage = new File(oldImageDir, "fsimage");
        if (!oldImage.exists() && !oldImage.createNewFile()) {
            throw new IOException("Cannot create file " + oldImage);
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldImage, "rws");
        try {
            this.writeCorruptedData(oldFile);
        }
        finally {
            oldFile.close();
        }
    }

    private boolean getDistributedUpgradeState() {
        return FSNamesystem.getFSNamesystem().getDistributedUpgradeState();
    }

    private int getDistributedUpgradeVersion() {
        return FSNamesystem.getFSNamesystem().getDistributedUpgradeVersion();
    }

    private void setDistributedUpgradeState(boolean uState, int uVersion) {
        FSNamesystem.getFSNamesystem().upgradeManager.setUpgradeState(uState, uVersion);
    }

    private void verifyDistributedUpgradeProgress(HdfsConstants.StartupOption startOpt) throws IOException {
        if (startOpt == HdfsConstants.StartupOption.ROLLBACK || startOpt == HdfsConstants.StartupOption.IMPORT) {
            return;
        }
        UpgradeManagerNamenode um = FSNamesystem.getFSNamesystem().upgradeManager;
        assert (um != null) : "FSNameSystem.upgradeManager is null.";
        if (startOpt != HdfsConstants.StartupOption.UPGRADE) {
            if (um.getUpgradeState()) {
                throw new IOException("\n   Previous distributed upgrade was not completed. \n   Please restart NameNode with -upgrade option.");
            }
            if (um.getDistributedUpgrades() != null) {
                throw new IOException("\n   Distributed upgrade for NameNode version " + um.getUpgradeVersion() + " to current LV " + -18 + " is required.\n   Please restart NameNode with -upgrade option.");
            }
        }
    }

    private void initializeDistributedUpgrade() throws IOException {
        UpgradeManagerNamenode um = FSNamesystem.getFSNamesystem().upgradeManager;
        if (!um.initializeUpgrade()) {
            return;
        }
        FSNamesystem.getFSNamesystem().getFSImage().writeAll();
        NameNode.LOG.info("\n   Distributed upgrade for NameNode version " + um.getUpgradeVersion() + " to current LV " + -18 + " is initialized.");
    }

    static Collection<File> getCheckpointDirs(Configuration conf, String defaultName) {
        Collection<String> dirNames = conf.getStringCollection("fs.checkpoint.dir");
        if (dirNames.size() == 0 && defaultName != null) {
            dirNames.add(defaultName);
        }
        ArrayList<File> dirs = new ArrayList<File>(dirNames.size());
        for (String name : dirNames) {
            dirs.add(new File(name));
        }
        return dirs;
    }

    static Collection<File> getCheckpointEditsDirs(Configuration conf, String defaultName) {
        Collection<String> dirNames = conf.getStringCollection("fs.checkpoint.edits.dir");
        if (dirNames.size() == 0 && defaultName != null) {
            dirNames.add(defaultName);
        }
        ArrayList<File> dirs = new ArrayList<File>(dirNames.size());
        for (String name : dirNames) {
            dirs.add(new File(name));
        }
        return dirs;
    }

    static String readString(DataInputStream in) throws IOException {
        U_STR.readFields(in);
        return U_STR.toString();
    }

    static String readString_EmptyAsNull(DataInputStream in) throws IOException {
        String s = FSImage.readString(in);
        return s.isEmpty() ? null : s;
    }

    static byte[] readBytes(DataInputStream in) throws IOException {
        U_STR.readFields(in);
        int len = U_STR.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(U_STR.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    static void writeString(String str, DataOutputStream out) throws IOException {
        U_STR.set(str);
        U_STR.write(out);
    }

    static class DatanodeImage
    implements Writable {
        DatanodeDescriptor node = new DatanodeDescriptor();

        DatanodeImage() {
        }

        @Override
        public void write(DataOutput out) throws IOException {
            new DatanodeID(this.node).write(out);
            out.writeLong(this.node.getCapacity());
            out.writeLong(this.node.getRemaining());
            out.writeLong(this.node.getLastUpdate());
            out.writeInt(this.node.getXceiverCount());
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            DatanodeID id = new DatanodeID();
            id.readFields(in);
            long capacity = in.readLong();
            long remaining = in.readLong();
            long lastUpdate = in.readLong();
            int xceiverCount = in.readInt();
            this.node.updateRegInfo(id);
            this.node.setStorageID(id.getStorageID());
            this.node.setCapacity(capacity);
            this.node.setRemaining(remaining);
            this.node.setLastUpdate(lastUpdate);
            this.node.setXceiverCount(xceiverCount);
        }
    }

    static enum NameNodeDirType implements Storage.StorageDirType
    {
        UNDEFINED,
        IMAGE,
        EDITS,
        IMAGE_AND_EDITS;


        @Override
        public Storage.StorageDirType getStorageDirType() {
            return this;
        }

        @Override
        public boolean isOfType(Storage.StorageDirType type) {
            if (this == IMAGE_AND_EDITS && (type == IMAGE || type == EDITS)) {
                return true;
            }
            return this == type;
        }
    }

    static enum CheckpointStates {
        START,
        ROLLED_EDITS,
        UPLOAD_START,
        UPLOAD_DONE;

    }

    static enum NameNodeFile {
        IMAGE("fsimage"),
        TIME("fstime"),
        EDITS("edits"),
        IMAGE_NEW("fsimage.ckpt"),
        EDITS_NEW("edits.new");

        private String fileName = null;

        private NameNodeFile(String name) {
            this.fileName = name;
        }

        String getName() {
            return this.fileName;
        }
    }
}

