/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.protocol;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.Block;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BlockMetaDataInfo
extends Block {
    static final WritableFactory FACTORY = new WritableFactory(){

        @Override
        public Writable newInstance() {
            return new BlockMetaDataInfo();
        }
    };
    private long lastScanTime;

    public BlockMetaDataInfo() {
    }

    public BlockMetaDataInfo(Block b, long lastScanTime) {
        super(b);
        this.lastScanTime = lastScanTime;
    }

    public long getLastScanTime() {
        return this.lastScanTime;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.lastScanTime);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.lastScanTime = in.readLong();
    }

    static {
        WritableFactories.setFactory(BlockMetaDataInfo.class, FACTORY);
    }
}

