/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.common;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.conf.HiveConf;

public class ServerUtils {
    public static final Log LOG = LogFactory.getLog(ServerUtils.class);

    public static void cleanUpScratchDir(HiveConf hiveConf) {
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_START_CLEANUP_SCRATCHDIR)) {
            String hiveScratchDir = hiveConf.get(HiveConf.ConfVars.SCRATCHDIR.varname);
            try {
                Path jobScratchDir = new Path(hiveScratchDir);
                LOG.info("Cleaning scratchDir : " + hiveScratchDir);
                FileSystem fileSystem = jobScratchDir.getFileSystem(hiveConf);
                fileSystem.delete(jobScratchDir, true);
            }
            catch (Throwable e) {
                LOG.warn("Unable to delete scratchDir : " + hiveScratchDir, e);
            }
        }
    }
}

