/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.io;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.io.HiveIOExceptionHandlerChain;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.RecordReader;
import java.io.IOException;

public class HiveIOExceptionHandlerUtil {
    private static ThreadLocal<HiveIOExceptionHandlerChain> handlerChainInstance = new ThreadLocal();

    private static HiveIOExceptionHandlerChain get(JobConf job) {
        HiveIOExceptionHandlerChain cache = handlerChainInstance.get();
        if (cache == null) {
            HiveIOExceptionHandlerChain toSet = HiveIOExceptionHandlerChain.getHiveIOExceptionHandlerChain(job);
            handlerChainInstance.set(toSet);
            cache = handlerChainInstance.get();
        }
        return cache;
    }

    public static RecordReader handleRecordReaderCreationException(Exception e, JobConf job) throws IOException {
        HiveIOExceptionHandlerChain ioExpectionHandlerChain = HiveIOExceptionHandlerUtil.get(job);
        if (ioExpectionHandlerChain != null) {
            return ioExpectionHandlerChain.handleRecordReaderCreationException(e);
        }
        throw new IOException(e);
    }

    public static boolean handleRecordReaderNextException(Exception e, JobConf job) throws IOException {
        HiveIOExceptionHandlerChain ioExpectionHandlerChain = HiveIOExceptionHandlerUtil.get(job);
        if (ioExpectionHandlerChain != null) {
            return ioExpectionHandlerChain.handleRecordReaderNextException(e);
        }
        throw new IOException(e);
    }
}

