/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.io;

import io.trino.hive.jdbc.;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configurable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.ChecksumException;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.ChecksumFileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataInputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.LocalDirAllocator;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.DataInputBuffer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.DataOutputBuffer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.IntWritable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.RawComparator;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.UTF8;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.VersionMismatchException;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparator;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableName;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CodecPool;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionCodec;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionInputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionOutputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.DefaultCodec;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.ZlibFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Deserializer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.SerializationFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Serializer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.MergeSort;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.NativeCodeLoader;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.PriorityQueue;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.Progress;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.Progressable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SequenceFile {
    private static final Log LOG = LogFactory.getLog(SequenceFile.class);
    private static final byte BLOCK_COMPRESS_VERSION = 4;
    private static final byte CUSTOM_COMPRESS_VERSION = 5;
    private static final byte VERSION_WITH_METADATA = 6;
    private static byte[] VERSION = new byte[]{83, 69, 81, 6};
    private static final int SYNC_ESCAPE = -1;
    private static final int SYNC_HASH_SIZE = 16;
    private static final int SYNC_SIZE = 20;
    public static final int SYNC_INTERVAL = 2000;

    private SequenceFile() {
    }

    @Deprecated
    public static CompressionType getCompressionType(Configuration job) {
        String name = job.get("io.seqfile.compression.type");
        return name == null ? CompressionType.RECORD : CompressionType.valueOf(name);
    }

    @Deprecated
    public static void setCompressionType(Configuration job, CompressionType val) {
        job.set("io.seqfile.compression.type", val.toString());
    }

    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass) throws IOException {
        return SequenceFile.createWriter(fs, conf, name, keyClass, valClass, SequenceFile.getCompressionType(conf));
    }

    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType) throws IOException {
        return SequenceFile.createWriter(fs, conf, name, keyClass, valClass, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), compressionType, new DefaultCodec(), null, new Metadata());
    }

    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, Progressable progress) throws IOException {
        return SequenceFile.createWriter(fs, conf, name, keyClass, valClass, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), compressionType, new DefaultCodec(), progress, new Metadata());
    }

    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec) throws IOException {
        return SequenceFile.createWriter(fs, conf, name, keyClass, valClass, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), compressionType, codec, null, new Metadata());
    }

    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(fs, conf, name, keyClass, valClass, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), compressionType, codec, progress, metadata);
    }

    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, CompressionType compressionType, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
        if (codec instanceof .GzipCodec && !NativeCodeLoader.isNativeCodeLoaded() && !ZlibFactory.isNativeZlibLoaded(conf)) {
            throw new IllegalArgumentException("SequenceFile doesn't work with GzipCodec without native-hadoop code!");
        }
        Writer writer = null;
        if (compressionType == CompressionType.NONE) {
            writer = new Writer(fs, conf, name, keyClass, valClass, bufferSize, replication, blockSize, progress, metadata);
        } else if (compressionType == CompressionType.RECORD) {
            writer = new RecordCompressWriter(fs, conf, name, keyClass, valClass, bufferSize, replication, blockSize, codec, progress, metadata);
        } else if (compressionType == CompressionType.BLOCK) {
            writer = new BlockCompressWriter(fs, conf, name, keyClass, valClass, bufferSize, replication, blockSize, codec, progress, metadata);
        }
        return writer;
    }

    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Progressable progress) throws IOException {
        Writer writer = SequenceFile.createWriter(fs, conf, name, keyClass, valClass, compressionType, codec, progress, new Metadata());
        return writer;
    }

    private static Writer createWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, boolean compress, boolean blockCompress, CompressionCodec codec, Metadata metadata) throws IOException {
        if (codec != null && codec instanceof .GzipCodec && !NativeCodeLoader.isNativeCodeLoaded() && !ZlibFactory.isNativeZlibLoaded(conf)) {
            throw new IllegalArgumentException("SequenceFile doesn't work with GzipCodec without native-hadoop code!");
        }
        Writer writer = null;
        writer = !compress ? new Writer(conf, out, keyClass, valClass, metadata) : (compress && !blockCompress ? new RecordCompressWriter(conf, out, keyClass, valClass, codec, metadata) : new BlockCompressWriter(conf, out, keyClass, valClass, codec, metadata));
        return writer;
    }

    private static Writer createWriter(FileSystem fs, Configuration conf, Path file, Class keyClass, Class valClass, boolean compress, boolean blockCompress, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
        if (codec != null && codec instanceof .GzipCodec && !NativeCodeLoader.isNativeCodeLoaded() && !ZlibFactory.isNativeZlibLoaded(conf)) {
            throw new IllegalArgumentException("SequenceFile doesn't work with GzipCodec without native-hadoop code!");
        }
        Writer writer = null;
        writer = !compress ? new Writer(fs, conf, file, keyClass, valClass, progress, metadata) : (compress && !blockCompress ? new RecordCompressWriter(fs, conf, file, keyClass, valClass, codec, progress, metadata) : new BlockCompressWriter(fs, conf, file, keyClass, valClass, codec, progress, metadata));
        return writer;
    }

    public static Writer createWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Metadata metadata) throws IOException {
        if (codec instanceof .GzipCodec && !NativeCodeLoader.isNativeCodeLoaded() && !ZlibFactory.isNativeZlibLoaded(conf)) {
            throw new IllegalArgumentException("SequenceFile doesn't work with GzipCodec without native-hadoop code!");
        }
        Writer writer = null;
        if (compressionType == CompressionType.NONE) {
            writer = new Writer(conf, out, keyClass, valClass, metadata);
        } else if (compressionType == CompressionType.RECORD) {
            writer = new RecordCompressWriter(conf, out, keyClass, valClass, codec, metadata);
        } else if (compressionType == CompressionType.BLOCK) {
            writer = new BlockCompressWriter(conf, out, keyClass, valClass, codec, metadata);
        }
        return writer;
    }

    public static Writer createWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec) throws IOException {
        Writer writer = SequenceFile.createWriter(conf, out, keyClass, valClass, compressionType, codec, new Metadata());
        return writer;
    }

    public static class Sorter {
        private RawComparator comparator;
        private MergeSort mergeSort;
        private Path[] inFiles;
        private Path outFile;
        private int memory;
        private int factor;
        private FileSystem fs = null;
        private Class keyClass;
        private Class valClass;
        private Configuration conf;
        private Progressable progressable = null;

        public Sorter(FileSystem fs, Class<? extends WritableComparable> keyClass, Class valClass, Configuration conf) {
            this(fs, WritableComparator.get(keyClass), keyClass, valClass, conf);
        }

        public Sorter(FileSystem fs, RawComparator comparator, Class keyClass, Class valClass, Configuration conf) {
            this.fs = fs;
            this.comparator = comparator;
            this.keyClass = keyClass;
            this.valClass = valClass;
            this.memory = conf.getInt("io.sort.mb", 100) * 1024 * 1024;
            this.factor = conf.getInt("io.sort.factor", 100);
            this.conf = conf;
        }

        public void setFactor(int factor) {
            this.factor = factor;
        }

        public int getFactor() {
            return this.factor;
        }

        public void setMemory(int memory) {
            this.memory = memory;
        }

        public int getMemory() {
            return this.memory;
        }

        public void setProgressable(Progressable progressable) {
            this.progressable = progressable;
        }

        public void sort(Path[] inFiles, Path outFile, boolean deleteInput) throws IOException {
            if (this.fs.exists(outFile)) {
                throw new IOException("already exists: " + outFile);
            }
            this.inFiles = inFiles;
            this.outFile = outFile;
            int segments = this.sortPass(deleteInput);
            if (segments > 1) {
                this.mergePass(outFile.getParent());
            }
        }

        public RawKeyValueIterator sortAndIterate(Path[] inFiles, Path tempDir, boolean deleteInput) throws IOException {
            Path outFile = new Path(tempDir + "/" + "all.2");
            if (this.fs.exists(outFile)) {
                throw new IOException("already exists: " + outFile);
            }
            this.inFiles = inFiles;
            this.outFile = outFile;
            int segments = this.sortPass(deleteInput);
            if (segments > 1) {
                return this.merge(outFile.suffix(".0"), outFile.suffix(".0.index"), tempDir);
            }
            if (segments == 1) {
                return this.merge(new Path[]{outFile}, true, tempDir);
            }
            return null;
        }

        public void sort(Path inFile, Path outFile) throws IOException {
            this.sort(new Path[]{inFile}, outFile, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int sortPass(boolean deleteInput) throws IOException {
            LOG.debug("running sort pass");
            SortPass sortPass = new SortPass();
            sortPass.setProgressable(this.progressable);
            this.mergeSort = new MergeSort(sortPass.new SortPass.SeqFileComparator());
            try {
                int n = sortPass.run(deleteInput);
                return n;
            }
            finally {
                sortPass.close();
            }
        }

        public RawKeyValueIterator merge(List<SegmentDescriptor> segments, Path tmpDir) throws IOException {
            MergeQueue mQueue = new MergeQueue(segments, tmpDir, this.progressable);
            return mQueue.merge();
        }

        public RawKeyValueIterator merge(Path[] inNames, boolean deleteInputs, Path tmpDir) throws IOException {
            return this.merge(inNames, deleteInputs, inNames.length < this.factor ? inNames.length : this.factor, tmpDir);
        }

        public RawKeyValueIterator merge(Path[] inNames, boolean deleteInputs, int factor, Path tmpDir) throws IOException {
            ArrayList<SegmentDescriptor> a = new ArrayList<SegmentDescriptor>();
            for (int i = 0; i < inNames.length; ++i) {
                SegmentDescriptor s = new SegmentDescriptor(0L, this.fs.getLength(inNames[i]), inNames[i]);
                s.preserveInput(!deleteInputs);
                s.doSync();
                a.add(s);
            }
            this.factor = factor;
            MergeQueue mQueue = new MergeQueue(a, tmpDir, this.progressable);
            return mQueue.merge();
        }

        public RawKeyValueIterator merge(Path[] inNames, Path tempDir, boolean deleteInputs) throws IOException {
            this.outFile = new Path(tempDir + "/" + "merged");
            ArrayList<SegmentDescriptor> a = new ArrayList<SegmentDescriptor>();
            for (int i = 0; i < inNames.length; ++i) {
                SegmentDescriptor s = new SegmentDescriptor(0L, this.fs.getLength(inNames[i]), inNames[i]);
                s.preserveInput(!deleteInputs);
                s.doSync();
                a.add(s);
            }
            this.factor = inNames.length < this.factor ? inNames.length : this.factor;
            MergeQueue mQueue = new MergeQueue(a, tempDir, this.progressable);
            return mQueue.merge();
        }

        public Writer cloneFileAttributes(Path inputFile, Path outputFile, Progressable prog) throws IOException {
            FileSystem srcFileSys = inputFile.getFileSystem(this.conf);
            Reader reader = new Reader(srcFileSys, inputFile, 4096, this.conf, true);
            boolean compress = reader.isCompressed();
            boolean blockCompress = reader.isBlockCompressed();
            CompressionCodec codec = reader.getCompressionCodec();
            reader.close();
            Writer writer = SequenceFile.createWriter(outputFile.getFileSystem(this.conf), this.conf, outputFile, this.keyClass, this.valClass, compress, blockCompress, codec, prog, new Metadata());
            return writer;
        }

        public void writeFile(RawKeyValueIterator records, Writer writer) throws IOException {
            while (records.next()) {
                writer.appendRaw(records.getKey().getData(), 0, records.getKey().getLength(), records.getValue());
            }
            writer.sync();
        }

        public void merge(Path[] inFiles, Path outFile) throws IOException {
            if (this.fs.exists(outFile)) {
                throw new IOException("already exists: " + outFile);
            }
            RawKeyValueIterator r = this.merge(inFiles, false, outFile.getParent());
            Writer writer = this.cloneFileAttributes(inFiles[0], outFile, null);
            this.writeFile(r, writer);
            writer.close();
        }

        private int mergePass(Path tmpDir) throws IOException {
            LOG.debug("running merge pass");
            Writer writer = this.cloneFileAttributes(this.outFile.suffix(".0"), this.outFile, null);
            RawKeyValueIterator r = this.merge(this.outFile.suffix(".0"), this.outFile.suffix(".0.index"), tmpDir);
            this.writeFile(r, writer);
            writer.close();
            return 0;
        }

        private RawKeyValueIterator merge(Path inName, Path indexIn, Path tmpDir) throws IOException {
            SegmentContainer container = new SegmentContainer(inName, indexIn);
            MergeQueue mQueue = new MergeQueue(container.getSegmentList(), tmpDir, this.progressable);
            return mQueue.merge();
        }

        private class SegmentContainer {
            private int numSegmentsCleanedUp = 0;
            private int numSegmentsContained;
            private Path inName;
            private ArrayList<SegmentDescriptor> segments = new ArrayList();

            public SegmentContainer(Path inName, Path indexIn) throws IOException {
                FSDataInputStream fsIndexIn = Sorter.this.fs.open(indexIn);
                long end = Sorter.this.fs.getLength(indexIn);
                while (fsIndexIn.getPos() < end) {
                    long segmentOffset = WritableUtils.readVLong(fsIndexIn);
                    long segmentLength = WritableUtils.readVLong(fsIndexIn);
                    Path segmentName = inName;
                    this.segments.add(new LinkedSegmentsDescriptor(segmentOffset, segmentLength, segmentName, this));
                }
                fsIndexIn.close();
                Sorter.this.fs.delete(indexIn, true);
                this.numSegmentsContained = this.segments.size();
                this.inName = inName;
            }

            public List<SegmentDescriptor> getSegmentList() {
                return this.segments;
            }

            public void cleanup() throws IOException {
                ++this.numSegmentsCleanedUp;
                if (this.numSegmentsCleanedUp == this.numSegmentsContained) {
                    Sorter.this.fs.delete(this.inName, true);
                }
            }
        }

        private class LinkedSegmentsDescriptor
        extends SegmentDescriptor {
            SegmentContainer parentContainer;

            public LinkedSegmentsDescriptor(long segmentOffset, long segmentLength, Path segmentPathName, SegmentContainer parent) {
                super(segmentOffset, segmentLength, segmentPathName);
                this.parentContainer = null;
                this.parentContainer = parent;
            }

            @Override
            public void cleanup() throws IOException {
                ((SegmentDescriptor)this).close();
                if (super.shouldPreserveInput()) {
                    return;
                }
                this.parentContainer.cleanup();
            }
        }

        public class SegmentDescriptor
        implements Comparable {
            long segmentOffset;
            long segmentLength;
            Path segmentPathName;
            boolean ignoreSync = true;
            private Reader in = null;
            private DataOutputBuffer rawKey = null;
            private boolean preserveInput = false;

            public SegmentDescriptor(long segmentOffset, long segmentLength, Path segmentPathName) {
                this.segmentOffset = segmentOffset;
                this.segmentLength = segmentLength;
                this.segmentPathName = segmentPathName;
            }

            public void doSync() {
                this.ignoreSync = false;
            }

            public void preserveInput(boolean preserve) {
                this.preserveInput = preserve;
            }

            public boolean shouldPreserveInput() {
                return this.preserveInput;
            }

            public int compareTo(Object o) {
                SegmentDescriptor that = (SegmentDescriptor)o;
                if (this.segmentLength != that.segmentLength) {
                    return this.segmentLength < that.segmentLength ? -1 : 1;
                }
                if (this.segmentOffset != that.segmentOffset) {
                    return this.segmentOffset < that.segmentOffset ? -1 : 1;
                }
                return this.segmentPathName.toString().compareTo(that.segmentPathName.toString());
            }

            public boolean equals(Object o) {
                if (!(o instanceof SegmentDescriptor)) {
                    return false;
                }
                SegmentDescriptor that = (SegmentDescriptor)o;
                return this.segmentLength == that.segmentLength && this.segmentOffset == that.segmentOffset && this.segmentPathName.toString().equals(that.segmentPathName.toString());
            }

            public int hashCode() {
                return 629 + (int)(this.segmentOffset ^ this.segmentOffset >>> 32);
            }

            public boolean nextRawKey() throws IOException {
                if (this.in == null) {
                    int bufferSize = Sorter.this.conf.getInt("io.file.buffer.size", 4096);
                    if (Sorter.this.fs.getUri().getScheme().startsWith("ramfs")) {
                        bufferSize = Sorter.this.conf.getInt("io.bytes.per.checksum", 512);
                    }
                    Reader reader = new Reader(Sorter.this.fs, this.segmentPathName, bufferSize, this.segmentOffset, this.segmentLength, Sorter.this.conf, false);
                    if (this.ignoreSync) {
                        Reader.access$2802(reader, null);
                    }
                    if (reader.getKeyClass() != Sorter.this.keyClass) {
                        throw new IOException("wrong key class: " + reader.getKeyClass() + " is not " + Sorter.this.keyClass);
                    }
                    if (reader.getValueClass() != Sorter.this.valClass) {
                        throw new IOException("wrong value class: " + reader.getValueClass() + " is not " + Sorter.this.valClass);
                    }
                    this.in = reader;
                    this.rawKey = new DataOutputBuffer();
                }
                this.rawKey.reset();
                int keyLength = this.in.nextRawKey(this.rawKey);
                return keyLength >= 0;
            }

            public int nextRawValue(ValueBytes rawValue) throws IOException {
                int valLength = this.in.nextRawValue(rawValue);
                return valLength;
            }

            public DataOutputBuffer getKey() {
                return this.rawKey;
            }

            private void close() throws IOException {
                this.in.close();
                this.in = null;
            }

            public void cleanup() throws IOException {
                this.close();
                if (!this.preserveInput) {
                    Sorter.this.fs.delete(this.segmentPathName, true);
                }
            }
        }

        private class MergeQueue
        extends PriorityQueue
        implements RawKeyValueIterator {
            private boolean compress;
            private boolean blockCompress;
            private DataOutputBuffer rawKey = new DataOutputBuffer();
            private ValueBytes rawValue;
            private long totalBytesProcessed;
            private float progPerByte;
            private Progress mergeProgress = new Progress();
            private Path tmpDir;
            private Progressable progress = null;
            private SegmentDescriptor minSegment;
            private Map<SegmentDescriptor, Void> sortedSegmentSizes = new TreeMap<SegmentDescriptor, Void>();

            public void put(SegmentDescriptor stream) throws IOException {
                if (this.size() == 0) {
                    this.compress = stream.in.isCompressed();
                    this.blockCompress = stream.in.isBlockCompressed();
                } else if (this.compress != stream.in.isCompressed() || this.blockCompress != stream.in.isBlockCompressed()) {
                    throw new IOException("All merged files must be compressed or not.");
                }
                super.put(stream);
            }

            public MergeQueue(List<SegmentDescriptor> segments, Path tmpDir, Progressable progress) {
                int size = segments.size();
                for (int i = 0; i < size; ++i) {
                    this.sortedSegmentSizes.put(segments.get(i), null);
                }
                this.tmpDir = tmpDir;
                this.progress = progress;
            }

            @Override
            protected boolean lessThan(Object a, Object b) {
                if (this.progress != null) {
                    this.progress.progress();
                }
                SegmentDescriptor msa = (SegmentDescriptor)a;
                SegmentDescriptor msb = (SegmentDescriptor)b;
                return Sorter.this.comparator.compare(msa.getKey().getData(), 0, msa.getKey().getLength(), msb.getKey().getData(), 0, msb.getKey().getLength()) < 0;
            }

            @Override
            public void close() throws IOException {
                SegmentDescriptor ms;
                while ((ms = (SegmentDescriptor)this.pop()) != null) {
                    ms.cleanup();
                }
                this.minSegment = null;
            }

            @Override
            public DataOutputBuffer getKey() throws IOException {
                return this.rawKey;
            }

            @Override
            public ValueBytes getValue() throws IOException {
                return this.rawValue;
            }

            @Override
            public boolean next() throws IOException {
                if (this.size() == 0) {
                    return false;
                }
                if (this.minSegment != null) {
                    this.adjustPriorityQueue(this.minSegment);
                    if (this.size() == 0) {
                        this.minSegment = null;
                        return false;
                    }
                }
                this.minSegment = (SegmentDescriptor)this.top();
                long startPos = this.minSegment.in.getPosition();
                this.rawKey = this.minSegment.getKey();
                if (this.rawValue == null) {
                    this.rawValue = this.minSegment.in.createValueBytes();
                }
                this.minSegment.nextRawValue(this.rawValue);
                long endPos = this.minSegment.in.getPosition();
                this.updateProgress(endPos - startPos);
                return true;
            }

            @Override
            public Progress getProgress() {
                return this.mergeProgress;
            }

            private void adjustPriorityQueue(SegmentDescriptor ms) throws IOException {
                long startPos = ms.in.getPosition();
                boolean hasNext = ms.nextRawKey();
                long endPos = ms.in.getPosition();
                this.updateProgress(endPos - startPos);
                if (hasNext) {
                    this.adjustTop();
                } else {
                    this.pop();
                    ms.cleanup();
                }
            }

            private void updateProgress(long bytesProcessed) {
                this.totalBytesProcessed += bytesProcessed;
                if (this.progPerByte > 0.0f) {
                    this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
                }
            }

            public RawKeyValueIterator merge() throws IOException {
                int numSegments = this.sortedSegmentSizes.size();
                int origFactor = Sorter.this.factor;
                int passNo = 1;
                LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");
                while (true) {
                    Sorter.this.factor = this.getPassFactor(passNo, numSegments);
                    ArrayList<SegmentDescriptor> segmentsToMerge = new ArrayList<SegmentDescriptor>();
                    int segmentsConsidered = 0;
                    int numSegmentsToConsider = Sorter.this.factor;
                    while (true) {
                        SegmentDescriptor[] mStream = this.getSegmentDescriptors(numSegmentsToConsider);
                        for (int i = 0; i < mStream.length; ++i) {
                            if (mStream[i].nextRawKey()) {
                                segmentsToMerge.add(mStream[i]);
                                ++segmentsConsidered;
                                this.updateProgress(mStream[i].in.getPosition());
                                continue;
                            }
                            mStream[i].cleanup();
                            --numSegments;
                        }
                        if (segmentsConsidered == Sorter.this.factor || this.sortedSegmentSizes.size() == 0) break;
                        numSegmentsToConsider = Sorter.this.factor - segmentsConsidered;
                    }
                    this.initialize(segmentsToMerge.size());
                    this.clear();
                    for (int i = 0; i < segmentsToMerge.size(); ++i) {
                        this.put((SegmentDescriptor)segmentsToMerge.get(i));
                    }
                    if (numSegments <= Sorter.this.factor) {
                        long totalBytes = 0L;
                        for (int i = 0; i < segmentsToMerge.size(); ++i) {
                            totalBytes += ((SegmentDescriptor)segmentsToMerge.get((int)i)).segmentLength;
                        }
                        if (totalBytes != 0L) {
                            this.progPerByte = 1.0f / (float)totalBytes;
                        }
                        Sorter.this.factor = origFactor;
                        return this;
                    }
                    long approxOutputSize = 0L;
                    for (SegmentDescriptor s : segmentsToMerge) {
                        approxOutputSize = (long)((double)approxOutputSize + ((double)s.segmentLength + ChecksumFileSystem.getApproxChkSumLength(s.segmentLength)));
                    }
                    Path tmpFilename = new Path(this.tmpDir, "intermediate").suffix("." + passNo);
                    Path outputFile = lDirAlloc.getLocalPathForWrite(tmpFilename.toString(), approxOutputSize, Sorter.this.conf);
                    LOG.debug("writing intermediate results to " + outputFile);
                    Writer writer = Sorter.this.cloneFileAttributes(Sorter.this.fs.makeQualified(((SegmentDescriptor)segmentsToMerge.get((int)0)).segmentPathName), Sorter.this.fs.makeQualified(outputFile), null);
                    writer.sync = null;
                    Sorter.this.writeFile(this, writer);
                    writer.close();
                    this.close();
                    SegmentDescriptor tempSegment = new SegmentDescriptor(0L, Sorter.this.fs.getLength(outputFile), outputFile);
                    this.sortedSegmentSizes.put(tempSegment, null);
                    numSegments = this.sortedSegmentSizes.size();
                    ++passNo;
                    Sorter.this.factor = origFactor;
                }
            }

            public int getPassFactor(int passNo, int numSegments) {
                if (passNo > 1 || numSegments <= Sorter.this.factor || Sorter.this.factor == 1) {
                    return Sorter.this.factor;
                }
                int mod = (numSegments - 1) % (Sorter.this.factor - 1);
                if (mod == 0) {
                    return Sorter.this.factor;
                }
                return mod + 1;
            }

            public SegmentDescriptor[] getSegmentDescriptors(int numDescriptors) {
                if (numDescriptors > this.sortedSegmentSizes.size()) {
                    numDescriptors = this.sortedSegmentSizes.size();
                }
                SegmentDescriptor[] SegmentDescriptors = new SegmentDescriptor[numDescriptors];
                Iterator<SegmentDescriptor> iter = this.sortedSegmentSizes.keySet().iterator();
                int i = 0;
                while (i < numDescriptors) {
                    SegmentDescriptors[i++] = iter.next();
                    iter.remove();
                }
                return SegmentDescriptors;
            }
        }

        public static interface RawKeyValueIterator {
            public DataOutputBuffer getKey() throws IOException;

            public ValueBytes getValue() throws IOException;

            public boolean next() throws IOException;

            public void close() throws IOException;

            public Progress getProgress();
        }

        private class SortPass {
            private int memoryLimit;
            private int recordLimit;
            private DataOutputBuffer rawKeys;
            private byte[] rawBuffer;
            private int[] keyOffsets;
            private int[] pointers;
            private int[] pointersCopy;
            private int[] keyLengths;
            private ValueBytes[] rawValues;
            private ArrayList segmentLengths;
            private Reader in;
            private FSDataOutputStream out;
            private FSDataOutputStream indexOut;
            private Path outName;
            private Progressable progressable;

            private SortPass() {
                this.memoryLimit = Sorter.this.memory / 4;
                this.recordLimit = 1000000;
                this.rawKeys = new DataOutputBuffer();
                this.keyOffsets = new int[1024];
                this.pointers = new int[this.keyOffsets.length];
                this.pointersCopy = new int[this.keyOffsets.length];
                this.keyLengths = new int[this.keyOffsets.length];
                this.rawValues = new ValueBytes[this.keyOffsets.length];
                this.segmentLengths = new ArrayList();
                this.in = null;
                this.out = null;
                this.indexOut = null;
                this.progressable = null;
            }

            public int run(boolean deleteInput) throws IOException {
                int segments = 0;
                int currentFile = 0;
                boolean atEof = currentFile >= Sorter.this.inFiles.length;
                boolean isCompressed = false;
                boolean isBlockCompressed = false;
                CompressionCodec codec = null;
                this.segmentLengths.clear();
                if (atEof) {
                    return 0;
                }
                this.in = new Reader(Sorter.this.fs, Sorter.this.inFiles[currentFile], Sorter.this.conf);
                isCompressed = this.in.isCompressed();
                isBlockCompressed = this.in.isBlockCompressed();
                codec = this.in.getCompressionCodec();
                for (int i = 0; i < this.rawValues.length; ++i) {
                    this.rawValues[i] = null;
                }
                while (!atEof) {
                    int count = 0;
                    int bytesProcessed = 0;
                    this.rawKeys.reset();
                    while (!atEof && bytesProcessed < this.memoryLimit && count < this.recordLimit) {
                        int keyOffset = this.rawKeys.getLength();
                        ValueBytes rawValue = count == this.keyOffsets.length || this.rawValues[count] == null ? this.in.createValueBytes() : this.rawValues[count];
                        int recordLength = this.in.nextRaw(this.rawKeys, rawValue);
                        if (recordLength == -1) {
                            this.in.close();
                            if (deleteInput) {
                                Sorter.this.fs.delete(Sorter.this.inFiles[currentFile], true);
                            }
                            boolean bl = atEof = ++currentFile >= Sorter.this.inFiles.length;
                            if (!atEof) {
                                this.in = new Reader(Sorter.this.fs, Sorter.this.inFiles[currentFile], Sorter.this.conf);
                                continue;
                            }
                            this.in = null;
                            continue;
                        }
                        int keyLength = this.rawKeys.getLength() - keyOffset;
                        if (count == this.keyOffsets.length) {
                            this.grow();
                        }
                        this.keyOffsets[count] = keyOffset;
                        this.pointers[count] = count;
                        this.keyLengths[count] = keyLength;
                        this.rawValues[count] = rawValue;
                        bytesProcessed += recordLength;
                        ++count;
                    }
                    LOG.debug("flushing segment " + segments);
                    this.rawBuffer = this.rawKeys.getData();
                    this.sort(count);
                    if (this.progressable != null) {
                        this.progressable.progress();
                    }
                    this.flush(count, bytesProcessed, isCompressed, isBlockCompressed, codec, segments == 0 && atEof);
                    ++segments;
                }
                return segments;
            }

            public void close() throws IOException {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                if (this.indexOut != null) {
                    this.indexOut.close();
                }
            }

            private void grow() {
                int newLength = this.keyOffsets.length * 3 / 2;
                this.keyOffsets = this.grow(this.keyOffsets, newLength);
                this.pointers = this.grow(this.pointers, newLength);
                this.pointersCopy = new int[newLength];
                this.keyLengths = this.grow(this.keyLengths, newLength);
                this.rawValues = this.grow(this.rawValues, newLength);
            }

            private int[] grow(int[] old, int newLength) {
                int[] result = new int[newLength];
                System.arraycopy(old, 0, result, 0, old.length);
                return result;
            }

            private ValueBytes[] grow(ValueBytes[] old, int newLength) {
                ValueBytes[] result = new ValueBytes[newLength];
                System.arraycopy(old, 0, result, 0, old.length);
                for (int i = old.length; i < newLength; ++i) {
                    result[i] = null;
                }
                return result;
            }

            private void flush(int count, int bytesProcessed, boolean isCompressed, boolean isBlockCompressed, CompressionCodec codec, boolean done) throws IOException {
                if (this.out == null) {
                    this.outName = done ? Sorter.this.outFile : Sorter.this.outFile.suffix(".0");
                    this.out = Sorter.this.fs.create(this.outName);
                    if (!done) {
                        this.indexOut = Sorter.this.fs.create(this.outName.suffix(".index"));
                    }
                }
                long segmentStart = this.out.getPos();
                Writer writer = SequenceFile.createWriter(Sorter.this.conf, this.out, Sorter.this.keyClass, Sorter.this.valClass, isCompressed, isBlockCompressed, codec, new Metadata());
                if (!done) {
                    writer.sync = null;
                }
                for (int i = 0; i < count; ++i) {
                    int p = this.pointers[i];
                    writer.appendRaw(this.rawBuffer, this.keyOffsets[p], this.keyLengths[p], this.rawValues[p]);
                }
                writer.close();
                if (!done) {
                    WritableUtils.writeVLong(this.indexOut, segmentStart);
                    WritableUtils.writeVLong(this.indexOut, this.out.getPos() - segmentStart);
                    this.indexOut.flush();
                }
            }

            private void sort(int count) {
                System.arraycopy(this.pointers, 0, this.pointersCopy, 0, count);
                Sorter.this.mergeSort.mergeSort(this.pointersCopy, this.pointers, 0, count);
            }

            public void setProgressable(Progressable progressable) {
                this.progressable = progressable;
            }

            class SeqFileComparator
            implements Comparator<IntWritable> {
                SeqFileComparator() {
                }

                @Override
                public int compare(IntWritable I, IntWritable J) {
                    return Sorter.this.comparator.compare(SortPass.this.rawBuffer, SortPass.this.keyOffsets[I.get()], SortPass.this.keyLengths[I.get()], SortPass.this.rawBuffer, SortPass.this.keyOffsets[J.get()], SortPass.this.keyLengths[J.get()]);
                }
            }
        }
    }

    public static class Reader
    implements Closeable {
        private Path file;
        private FSDataInputStream in;
        private DataOutputBuffer outBuf = new DataOutputBuffer();
        private byte version;
        private String keyClassName;
        private String valClassName;
        private Class keyClass;
        private Class valClass;
        private CompressionCodec codec = null;
        private Metadata metadata = null;
        private byte[] sync = new byte[16];
        private byte[] syncCheck = new byte[16];
        private boolean syncSeen;
        private long end;
        private int keyLength;
        private int recordLength;
        private boolean decompress;
        private boolean blockCompressed;
        private Configuration conf;
        private int noBufferedRecords = 0;
        private boolean lazyDecompress = true;
        private boolean valuesDecompressed = true;
        private int noBufferedKeys = 0;
        private int noBufferedValues = 0;
        private DataInputBuffer keyLenBuffer = null;
        private CompressionInputStream keyLenInFilter = null;
        private DataInputStream keyLenIn = null;
        private .Decompressor keyLenDecompressor = null;
        private DataInputBuffer keyBuffer = null;
        private CompressionInputStream keyInFilter = null;
        private DataInputStream keyIn = null;
        private .Decompressor keyDecompressor = null;
        private DataInputBuffer valLenBuffer = null;
        private CompressionInputStream valLenInFilter = null;
        private DataInputStream valLenIn = null;
        private .Decompressor valLenDecompressor = null;
        private DataInputBuffer valBuffer = null;
        private CompressionInputStream valInFilter = null;
        private DataInputStream valIn = null;
        private .Decompressor valDecompressor = null;
        private Deserializer keyDeserializer;
        private Deserializer valDeserializer;

        public Reader(FileSystem fs, Path file, Configuration conf) throws IOException {
            this(fs, file, conf.getInt("io.file.buffer.size", 4096), conf, false);
        }

        private Reader(FileSystem fs, Path file, int bufferSize, Configuration conf, boolean tempReader) throws IOException {
            this(fs, file, bufferSize, 0L, fs.getLength(file), conf, tempReader);
        }

        private Reader(FileSystem fs, Path file, int bufferSize, long start, long length, Configuration conf, boolean tempReader) throws IOException {
            this.file = file;
            this.in = this.openFile(fs, file, bufferSize, length);
            this.conf = conf;
            this.seek(start);
            this.end = this.in.getPos() + length;
            this.init(tempReader);
        }

        protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
            return fs.open(file, bufferSize);
        }

        private void init(boolean tempReader) throws IOException {
            byte[] versionBlock = new byte[VERSION.length];
            this.in.readFully(versionBlock);
            if (versionBlock[0] != VERSION[0] || versionBlock[1] != VERSION[1] || versionBlock[2] != VERSION[2]) {
                throw new IOException(this.file + " not a SequenceFile");
            }
            this.version = versionBlock[3];
            if (this.version > VERSION[3]) {
                throw new VersionMismatchException(VERSION[3], this.version);
            }
            if (this.version < 4) {
                UTF8 className = new UTF8();
                className.readFields(this.in);
                this.keyClassName = className.toString();
                className.readFields(this.in);
                this.valClassName = className.toString();
            } else {
                this.keyClassName = Text.readString(this.in);
                this.valClassName = Text.readString(this.in);
            }
            this.decompress = this.version > 2 ? this.in.readBoolean() : false;
            this.blockCompressed = this.version >= 4 ? this.in.readBoolean() : false;
            if (this.decompress) {
                if (this.version >= 5) {
                    String codecClassname = Text.readString(this.in);
                    try {
                        Class<CompressionCodec> codecClass = this.conf.getClassByName(codecClassname).asSubclass(CompressionCodec.class);
                        this.codec = ReflectionUtils.newInstance(codecClass, this.conf);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IllegalArgumentException("Unknown codec: " + codecClassname, cnfe);
                    }
                } else {
                    this.codec = new DefaultCodec();
                    ((Configurable)((Object)this.codec)).setConf(this.conf);
                }
            }
            this.metadata = new Metadata();
            if (this.version >= 6) {
                this.metadata.readFields(this.in);
            }
            if (this.version > 1) {
                this.in.readFully(this.sync);
            }
            if (!tempReader) {
                this.valBuffer = new DataInputBuffer();
                if (this.decompress) {
                    this.valDecompressor = CodecPool.getDecompressor(this.codec);
                    this.valInFilter = this.codec.createInputStream(this.valBuffer, this.valDecompressor);
                    this.valIn = new DataInputStream(this.valInFilter);
                } else {
                    this.valIn = this.valBuffer;
                }
                if (this.blockCompressed) {
                    this.keyLenBuffer = new DataInputBuffer();
                    this.keyBuffer = new DataInputBuffer();
                    this.valLenBuffer = new DataInputBuffer();
                    this.keyLenDecompressor = CodecPool.getDecompressor(this.codec);
                    this.keyLenInFilter = this.codec.createInputStream(this.keyLenBuffer, this.keyLenDecompressor);
                    this.keyLenIn = new DataInputStream(this.keyLenInFilter);
                    this.keyDecompressor = CodecPool.getDecompressor(this.codec);
                    this.keyInFilter = this.codec.createInputStream(this.keyBuffer, this.keyDecompressor);
                    this.keyIn = new DataInputStream(this.keyInFilter);
                    this.valLenDecompressor = CodecPool.getDecompressor(this.codec);
                    this.valLenInFilter = this.codec.createInputStream(this.valLenBuffer, this.valLenDecompressor);
                    this.valLenIn = new DataInputStream(this.valLenInFilter);
                }
                SerializationFactory serializationFactory = new SerializationFactory(this.conf);
                this.keyDeserializer = this.getDeserializer(serializationFactory, this.getKeyClass());
                if (!this.blockCompressed) {
                    this.keyDeserializer.open(this.valBuffer);
                } else {
                    this.keyDeserializer.open(this.keyIn);
                }
                this.valDeserializer = this.getDeserializer(serializationFactory, this.getValueClass());
                this.valDeserializer.open(this.valIn);
            }
        }

        private Deserializer getDeserializer(SerializationFactory sf, Class c) {
            return sf.getDeserializer(c);
        }

        @Override
        public synchronized void close() throws IOException {
            CodecPool.returnDecompressor(this.keyLenDecompressor);
            CodecPool.returnDecompressor(this.keyDecompressor);
            CodecPool.returnDecompressor(this.valLenDecompressor);
            CodecPool.returnDecompressor(this.valDecompressor);
            this.keyDecompressor = null;
            this.keyLenDecompressor = null;
            this.valDecompressor = null;
            this.valLenDecompressor = null;
            if (this.keyDeserializer != null) {
                this.keyDeserializer.close();
            }
            if (this.valDeserializer != null) {
                this.valDeserializer.close();
            }
            this.in.close();
        }

        public String getKeyClassName() {
            return this.keyClassName;
        }

        public synchronized Class<?> getKeyClass() {
            if (null == this.keyClass) {
                try {
                    this.keyClass = WritableName.getClass(this.getKeyClassName(), this.conf);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.keyClass;
        }

        public String getValueClassName() {
            return this.valClassName;
        }

        public synchronized Class<?> getValueClass() {
            if (null == this.valClass) {
                try {
                    this.valClass = WritableName.getClass(this.getValueClassName(), this.conf);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.valClass;
        }

        public boolean isCompressed() {
            return this.decompress;
        }

        public boolean isBlockCompressed() {
            return this.blockCompressed;
        }

        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        Configuration getConf() {
            return this.conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void readBuffer(DataInputBuffer buffer, CompressionInputStream filter) throws IOException {
            DataOutputBuffer dataBuffer = new DataOutputBuffer();
            try {
                int dataBufferLength = WritableUtils.readVInt(this.in);
                dataBuffer.write(this.in, dataBufferLength);
                buffer.reset(dataBuffer.getData(), 0, dataBuffer.getLength());
            }
            finally {
                dataBuffer.close();
            }
            filter.resetState();
        }

        private synchronized void readBlock() throws IOException {
            if (this.lazyDecompress && !this.valuesDecompressed) {
                this.in.seek((long)WritableUtils.readVInt(this.in) + this.in.getPos());
                this.in.seek((long)WritableUtils.readVInt(this.in) + this.in.getPos());
            }
            this.noBufferedKeys = 0;
            this.noBufferedValues = 0;
            this.noBufferedRecords = 0;
            this.valuesDecompressed = false;
            if (this.sync != null) {
                this.in.readInt();
                this.in.readFully(this.syncCheck);
                if (!Arrays.equals(this.sync, this.syncCheck)) {
                    throw new IOException("File is corrupt!");
                }
            }
            this.syncSeen = true;
            this.noBufferedRecords = WritableUtils.readVInt(this.in);
            this.readBuffer(this.keyLenBuffer, this.keyLenInFilter);
            this.readBuffer(this.keyBuffer, this.keyInFilter);
            this.noBufferedKeys = this.noBufferedRecords;
            if (!this.lazyDecompress) {
                this.readBuffer(this.valLenBuffer, this.valLenInFilter);
                this.readBuffer(this.valBuffer, this.valInFilter);
                this.noBufferedValues = this.noBufferedRecords;
                this.valuesDecompressed = true;
            }
        }

        private synchronized void seekToCurrentValue() throws IOException {
            if (!this.blockCompressed) {
                if (this.decompress) {
                    this.valInFilter.resetState();
                }
                this.valBuffer.reset();
            } else {
                if (this.lazyDecompress && !this.valuesDecompressed) {
                    this.readBuffer(this.valLenBuffer, this.valLenInFilter);
                    this.readBuffer(this.valBuffer, this.valInFilter);
                    this.noBufferedValues = this.noBufferedRecords;
                    this.valuesDecompressed = true;
                }
                int skipValBytes = 0;
                int currentKey = this.noBufferedKeys + 1;
                for (int i = this.noBufferedValues; i > currentKey; --i) {
                    skipValBytes += WritableUtils.readVInt(this.valLenIn);
                    --this.noBufferedValues;
                }
                if (skipValBytes > 0 && this.valIn.skipBytes(skipValBytes) != skipValBytes) {
                    throw new IOException("Failed to seek to " + currentKey + "(th) value!");
                }
            }
        }

        public synchronized void getCurrentValue(Writable val) throws IOException {
            if (val instanceof Configurable) {
                ((Configurable)((Object)val)).setConf(this.conf);
            }
            this.seekToCurrentValue();
            if (!this.blockCompressed) {
                val.readFields(this.valIn);
                if (this.valIn.read() > 0) {
                    LOG.info("available bytes: " + this.valIn.available());
                    throw new IOException(val + " read " + (this.valBuffer.getPosition() - this.keyLength) + " bytes, should read " + (this.valBuffer.getLength() - this.keyLength));
                }
            } else {
                int valLength = WritableUtils.readVInt(this.valLenIn);
                val.readFields(this.valIn);
                --this.noBufferedValues;
                if (valLength < 0) {
                    LOG.debug(val + " is a zero-length value");
                }
            }
        }

        public synchronized Object getCurrentValue(Object val) throws IOException {
            if (val instanceof Configurable) {
                ((Configurable)val).setConf(this.conf);
            }
            this.seekToCurrentValue();
            if (!this.blockCompressed) {
                val = this.deserializeValue(val);
                if (this.valIn.read() > 0) {
                    LOG.info("available bytes: " + this.valIn.available());
                    throw new IOException(val + " read " + (this.valBuffer.getPosition() - this.keyLength) + " bytes, should read " + (this.valBuffer.getLength() - this.keyLength));
                }
            } else {
                int valLength = WritableUtils.readVInt(this.valLenIn);
                val = this.deserializeValue(val);
                --this.noBufferedValues;
                if (valLength < 0) {
                    LOG.debug(val + " is a zero-length value");
                }
            }
            return val;
        }

        private Object deserializeValue(Object val) throws IOException {
            return this.valDeserializer.deserialize(val);
        }

        public synchronized boolean next(Writable key) throws IOException {
            if (key.getClass() != this.getKeyClass()) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (!this.blockCompressed) {
                this.outBuf.reset();
                this.keyLength = this.next(this.outBuf);
                if (this.keyLength < 0) {
                    return false;
                }
                this.valBuffer.reset(this.outBuf.getData(), this.outBuf.getLength());
                key.readFields(this.valBuffer);
                this.valBuffer.mark(0);
                if (this.valBuffer.getPosition() != this.keyLength) {
                    throw new IOException(key + " read " + this.valBuffer.getPosition() + " bytes, should read " + this.keyLength);
                }
            } else {
                int keyLength;
                this.syncSeen = false;
                if (this.noBufferedKeys == 0) {
                    try {
                        this.readBlock();
                    }
                    catch (EOFException eof) {
                        return false;
                    }
                }
                if ((keyLength = WritableUtils.readVInt(this.keyLenIn)) < 0) {
                    return false;
                }
                key.readFields(this.keyIn);
                --this.noBufferedKeys;
            }
            return true;
        }

        public synchronized boolean next(Writable key, Writable val) throws IOException {
            if (val.getClass() != this.getValueClass()) {
                throw new IOException("wrong value class: " + val + " is not " + this.valClass);
            }
            boolean more = this.next(key);
            if (more) {
                this.getCurrentValue(val);
            }
            return more;
        }

        private synchronized int readRecordLength() throws IOException {
            if (this.in.getPos() >= this.end) {
                return -1;
            }
            int length = this.in.readInt();
            if (this.version > 1 && this.sync != null && length == -1) {
                this.in.readFully(this.syncCheck);
                if (!Arrays.equals(this.sync, this.syncCheck)) {
                    throw new IOException("File is corrupt!");
                }
                this.syncSeen = true;
                if (this.in.getPos() >= this.end) {
                    return -1;
                }
                length = this.in.readInt();
            } else {
                this.syncSeen = false;
            }
            return length;
        }

        public synchronized int next(DataOutputBuffer buffer) throws IOException {
            if (this.blockCompressed) {
                throw new IOException("Unsupported call for block-compressed SequenceFiles - use SequenceFile.Reader.next(DataOutputStream, ValueBytes)");
            }
            try {
                int length = this.readRecordLength();
                if (length == -1) {
                    return -1;
                }
                int keyLength = this.in.readInt();
                buffer.write(this.in, length);
                return keyLength;
            }
            catch (ChecksumException e) {
                this.handleChecksumException(e);
                return this.next(buffer);
            }
        }

        public ValueBytes createValueBytes() {
            ValueBytes val = null;
            val = !this.decompress || this.blockCompressed ? new UncompressedBytes() : new CompressedBytes(this.codec);
            return val;
        }

        public synchronized int nextRaw(DataOutputBuffer key, ValueBytes val) throws IOException {
            int keyLength;
            if (!this.blockCompressed) {
                int length = this.readRecordLength();
                if (length == -1) {
                    return -1;
                }
                int keyLength2 = this.in.readInt();
                int valLength = length - keyLength2;
                key.write(this.in, keyLength2);
                if (this.decompress) {
                    CompressedBytes value = (CompressedBytes)val;
                    value.reset(this.in, valLength);
                } else {
                    UncompressedBytes value = (UncompressedBytes)val;
                    value.reset(this.in, valLength);
                }
                return length;
            }
            this.syncSeen = false;
            if (this.noBufferedKeys == 0) {
                if (this.in.getPos() >= this.end) {
                    return -1;
                }
                try {
                    this.readBlock();
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
            if ((keyLength = WritableUtils.readVInt(this.keyLenIn)) < 0) {
                throw new IOException("zero length key found!");
            }
            key.write(this.keyIn, keyLength);
            --this.noBufferedKeys;
            this.seekToCurrentValue();
            int valLength = WritableUtils.readVInt(this.valLenIn);
            UncompressedBytes rawValue = (UncompressedBytes)val;
            rawValue.reset(this.valIn, valLength);
            --this.noBufferedValues;
            return keyLength + valLength;
        }

        public int nextRawKey(DataOutputBuffer key) throws IOException {
            int keyLength;
            if (!this.blockCompressed) {
                this.recordLength = this.readRecordLength();
                if (this.recordLength == -1) {
                    return -1;
                }
                this.keyLength = this.in.readInt();
                key.write(this.in, this.keyLength);
                return this.keyLength;
            }
            this.syncSeen = false;
            if (this.noBufferedKeys == 0) {
                if (this.in.getPos() >= this.end) {
                    return -1;
                }
                try {
                    this.readBlock();
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
            if ((keyLength = WritableUtils.readVInt(this.keyLenIn)) < 0) {
                throw new IOException("zero length key found!");
            }
            key.write(this.keyIn, keyLength);
            --this.noBufferedKeys;
            return keyLength;
        }

        public synchronized Object next(Object key) throws IOException {
            if (key != null && key.getClass() != this.getKeyClass()) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (!this.blockCompressed) {
                this.outBuf.reset();
                this.keyLength = this.next(this.outBuf);
                if (this.keyLength < 0) {
                    return null;
                }
                this.valBuffer.reset(this.outBuf.getData(), this.outBuf.getLength());
                key = this.deserializeKey(key);
                this.valBuffer.mark(0);
                if (this.valBuffer.getPosition() != this.keyLength) {
                    throw new IOException(key + " read " + this.valBuffer.getPosition() + " bytes, should read " + this.keyLength);
                }
            } else {
                int keyLength;
                this.syncSeen = false;
                if (this.noBufferedKeys == 0) {
                    try {
                        this.readBlock();
                    }
                    catch (EOFException eof) {
                        return null;
                    }
                }
                if ((keyLength = WritableUtils.readVInt(this.keyLenIn)) < 0) {
                    return null;
                }
                key = this.deserializeKey(key);
                --this.noBufferedKeys;
            }
            return key;
        }

        private Object deserializeKey(Object key) throws IOException {
            return this.keyDeserializer.deserialize(key);
        }

        public synchronized int nextRawValue(ValueBytes val) throws IOException {
            this.seekToCurrentValue();
            if (!this.blockCompressed) {
                int valLength = this.recordLength - this.keyLength;
                if (this.decompress) {
                    CompressedBytes value = (CompressedBytes)val;
                    value.reset(this.in, valLength);
                } else {
                    UncompressedBytes value = (UncompressedBytes)val;
                    value.reset(this.in, valLength);
                }
                return valLength;
            }
            int valLength = WritableUtils.readVInt(this.valLenIn);
            UncompressedBytes rawValue = (UncompressedBytes)val;
            rawValue.reset(this.valIn, valLength);
            --this.noBufferedValues;
            return valLength;
        }

        private void handleChecksumException(ChecksumException e) throws IOException {
            if (!this.conf.getBoolean("io.skip.checksum.errors", false)) {
                throw e;
            }
            LOG.warn("Bad checksum at " + this.getPosition() + ". Skipping entries.");
            this.sync(this.getPosition() + (long)this.conf.getInt("io.bytes.per.checksum", 512));
        }

        public synchronized void seek(long position) throws IOException {
            this.in.seek(position);
            if (this.blockCompressed) {
                this.noBufferedKeys = 0;
                this.valuesDecompressed = true;
            }
        }

        public synchronized void sync(long position) throws IOException {
            if (position + 20L >= this.end) {
                this.seek(this.end);
                return;
            }
            try {
                this.seek(position + 4L);
                this.in.readFully(this.syncCheck);
                int syncLen = this.sync.length;
                int i = 0;
                while (this.in.getPos() < this.end) {
                    int j;
                    for (j = 0; j < syncLen && this.sync[j] == this.syncCheck[(i + j) % syncLen]; ++j) {
                    }
                    if (j == syncLen) {
                        this.in.seek(this.in.getPos() - 20L);
                        return;
                    }
                    this.syncCheck[i % syncLen] = this.in.readByte();
                    ++i;
                }
            }
            catch (ChecksumException e) {
                this.handleChecksumException(e);
            }
        }

        public boolean syncSeen() {
            return this.syncSeen;
        }

        public synchronized long getPosition() throws IOException {
            return this.in.getPos();
        }

        public String toString() {
            return this.file.toString();
        }

        static /* synthetic */ byte[] access$2802(Reader x0, byte[] x1) {
            x0.sync = x1;
            return x1;
        }
    }

    static class BlockCompressWriter
    extends Writer {
        private int noBufferedRecords = 0;
        private DataOutputBuffer keyLenBuffer = new DataOutputBuffer();
        private DataOutputBuffer keyBuffer = new DataOutputBuffer();
        private DataOutputBuffer valLenBuffer = new DataOutputBuffer();
        private DataOutputBuffer valBuffer = new DataOutputBuffer();
        private int compressionBlockSize;

        public BlockCompressWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionCodec codec) throws IOException {
            this(fs, conf, name, keyClass, valClass, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), codec, null, new Metadata());
        }

        public BlockCompressWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
            this(fs, conf, name, keyClass, valClass, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), codec, progress, metadata);
        }

        public BlockCompressWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
            super.init(name, conf, fs.create(name, true, bufferSize, replication, blockSize, progress), keyClass, valClass, true, codec, metadata);
            this.init(conf.getInt("io.seqfile.compress.blocksize", 1000000));
            this.initializeFileHeader();
            this.writeFileHeader();
            this.finalizeFileHeader();
        }

        public BlockCompressWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionCodec codec, Progressable progress) throws IOException {
            this(fs, conf, name, keyClass, valClass, codec, progress, new Metadata());
        }

        private BlockCompressWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, CompressionCodec codec, Metadata metadata) throws IOException {
            this.ownOutputStream = false;
            super.init(null, conf, out, keyClass, valClass, true, codec, metadata);
            this.init(1000000);
            this.initializeFileHeader();
            this.writeFileHeader();
            this.finalizeFileHeader();
        }

        @Override
        boolean isCompressed() {
            return true;
        }

        @Override
        boolean isBlockCompressed() {
            return true;
        }

        void init(int compressionBlockSize) throws IOException {
            this.compressionBlockSize = compressionBlockSize;
            this.keySerializer.close();
            this.keySerializer.open(this.keyBuffer);
            this.uncompressedValSerializer.close();
            this.uncompressedValSerializer.open(this.valBuffer);
        }

        private synchronized void writeBuffer(DataOutputBuffer uncompressedDataBuffer) throws IOException {
            this.deflateFilter.resetState();
            this.buffer.reset();
            this.deflateOut.write(uncompressedDataBuffer.getData(), 0, uncompressedDataBuffer.getLength());
            this.deflateOut.flush();
            this.deflateFilter.finish();
            WritableUtils.writeVInt(this.out, this.buffer.getLength());
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        @Override
        public synchronized void sync() throws IOException {
            if (this.noBufferedRecords > 0) {
                super.sync();
                WritableUtils.writeVInt(this.out, this.noBufferedRecords);
                this.writeBuffer(this.keyLenBuffer);
                this.writeBuffer(this.keyBuffer);
                this.writeBuffer(this.valLenBuffer);
                this.writeBuffer(this.valBuffer);
                this.out.flush();
                this.keyLenBuffer.reset();
                this.keyBuffer.reset();
                this.valLenBuffer.reset();
                this.valBuffer.reset();
                this.noBufferedRecords = 0;
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.out != null) {
                this.sync();
            }
            super.close();
        }

        @Override
        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val + " is not " + this.valClass);
            }
            int oldKeyLength = this.keyBuffer.getLength();
            this.keySerializer.serialize(key);
            int keyLength = this.keyBuffer.getLength() - oldKeyLength;
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            WritableUtils.writeVInt(this.keyLenBuffer, keyLength);
            int oldValLength = this.valBuffer.getLength();
            this.uncompressedValSerializer.serialize(val);
            int valLength = this.valBuffer.getLength() - oldValLength;
            WritableUtils.writeVInt(this.valLenBuffer, valLength);
            ++this.noBufferedRecords;
            int currentBlockSize = this.keyBuffer.getLength() + this.valBuffer.getLength();
            if (currentBlockSize >= this.compressionBlockSize) {
                this.sync();
            }
        }

        @Override
        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed");
            }
            int valLength = val.getSize();
            WritableUtils.writeVInt(this.keyLenBuffer, keyLength);
            this.keyBuffer.write(keyData, keyOffset, keyLength);
            WritableUtils.writeVInt(this.valLenBuffer, valLength);
            val.writeUncompressedBytes(this.valBuffer);
            ++this.noBufferedRecords;
            int currentBlockSize = this.keyBuffer.getLength() + this.valBuffer.getLength();
            if (currentBlockSize >= this.compressionBlockSize) {
                this.sync();
            }
        }
    }

    static class RecordCompressWriter
    extends Writer {
        public RecordCompressWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionCodec codec) throws IOException {
            this(conf, fs.create(name), keyClass, valClass, codec, new Metadata());
        }

        public RecordCompressWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
            this(fs, conf, name, keyClass, valClass, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), codec, progress, metadata);
        }

        public RecordCompressWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
            super.init(name, conf, fs.create(name, true, bufferSize, replication, blockSize, progress), keyClass, valClass, true, codec, metadata);
            this.initializeFileHeader();
            this.writeFileHeader();
            this.finalizeFileHeader();
        }

        public RecordCompressWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionCodec codec, Progressable progress) throws IOException {
            this(fs, conf, name, keyClass, valClass, codec, progress, new Metadata());
        }

        private RecordCompressWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, CompressionCodec codec, Metadata metadata) throws IOException {
            this.ownOutputStream = false;
            super.init(null, conf, out, keyClass, valClass, true, codec, metadata);
            this.initializeFileHeader();
            this.writeFileHeader();
            this.finalizeFileHeader();
        }

        @Override
        boolean isCompressed() {
            return true;
        }

        @Override
        boolean isBlockCompressed() {
            return false;
        }

        @Override
        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val.getClass().getName() + " is not " + this.valClass);
            }
            this.buffer.reset();
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            this.deflateFilter.resetState();
            this.compressedValSerializer.serialize(val);
            this.deflateOut.flush();
            this.deflateFilter.finish();
            this.checkAndWriteSync();
            this.out.writeInt(this.buffer.getLength());
            this.out.writeInt(keyLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        @Override
        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + keyLength);
            }
            int valLength = val.getSize();
            this.checkAndWriteSync();
            this.out.writeInt(keyLength + valLength);
            this.out.writeInt(keyLength);
            this.out.write(keyData, keyOffset, keyLength);
            val.writeCompressedBytes(this.out);
        }
    }

    public static class Writer
    implements Closeable {
        Configuration conf;
        FSDataOutputStream out;
        boolean ownOutputStream = true;
        DataOutputBuffer buffer = new DataOutputBuffer();
        Class keyClass;
        Class valClass;
        private boolean compress;
        CompressionCodec codec = null;
        CompressionOutputStream deflateFilter = null;
        DataOutputStream deflateOut = null;
        Metadata metadata = null;
        .Compressor compressor = null;
        protected Serializer keySerializer;
        protected Serializer uncompressedValSerializer;
        protected Serializer compressedValSerializer;
        long lastSyncPos;
        byte[] sync;

        Writer() {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = System.currentTimeMillis();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass) throws IOException {
            this(fs, conf, name, keyClass, valClass, null, new Metadata());
        }

        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, Progressable progress, Metadata metadata) throws IOException {
            this(fs, conf, name, keyClass, valClass, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), progress, metadata);
        }

        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, Progressable progress, Metadata metadata) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = System.currentTimeMillis();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.init(name, conf, fs.create(name, true, bufferSize, replication, blockSize, progress), keyClass, valClass, false, null, metadata);
            this.initializeFileHeader();
            this.writeFileHeader();
            this.finalizeFileHeader();
        }

        private Writer(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, Metadata metadata) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = System.currentTimeMillis();
                digester.update((new UID() + "@" + time).getBytes());
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.ownOutputStream = false;
            this.init(null, conf, out, keyClass, valClass, false, null, metadata);
            this.initializeFileHeader();
            this.writeFileHeader();
            this.finalizeFileHeader();
        }

        void initializeFileHeader() throws IOException {
            this.out.write(VERSION);
        }

        void finalizeFileHeader() throws IOException {
            this.out.write(this.sync);
            this.out.flush();
        }

        boolean isCompressed() {
            return this.compress;
        }

        boolean isBlockCompressed() {
            return false;
        }

        void writeFileHeader() throws IOException {
            Text.writeString(this.out, this.keyClass.getName());
            Text.writeString(this.out, this.valClass.getName());
            this.out.writeBoolean(this.isCompressed());
            this.out.writeBoolean(this.isBlockCompressed());
            if (this.isCompressed()) {
                Text.writeString(this.out, this.codec.getClass().getName());
            }
            this.metadata.write(this.out);
        }

        void init(Path name, Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, boolean compress, CompressionCodec codec, Metadata metadata) throws IOException {
            this.conf = conf;
            this.out = out;
            this.keyClass = keyClass;
            this.valClass = valClass;
            this.compress = compress;
            this.codec = codec;
            this.metadata = metadata;
            SerializationFactory serializationFactory = new SerializationFactory(conf);
            this.keySerializer = serializationFactory.getSerializer(keyClass);
            this.keySerializer.open(this.buffer);
            this.uncompressedValSerializer = serializationFactory.getSerializer(valClass);
            this.uncompressedValSerializer.open(this.buffer);
            if (this.codec != null) {
                ReflectionUtils.setConf(this.codec, this.conf);
                this.compressor = CodecPool.getCompressor(this.codec);
                this.deflateFilter = this.codec.createOutputStream(this.buffer, this.compressor);
                this.deflateOut = new DataOutputStream(new BufferedOutputStream(this.deflateFilter));
                this.compressedValSerializer = serializationFactory.getSerializer(valClass);
                this.compressedValSerializer.open(this.deflateOut);
            }
        }

        public Class getKeyClass() {
            return this.keyClass;
        }

        public Class getValueClass() {
            return this.valClass;
        }

        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }

        public void sync() throws IOException {
            if (this.sync != null && this.lastSyncPos != this.out.getPos()) {
                this.out.writeInt(-1);
                this.out.write(this.sync);
                this.lastSyncPos = this.out.getPos();
            }
        }

        Configuration getConf() {
            return this.conf;
        }

        @Override
        public synchronized void close() throws IOException {
            this.keySerializer.close();
            this.uncompressedValSerializer.close();
            if (this.compressedValSerializer != null) {
                this.compressedValSerializer.close();
            }
            CodecPool.returnCompressor(this.compressor);
            this.compressor = null;
            if (this.out != null) {
                if (this.ownOutputStream) {
                    this.out.close();
                } else {
                    this.out.flush();
                }
                this.out = null;
            }
        }

        synchronized void checkAndWriteSync() throws IOException {
            if (this.sync != null && this.out.getPos() >= this.lastSyncPos + 2000L) {
                this.sync();
            }
        }

        public synchronized void append(Writable key, Writable val) throws IOException {
            this.append((Object)key, (Object)val);
        }

        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val.getClass().getName() + " is not " + this.valClass);
            }
            this.buffer.reset();
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            if (this.compress) {
                this.deflateFilter.resetState();
                this.compressedValSerializer.serialize(val);
                this.deflateOut.flush();
                this.deflateFilter.finish();
            } else {
                this.uncompressedValSerializer.serialize(val);
            }
            this.checkAndWriteSync();
            this.out.writeInt(this.buffer.getLength());
            this.out.writeInt(keyLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + keyLength);
            }
            int valLength = val.getSize();
            this.checkAndWriteSync();
            this.out.writeInt(keyLength + valLength);
            this.out.writeInt(keyLength);
            this.out.write(keyData, keyOffset, keyLength);
            val.writeUncompressedBytes(this.out);
        }

        public synchronized long getLength() throws IOException {
            return this.out.getPos();
        }
    }

    public static class Metadata
    implements Writable {
        private TreeMap<Text, Text> theMetadata;

        public Metadata() {
            this(new TreeMap<Text, Text>());
        }

        public Metadata(TreeMap<Text, Text> arg) {
            this.theMetadata = arg == null ? new TreeMap() : arg;
        }

        public Text get(Text name) {
            return this.theMetadata.get(name);
        }

        public void set(Text name, Text value) {
            this.theMetadata.put(name, value);
        }

        public TreeMap<Text, Text> getMetadata() {
            return new TreeMap<Text, Text>((SortedMap<Text, Text>)this.theMetadata);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.theMetadata.size());
            for (Map.Entry<Text, Text> en : this.theMetadata.entrySet()) {
                en.getKey().write(out);
                en.getValue().write(out);
            }
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            int sz = in.readInt();
            if (sz < 0) {
                throw new IOException("Invalid size: " + sz + " for file metadata object");
            }
            this.theMetadata = new TreeMap();
            for (int i = 0; i < sz; ++i) {
                Text key = new Text();
                Text val = new Text();
                key.readFields(in);
                val.readFields(in);
                this.theMetadata.put(key, val);
            }
        }

        public boolean equals(Metadata other) {
            if (other == null) {
                return false;
            }
            if (this.theMetadata.size() != other.theMetadata.size()) {
                return false;
            }
            Iterator<Map.Entry<Text, Text>> iter1 = this.theMetadata.entrySet().iterator();
            Iterator<Map.Entry<Text, Text>> iter2 = other.theMetadata.entrySet().iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Map.Entry<Text, Text> en1 = iter1.next();
                Map.Entry<Text, Text> en2 = iter2.next();
                if (!en1.getKey().equals(en2.getKey())) {
                    return false;
                }
                if (en1.getValue().equals(en2.getValue())) continue;
                return false;
            }
            return !iter1.hasNext() && !iter2.hasNext();
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("size: ").append(this.theMetadata.size()).append("\n");
            for (Map.Entry<Text, Text> en : this.theMetadata.entrySet()) {
                sb.append("\t").append(en.getKey().toString()).append("\t").append(en.getValue().toString());
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    private static class CompressedBytes
    implements ValueBytes {
        private int dataSize = 0;
        private byte[] data = null;
        DataInputBuffer rawData = null;
        CompressionCodec codec = null;
        CompressionInputStream decompressedStream = null;

        private CompressedBytes(CompressionCodec codec) {
            this.codec = codec;
        }

        private void reset(DataInputStream in, int length) throws IOException {
            this.data = new byte[length];
            this.dataSize = -1;
            in.readFully(this.data);
            this.dataSize = this.data.length;
        }

        @Override
        public int getSize() {
            return this.dataSize;
        }

        @Override
        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            if (this.decompressedStream == null) {
                this.rawData = new DataInputBuffer();
                this.decompressedStream = this.codec.createInputStream(this.rawData);
            } else {
                this.decompressedStream.resetState();
            }
            this.rawData.reset(this.data, 0, this.dataSize);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = this.decompressedStream.read(buffer, 0, 8192)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }

        @Override
        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            outStream.write(this.data, 0, this.dataSize);
        }
    }

    private static class UncompressedBytes
    implements ValueBytes {
        private int dataSize = 0;
        private byte[] data = null;

        private UncompressedBytes() {
        }

        private void reset(DataInputStream in, int length) throws IOException {
            this.data = new byte[length];
            this.dataSize = -1;
            in.readFully(this.data);
            this.dataSize = this.data.length;
        }

        @Override
        public int getSize() {
            return this.dataSize;
        }

        @Override
        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            outStream.write(this.data, 0, this.dataSize);
        }

        @Override
        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new IllegalArgumentException("UncompressedBytes cannot be compressed!");
        }
    }

    public static interface ValueBytes {
        public void writeUncompressedBytes(DataOutputStream var1) throws IOException;

        public void writeCompressedBytes(DataOutputStream var1) throws IllegalArgumentException, IOException;

        public int getSize();
    }

    public static enum CompressionType {
        NONE,
        RECORD,
        BLOCK;

    }
}

