/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.io;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.DataInputBuffer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.DataOutputBuffer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparator;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UTF8
implements WritableComparable {
    private static final Log LOG = LogFactory.getLog(UTF8.class);
    private static final DataOutputBuffer OBUF = new DataOutputBuffer();
    private static final DataInputBuffer IBUF = new DataInputBuffer();
    private static final byte[] EMPTY_BYTES = new byte[0];
    private byte[] bytes = EMPTY_BYTES;
    private int length;

    public UTF8() {
    }

    public UTF8(String string) {
        this.set(string);
    }

    public UTF8(UTF8 utf8) {
        this.set(utf8);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String string) {
        if (string.length() > 21845) {
            LOG.warn("truncating long string: " + string.length() + " chars, starting with " + string.substring(0, 20));
            string = string.substring(0, 21845);
        }
        this.length = UTF8.utf8Length(string);
        if (this.length > 65535) {
            throw new RuntimeException("string too long!");
        }
        if (this.bytes == null || this.length > this.bytes.length) {
            this.bytes = new byte[this.length];
        }
        try {
            DataOutputBuffer dataOutputBuffer = OBUF;
            synchronized (dataOutputBuffer) {
                OBUF.reset();
                UTF8.writeChars(OBUF, string, 0, string.length());
                System.arraycopy(OBUF.getData(), 0, this.bytes, 0, this.length);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(UTF8 other) {
        this.length = other.length;
        if (this.bytes == null || this.length > this.bytes.length) {
            this.bytes = new byte[this.length];
        }
        System.arraycopy(other.bytes, 0, this.bytes, 0, this.length);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.length = in.readUnsignedShort();
        if (this.bytes == null || this.bytes.length < this.length) {
            this.bytes = new byte[this.length];
        }
        in.readFully(this.bytes, 0, this.length);
    }

    public static void skip(DataInput in) throws IOException {
        int length = in.readUnsignedShort();
        WritableUtils.skipFully(in, length);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.length);
        out.write(this.bytes, 0, this.length);
    }

    @Override
    public int compareTo(Object o) {
        UTF8 that = (UTF8)o;
        return WritableComparator.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer(this.length);
        try {
            DataInputBuffer dataInputBuffer = IBUF;
            synchronized (dataInputBuffer) {
                IBUF.reset(this.bytes, this.length);
                UTF8.readChars(IBUF, buffer, this.length);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof UTF8)) {
            return false;
        }
        UTF8 that = (UTF8)o;
        if (this.length != that.length) {
            return false;
        }
        return WritableComparator.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length) == 0;
    }

    public int hashCode() {
        return WritableComparator.hashBytes(this.bytes, this.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(String string) {
        byte[] result = new byte[UTF8.utf8Length(string)];
        try {
            DataOutputBuffer dataOutputBuffer = OBUF;
            synchronized (dataOutputBuffer) {
                OBUF.reset();
                UTF8.writeChars(OBUF, string, 0, string.length());
                System.arraycopy(OBUF.getData(), 0, result, 0, OBUF.getLength());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String readString(DataInput in) throws IOException {
        int bytes = in.readUnsignedShort();
        StringBuffer buffer = new StringBuffer(bytes);
        UTF8.readChars(in, buffer, bytes);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readChars(DataInput in, StringBuffer buffer, int nBytes) throws IOException {
        DataOutputBuffer dataOutputBuffer = OBUF;
        synchronized (dataOutputBuffer) {
            OBUF.reset();
            OBUF.write(in, nBytes);
            byte[] bytes = OBUF.getData();
            int i = 0;
            while (i < nBytes) {
                byte b;
                if (((b = bytes[i++]) & 0x80) == 0) {
                    buffer.append((char)(b & 0x7F));
                    continue;
                }
                if ((b & 0xE0) != 224) {
                    buffer.append((char)((b & 0x1F) << 6 | bytes[i++] & 0x3F));
                    continue;
                }
                buffer.append((char)((b & 0xF) << 12 | (bytes[i++] & 0x3F) << 6 | bytes[i++] & 0x3F));
            }
        }
    }

    public static int writeString(DataOutput out, String s) throws IOException {
        int len;
        if (s.length() > 21845) {
            LOG.warn("truncating long string: " + s.length() + " chars, starting with " + s.substring(0, 20));
            s = s.substring(0, 21845);
        }
        if ((len = UTF8.utf8Length(s)) > 65535) {
            throw new IOException("string too long!");
        }
        out.writeShort(len);
        UTF8.writeChars(out, s, 0, s.length());
        return len;
    }

    private static int utf8Length(String string) {
        int stringLength = string.length();
        int utf8Length = 0;
        for (int i = 0; i < stringLength; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utf8Length;
                continue;
            }
            if (c > '\u07ff') {
                utf8Length += 3;
                continue;
            }
            utf8Length += 2;
        }
        return utf8Length;
    }

    private static void writeChars(DataOutput out, String s, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char code = s.charAt(i);
            if (code >= '\u0001' && code <= '\u007f') {
                out.writeByte((byte)code);
                continue;
            }
            if (code <= '\u07ff') {
                out.writeByte((byte)(0xC0 | code >> 6 & 0x1F));
                out.writeByte((byte)(0x80 | code & 0x3F));
                continue;
            }
            out.writeByte((byte)(0xE0 | code >> 12 & 0xF));
            out.writeByte((byte)(0x80 | code >> 6 & 0x3F));
            out.writeByte((byte)(0x80 | code & 0x3F));
        }
    }

    static {
        WritableComparator.define(UTF8.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(UTF8.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int n1 = Comparator.readUnsignedShort(b1, s1);
            int n2 = Comparator.readUnsignedShort(b2, s2);
            return Comparator.compareBytes(b1, s1 + 2, n1, b2, s2 + 2, n2);
        }
    }
}

