/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configurable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionCodec;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionInputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionOutputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.Compressor;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressorStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.Decompressor;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.DecompressorStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.ZlibFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultCodec
implements Configurable,
CompressionCodec {
    Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new CompressorStream(out, this.createCompressor(), this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return new CompressorStream(out, compressor, this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return ZlibFactory.getZlibCompressorType(this.conf);
    }

    @Override
    public Compressor createCompressor() {
        return ZlibFactory.getZlibCompressor(this.conf);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new DecompressorStream(in, this.createDecompressor(), this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new DecompressorStream(in, decompressor, this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return ZlibFactory.getZlibDecompressorType(this.conf);
    }

    @Override
    public Decompressor createDecompressor() {
        return ZlibFactory.getZlibDecompressor(this.conf);
    }

    @Override
    public String getDefaultExtension() {
        return ".deflate";
    }
}

