/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.Compressor;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.Decompressor;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.BuiltInZlibInflater;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.NativeCodeLoader;

public class ZlibFactory {
    private static final Log LOG = LogFactory.getLog(ZlibFactory.class);
    private static boolean nativeZlibLoaded = false;

    public static boolean isNativeZlibLoaded(Configuration conf) {
        return nativeZlibLoaded && conf.getBoolean("hadoop.native.lib", true);
    }

    public static Class<? extends Compressor> getZlibCompressorType(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? ZlibCompressor.class : BuiltInZlibDeflater.class;
    }

    public static Compressor getZlibCompressor(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? new ZlibCompressor() : new BuiltInZlibDeflater();
    }

    public static Class<? extends Decompressor> getZlibDecompressorType(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? ZlibDecompressor.class : BuiltInZlibInflater.class;
    }

    public static Decompressor getZlibDecompressor(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? new ZlibDecompressor() : new BuiltInZlibInflater();
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            boolean bl = nativeZlibLoaded = ZlibCompressor.isNativeZlibLoaded() && ZlibDecompressor.isNativeZlibLoaded();
            if (nativeZlibLoaded) {
                LOG.info("Successfully loaded & initialized native-zlib library");
            } else {
                LOG.warn("Failed to load/initialize native-zlib library");
            }
        }
    }
}

