/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configured;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.filecache.DistributedCache;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsPermission;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.BytesWritable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.DataOutputBuffer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.IOUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.SerializationFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Serializer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.ipc.RPC;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.ClusterStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.Counters;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.HistoryViewer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.InputSplit;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.InvalidJobConfException;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobContext;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobPriority;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobProfile;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobQueueInfo;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobSubmissionProtocol;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobTracker;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.LocalJobRunner;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.MRConstants;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.RunningJob;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TIPStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskCompletionEvent;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskReport;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputFormat;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.OutputFormat;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.net.NetUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.security.UnixUserGroupInformation;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.Tool;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ToolRunner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.security.auth.login.LoginException;

public class JobClient
extends Configured
implements MRConstants,
Tool {
    private static final Log LOG = LogFactory.getLog(JobClient.class);
    private TaskStatusFilter taskOutputFilter = TaskStatusFilter.FAILED;
    private static final long MAX_JOBPROFILE_AGE = 2000L;
    private JobSubmissionProtocol jobSubmitClient;
    private Path sysDir = null;
    private FileSystem fs = null;
    private static final FsPermission JOB_FILE_PERMISSION;
    static final FsPermission JOB_DIR_PERMISSION;
    private static final int CURRENT_SPLIT_FILE_VERSION = 0;
    private static final byte[] SPLIT_FILE_HEADER;

    public JobClient() {
    }

    public JobClient(JobConf conf) throws IOException {
        this.setConf(conf);
        this.init(conf);
    }

    public void init(JobConf conf) throws IOException {
        String tracker = conf.get("mapred.job.tracker", "local");
        this.jobSubmitClient = "local".equals(tracker) ? new LocalJobRunner(conf) : this.createRPCProxy(JobTracker.getAddress(conf), conf);
    }

    private JobSubmissionProtocol createRPCProxy(InetSocketAddress addr, Configuration conf) throws IOException {
        return (JobSubmissionProtocol)RPC.getProxy(JobSubmissionProtocol.class, 20L, addr, this.getUGI(conf), conf, NetUtils.getSocketFactory(conf, JobSubmissionProtocol.class));
    }

    public JobClient(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.jobSubmitClient = this.createRPCProxy(jobTrackAddr, conf);
    }

    public synchronized void close() throws IOException {
        if (!(this.jobSubmitClient instanceof LocalJobRunner)) {
            RPC.stopProxy(this.jobSubmitClient);
        }
    }

    public synchronized FileSystem getFs() throws IOException {
        if (this.fs == null) {
            Path sysDir = this.getSystemDir();
            this.fs = sysDir.getFileSystem(this.getConf());
        }
        return this.fs;
    }

    private boolean compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) {
            return false;
        }
        if (!srcUri.getScheme().equals(dstUri.getScheme())) {
            return false;
        }
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            try {
                srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
            }
            catch (UnknownHostException ue) {
                return false;
            }
            if (!srcHost.equals(dstHost)) {
                return false;
            }
        } else {
            if (srcHost == null && dstHost != null) {
                return false;
            }
            if (srcHost != null && dstHost == null) {
                return false;
            }
        }
        return srcUri.getPort() == dstUri.getPort();
    }

    private Path copyRemoteFiles(FileSystem jtFs, Path parentDir, Path originalPath, JobConf job, short replication) throws IOException {
        FileSystem remoteFs = null;
        remoteFs = originalPath.getFileSystem(job);
        if (this.compareFs(remoteFs, jtFs)) {
            return originalPath;
        }
        Path newPath = new Path(parentDir, originalPath.getName());
        FileUtil.copy(remoteFs, originalPath, jtFs, newPath, false, job);
        jtFs.setReplication(newPath, replication);
        return newPath;
    }

    private void configureCommandLineOptions(JobConf job, Path submitJobDir, Path submitJarFile) throws IOException {
        String originalJarPath;
        URI[] tfiles;
        URI[] tarchives;
        URI pathURI;
        Path newPath;
        Path tmp;
        if (!job.getBoolean("mapred.used.genericoptionsparser", false)) {
            LOG.warn("Use GenericOptionsParser for parsing the arguments. Applications should implement Tool for the same.");
        }
        String files = null;
        String libjars = null;
        String archives = null;
        files = job.get("tmpfiles");
        libjars = job.get("tmpjars");
        archives = job.get("tmparchives");
        UnixUserGroupInformation ugi = this.getUGI(job);
        FileSystem fs = this.getFs();
        LOG.debug("default FileSystem: " + fs.getUri());
        fs.delete(submitJobDir, true);
        submitJobDir = fs.makeQualified(submitJobDir);
        submitJobDir = new Path(submitJobDir.toUri().getPath());
        FsPermission mapredSysPerms = new FsPermission(JOB_DIR_PERMISSION);
        FileSystem.mkdirs(fs, submitJobDir, mapredSysPerms);
        Path filesDir = new Path(submitJobDir, "files");
        Path archivesDir = new Path(submitJobDir, "archives");
        Path libjarsDir = new Path(submitJobDir, "libjars");
        short replication = (short)job.getInt("mapred.submit.replication", 10);
        if (files != null) {
            String[] fileArr;
            FileSystem.mkdirs(fs, filesDir, mapredSysPerms);
            for (String tmpFile : fileArr = files.split(",")) {
                tmp = new Path(tmpFile);
                newPath = this.copyRemoteFiles(fs, filesDir, tmp, job, replication);
                try {
                    pathURI = new URI(newPath.toUri().toString() + "#" + newPath.getName());
                    DistributedCache.addCacheFile(pathURI, job);
                }
                catch (URISyntaxException ue) {
                    throw new IOException("Failed to create uri for " + tmpFile);
                }
                DistributedCache.createSymlink(job);
            }
        }
        if (libjars != null) {
            String[] libjarsArr;
            FileSystem.mkdirs(fs, libjarsDir, mapredSysPerms);
            for (String tmpjars : libjarsArr = libjars.split(",")) {
                tmp = new Path(tmpjars);
                newPath = this.copyRemoteFiles(fs, libjarsDir, tmp, job, replication);
                DistributedCache.addArchiveToClassPath(newPath, job);
            }
        }
        if (archives != null) {
            String[] archivesArr;
            FileSystem.mkdirs(fs, archivesDir, mapredSysPerms);
            for (String tmpArchives : archivesArr = archives.split(",")) {
                tmp = new Path(tmpArchives);
                newPath = this.copyRemoteFiles(fs, archivesDir, tmp, job, replication);
                try {
                    pathURI = new URI(newPath.toUri().toString() + "#" + newPath.getName());
                    DistributedCache.addCacheArchive(pathURI, job);
                }
                catch (URISyntaxException ue) {
                    throw new IOException("Failed to create uri for " + tmpArchives);
                }
                DistributedCache.createSymlink(job);
            }
        }
        if ((tarchives = DistributedCache.getCacheArchives(job)) != null) {
            StringBuffer archiveTimestamps = new StringBuffer(String.valueOf(DistributedCache.getTimestamp(job, tarchives[0])));
            for (int i = 1; i < tarchives.length; ++i) {
                archiveTimestamps.append(",");
                archiveTimestamps.append(String.valueOf(DistributedCache.getTimestamp(job, tarchives[i])));
            }
            DistributedCache.setArchiveTimestamps(job, archiveTimestamps.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            StringBuffer fileTimestamps = new StringBuffer(String.valueOf(DistributedCache.getTimestamp(job, tfiles[0])));
            for (int i = 1; i < tfiles.length; ++i) {
                fileTimestamps.append(",");
                fileTimestamps.append(String.valueOf(DistributedCache.getTimestamp(job, tfiles[i])));
            }
            DistributedCache.setFileTimestamps(job, fileTimestamps.toString());
        }
        if ((originalJarPath = job.getJar()) != null) {
            if ("".equals(job.getJobName())) {
                job.setJobName(new Path(originalJarPath).getName());
            }
            job.setJar(submitJarFile.toString());
            fs.copyFromLocalFile(new Path(originalJarPath), submitJarFile);
            fs.setReplication(submitJarFile, replication);
            fs.setPermission(submitJarFile, new FsPermission(JOB_FILE_PERMISSION));
        } else {
            LOG.warn("No job jar file set.  User classes may not be found. See JobConf(Class) or JobConf#setJar(String).");
        }
        job.setUser(ugi.getUserName());
        if (ugi.getGroupNames().length > 0) {
            job.set("group.name", ugi.getGroupNames()[0]);
        }
        if (job.getWorkingDirectory() == null) {
            job.setWorkingDirectory(fs.getWorkingDirectory());
        }
    }

    private UnixUserGroupInformation getUGI(Configuration job) throws IOException {
        UnixUserGroupInformation ugi = null;
        try {
            ugi = UnixUserGroupInformation.login(job, true);
        }
        catch (LoginException e) {
            throw (IOException)new IOException("Failed to get the current user's information.").initCause(e);
        }
        return ugi;
    }

    public RunningJob submitJob(String jobFile) throws FileNotFoundException, InvalidJobConfException, IOException {
        JobConf job = new JobConf(jobFile);
        return this.submitJob(job);
    }

    public RunningJob submitJob(JobConf job) throws FileNotFoundException, IOException {
        try {
            return this.submitJobInternal(job);
        }
        catch (InterruptedException ie) {
            throw new IOException("interrupted", ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("class not found", cnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningJob submitJobInternal(JobConf job) throws FileNotFoundException, ClassNotFoundException, InterruptedException, IOException {
        JobID jobId = this.jobSubmitClient.getNewJobId();
        Path submitJobDir = new Path(this.getSystemDir(), jobId.toString());
        Path submitJarFile = new Path(submitJobDir, "job.jar");
        Path submitSplitFile = new Path(submitJobDir, "job.split");
        this.configureCommandLineOptions(job, submitJobDir, submitJarFile);
        Path submitJobFile = new Path(submitJobDir, "job.xml");
        int reduces = job.getNumReduceTasks();
        JobContext context = new JobContext(job, (io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.JobID)jobId);
        if (reduces == 0 ? job.getUseNewMapper() : job.getUseNewReducer()) {
            OutputFormat<?, ?> output = ReflectionUtils.newInstance(context.getOutputFormatClass(), job);
            output.checkOutputSpecs(context);
        } else {
            job.getOutputFormat().checkOutputSpecs(this.fs, job);
        }
        LOG.debug("Creating splits at " + this.fs.makeQualified(submitSplitFile));
        int maps = job.getUseNewMapper() ? this.writeNewSplits(context, submitSplitFile) : this.writeOldSplits(job, submitSplitFile);
        job.set("mapred.job.split.file", submitSplitFile.toString());
        job.setNumMapTasks(maps);
        FSDataOutputStream out = FileSystem.create(this.fs, submitJobFile, new FsPermission(JOB_FILE_PERMISSION));
        try {
            job.writeXml(out);
        }
        finally {
            out.close();
        }
        JobStatus status = this.jobSubmitClient.submitJob(jobId);
        if (status != null) {
            return new NetworkedJob(status);
        }
        throw new IOException("Could not launch job");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeOldSplits(JobConf job, Path submitSplitFile) throws IOException {
        InputSplit[] splits = job.getInputFormat().getSplits(job, job.getNumMapTasks());
        Arrays.sort(splits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit a, InputSplit b) {
                try {
                    long left = a.getLength();
                    long right = b.getLength();
                    if (left == right) {
                        return 0;
                    }
                    if (left < right) {
                        return 1;
                    }
                    return -1;
                }
                catch (IOException ie) {
                    throw new RuntimeException("Problem getting input split size", ie);
                }
            }
        });
        DataOutputStream out = this.writeSplitsFileHeader(job, submitSplitFile, splits.length);
        try {
            DataOutputBuffer buffer = new DataOutputBuffer();
            RawSplit rawSplit = new RawSplit();
            for (InputSplit split : splits) {
                rawSplit.setClassName(split.getClass().getName());
                buffer.reset();
                split.write(buffer);
                rawSplit.setDataLength(split.getLength());
                rawSplit.setBytes(buffer.getData(), 0, buffer.getLength());
                rawSplit.setLocations(split.getLocations());
                rawSplit.write(out);
            }
        }
        finally {
            out.close();
        }
        return splits.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit> int writeNewSplits(JobContext job, Path submitSplitFile) throws IOException, InterruptedException, ClassNotFoundException {
        JobConf conf = job.getJobConf();
        InputFormat<?, ?> input = ReflectionUtils.newInstance(job.getInputFormatClass(), job.getJobConf());
        List<io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit> splits = input.getSplits(job);
        io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit[] array = splits.toArray(new io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit[splits.size()]);
        Arrays.sort(array, new NewSplitComparator());
        DataOutputStream out = this.writeSplitsFileHeader(conf, submitSplitFile, array.length);
        try {
            if (array.length != 0) {
                DataOutputBuffer buffer = new DataOutputBuffer();
                RawSplit rawSplit = new RawSplit();
                SerializationFactory factory = new SerializationFactory(conf);
                Serializer<?> serializer = factory.getSerializer(array[0].getClass());
                serializer.open(buffer);
                for (io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit split : array) {
                    rawSplit.setClassName(split.getClass().getName());
                    buffer.reset();
                    serializer.serialize(split);
                    rawSplit.setDataLength(split.getLength());
                    rawSplit.setBytes(buffer.getData(), 0, buffer.getLength());
                    rawSplit.setLocations(split.getLocations());
                    rawSplit.write(out);
                }
                serializer.close();
            }
        }
        finally {
            out.close();
        }
        return array.length;
    }

    public static boolean isJobDirValid(Path jobDirPath, FileSystem fs) throws IOException {
        FileStatus[] contents = fs.listStatus(jobDirPath);
        int matchCount = 0;
        if (contents != null && contents.length >= 2) {
            for (FileStatus status : contents) {
                if ("job.xml".equals(status.getPath().getName())) {
                    ++matchCount;
                }
                if (!"job.split".equals(status.getPath().getName())) continue;
                ++matchCount;
            }
            if (matchCount == 2) {
                return true;
            }
        }
        return false;
    }

    private DataOutputStream writeSplitsFileHeader(Configuration conf, Path filename, int length) throws IOException {
        FileSystem fs = filename.getFileSystem(conf);
        FSDataOutputStream out = FileSystem.create(fs, filename, new FsPermission(JOB_FILE_PERMISSION));
        out.write(SPLIT_FILE_HEADER);
        WritableUtils.writeVInt(out, 0);
        WritableUtils.writeVInt(out, length);
        return out;
    }

    private void writeOldSplitsFile(InputSplit[] splits, FSDataOutputStream out) throws IOException {
    }

    static RawSplit[] readSplitFile(DataInput in) throws IOException {
        byte[] header = new byte[SPLIT_FILE_HEADER.length];
        in.readFully(header);
        if (!Arrays.equals(SPLIT_FILE_HEADER, header)) {
            throw new IOException("Invalid header on split file");
        }
        int vers = WritableUtils.readVInt(in);
        if (vers != 0) {
            throw new IOException("Unsupported split version " + vers);
        }
        int len = WritableUtils.readVInt(in);
        RawSplit[] result = new RawSplit[len];
        for (int i = 0; i < len; ++i) {
            result[i] = new RawSplit();
            result[i].readFields(in);
        }
        return result;
    }

    public RunningJob getJob(JobID jobid) throws IOException {
        JobStatus status = this.jobSubmitClient.getJobStatus(jobid);
        if (status != null) {
            return new NetworkedJob(status);
        }
        return null;
    }

    @Deprecated
    public RunningJob getJob(String jobid) throws IOException {
        return this.getJob(JobID.forName(jobid));
    }

    public TaskReport[] getMapTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getMapTaskReports(jobId);
    }

    @Deprecated
    public TaskReport[] getMapTaskReports(String jobId) throws IOException {
        return this.getMapTaskReports(JobID.forName(jobId));
    }

    public TaskReport[] getReduceTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getReduceTaskReports(jobId);
    }

    public TaskReport[] getCleanupTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getCleanupTaskReports(jobId);
    }

    public TaskReport[] getSetupTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getSetupTaskReports(jobId);
    }

    @Deprecated
    public TaskReport[] getReduceTaskReports(String jobId) throws IOException {
        return this.getReduceTaskReports(JobID.forName(jobId));
    }

    public void displayTasks(JobID jobId, String type, String state) throws IOException {
        TaskReport[] reports = new TaskReport[]{};
        if (type.equals("map")) {
            reports = this.getMapTaskReports(jobId);
        } else if (type.equals("reduce")) {
            reports = this.getReduceTaskReports(jobId);
        } else if (type.equals("setup")) {
            reports = this.getSetupTaskReports(jobId);
        } else if (type.equals("cleanup")) {
            reports = this.getCleanupTaskReports(jobId);
        }
        for (TaskReport report : reports) {
            TIPStatus status = report.getCurrentStatus();
            if (!(state.equals("pending") && status == TIPStatus.PENDING || state.equals("running") && status == TIPStatus.RUNNING || state.equals("completed") && status == TIPStatus.COMPLETE || state.equals("failed") && status == TIPStatus.FAILED) && (!state.equals("killed") || status != TIPStatus.KILLED)) continue;
            this.printTaskAttempts(report);
        }
    }

    private void printTaskAttempts(TaskReport report) {
        if (report.getCurrentStatus() == TIPStatus.COMPLETE) {
            System.out.println(report.getSuccessfulTaskAttempt());
        } else if (report.getCurrentStatus() == TIPStatus.RUNNING) {
            for (TaskAttemptID t : report.getRunningTaskAttempts()) {
                System.out.println(t);
            }
        }
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.getClusterStatus(false);
    }

    public ClusterStatus getClusterStatus(boolean detailed) throws IOException {
        return this.jobSubmitClient.getClusterStatus(detailed);
    }

    public JobStatus[] jobsToComplete() throws IOException {
        return this.jobSubmitClient.jobsToComplete();
    }

    private static void downloadProfile(TaskCompletionEvent e) throws IOException {
        URLConnection connection = new URL(JobClient.getTaskLogURL(e.getTaskAttemptId(), e.getTaskTrackerHttp()) + "&filter=profile").openConnection();
        InputStream in = connection.getInputStream();
        FileOutputStream out = new FileOutputStream(e.getTaskAttemptId() + ".profile");
        IOUtils.copyBytes(in, (OutputStream)out, 65536, true);
    }

    public JobStatus[] getAllJobs() throws IOException {
        return this.jobSubmitClient.getAllJobs();
    }

    public static RunningJob runJob(JobConf job) throws IOException {
        JobClient jc = new JobClient(job);
        RunningJob rj = jc.submitJob(job);
        try {
            if (!jc.monitorAndPrintJob(job, rj)) {
                throw new IOException("Job failed!");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return rj;
    }

    public boolean monitorAndPrintJob(JobConf conf, RunningJob job) throws IOException, InterruptedException {
        String lastReport = null;
        TaskStatusFilter filter = JobClient.getTaskOutputFilter(conf);
        JobID jobId = job.getID();
        LOG.info("Running job: " + jobId);
        int eventCounter = 0;
        boolean profiling = conf.getProfileEnabled();
        Configuration.IntegerRanges mapRanges = conf.getProfileTaskRange(true);
        Configuration.IntegerRanges reduceRanges = conf.getProfileTaskRange(false);
        while (!job.isComplete()) {
            Thread.sleep(1000L);
            String report = " map " + StringUtils.formatPercent(job.mapProgress(), 0) + " reduce " + StringUtils.formatPercent(job.reduceProgress(), 0);
            if (!report.equals(lastReport)) {
                LOG.info(report);
                lastReport = report;
            }
            TaskCompletionEvent[] events = job.getTaskCompletionEvents(eventCounter);
            eventCounter += events.length;
            block8: for (TaskCompletionEvent event : events) {
                TaskCompletionEvent.Status status = event.getTaskStatus();
                if (profiling && (status == TaskCompletionEvent.Status.SUCCEEDED || status == TaskCompletionEvent.Status.FAILED) && (event.isMap ? mapRanges : reduceRanges).isIncluded(event.idWithinJob())) {
                    JobClient.downloadProfile(event);
                }
                switch (filter) {
                    case NONE: {
                        continue block8;
                    }
                    case SUCCEEDED: {
                        if (event.getTaskStatus() != TaskCompletionEvent.Status.SUCCEEDED) continue block8;
                        LOG.info(event.toString());
                        JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                        continue block8;
                    }
                    case FAILED: {
                        if (event.getTaskStatus() != TaskCompletionEvent.Status.FAILED) continue block8;
                        LOG.info(event.toString());
                        TaskAttemptID taskId = event.getTaskAttemptId();
                        String[] taskDiagnostics = this.jobSubmitClient.getTaskDiagnostics(taskId);
                        if (taskDiagnostics != null) {
                            for (String diagnostics : taskDiagnostics) {
                                System.err.println(diagnostics);
                            }
                        }
                        JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                        continue block8;
                    }
                    case KILLED: {
                        if (event.getTaskStatus() != TaskCompletionEvent.Status.KILLED) continue block8;
                        LOG.info(event.toString());
                        continue block8;
                    }
                    case ALL: {
                        LOG.info(event.toString());
                        JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                    }
                }
            }
        }
        LOG.info("Job complete: " + jobId);
        job.getCounters().log(LOG);
        return job.isSuccessful();
    }

    static String getTaskLogURL(TaskAttemptID taskId, String baseUrl) {
        return baseUrl + "/tasklog?plaintext=true&taskid=" + taskId;
    }

    private static void displayTaskLogs(TaskAttemptID taskId, String baseUrl) throws IOException {
        if (baseUrl != null) {
            String taskLogUrl = JobClient.getTaskLogURL(taskId, baseUrl);
            JobClient.getTaskLogs(taskId, new URL(taskLogUrl + "&filter=stdout"), System.out);
            JobClient.getTaskLogs(taskId, new URL(taskLogUrl + "&filter=stderr"), System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getTaskLogs(TaskAttemptID taskId, URL taskLogUrl, OutputStream out) {
        try {
            URLConnection connection = taskLogUrl.openConnection();
            BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter(out));
            try {
                String logData = null;
                while ((logData = input.readLine()) != null) {
                    if (logData.length() <= 0) continue;
                    output.write(taskId + ": " + logData + "\n");
                    output.flush();
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn("Error reading task output" + ioe.getMessage());
        }
    }

    static Configuration getConfiguration(String jobTrackerSpec) {
        Configuration conf = new Configuration();
        if (jobTrackerSpec != null) {
            if (jobTrackerSpec.indexOf(":") >= 0) {
                conf.set("mapred.job.tracker", jobTrackerSpec);
            } else {
                String classpathFile = "hadoop-" + jobTrackerSpec + ".xml";
                URL validate = conf.getResource(classpathFile);
                if (validate == null) {
                    throw new RuntimeException(classpathFile + " not found on CLASSPATH");
                }
                conf.addResource(classpathFile);
            }
        }
        return conf;
    }

    @Deprecated
    public void setTaskOutputFilter(TaskStatusFilter newValue) {
        this.taskOutputFilter = newValue;
    }

    public static TaskStatusFilter getTaskOutputFilter(JobConf job) {
        return TaskStatusFilter.valueOf(job.get("jobclient.output.filter", "FAILED"));
    }

    public static void setTaskOutputFilter(JobConf job, TaskStatusFilter newValue) {
        job.set("jobclient.output.filter", newValue.toString());
    }

    @Deprecated
    public TaskStatusFilter getTaskOutputFilter() {
        return this.taskOutputFilter;
    }

    private String getJobPriorityNames() {
        StringBuffer sb = new StringBuffer();
        for (JobPriority p : JobPriority.values()) {
            sb.append(p.name()).append(" ");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private void displayUsage(String cmd) {
        String prefix = "Usage: JobClient ";
        String jobPriorityValues = this.getJobPriorityNames();
        String taskTypes = "map, reduce, setup, cleanup";
        String taskStates = "running, completed";
        if ("-submit".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-file>]");
        } else if ("-status".equals(cmd) || "-kill".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id>]");
        } else if ("-counter".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <group-name> <counter-name>]");
        } else if ("-events".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <from-event-#> <#-of-events>]");
        } else if ("-history".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <jobOutputDir>]");
        } else if ("-list".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " [all]]");
        } else if ("-kill-task".equals(cmd) || "-fail-task".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <task-id>]");
        } else if ("-set-priority".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <priority>]. " + "Valid values for priorities are: " + jobPriorityValues);
        } else if ("-list-active-trackers".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + "]");
        } else if ("-list-blacklisted-trackers".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + "]");
        } else if ("-list-attempt-ids".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <task-type> <task-state>]. " + "Valid values for <task-type> are " + taskTypes + ". " + "Valid values for <task-state> are " + taskStates);
        } else {
            System.err.printf(prefix + "<command> <args>\n", new Object[0]);
            System.err.printf("\t[-submit <job-file>]\n", new Object[0]);
            System.err.printf("\t[-status <job-id>]\n", new Object[0]);
            System.err.printf("\t[-counter <job-id> <group-name> <counter-name>]\n", new Object[0]);
            System.err.printf("\t[-kill <job-id>]\n", new Object[0]);
            System.err.printf("\t[-set-priority <job-id> <priority>]. Valid values for priorities are: " + jobPriorityValues + "\n", new Object[0]);
            System.err.printf("\t[-events <job-id> <from-event-#> <#-of-events>]\n", new Object[0]);
            System.err.printf("\t[-history <jobOutputDir>]\n", new Object[0]);
            System.err.printf("\t[-list [all]]\n", new Object[0]);
            System.err.printf("\t[-list-active-trackers]\n", new Object[0]);
            System.err.printf("\t[-list-blacklisted-trackers]\n", new Object[0]);
            System.err.println("\t[-list-attempt-ids <job-id> <task-type> <task-state>]\n");
            System.err.printf("\t[-kill-task <task-id>]\n", new Object[0]);
            System.err.printf("\t[-fail-task <task-id>]\n\n", new Object[0]);
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] argv) throws Exception {
        int exitCode = -1;
        if (argv.length < 1) {
            this.displayUsage("");
            return exitCode;
        }
        String cmd = argv[0];
        String submitJobFile = null;
        String jobid = null;
        String taskid = null;
        String outputDir = null;
        String counterGroupName = null;
        String counterName = null;
        String newPriority = null;
        String taskType = null;
        String taskState = null;
        int fromEvent = 0;
        int nEvents = 0;
        boolean getStatus2 = false;
        boolean getCounter2 = false;
        boolean killJob = false;
        boolean listEvents = false;
        boolean viewHistory = false;
        boolean viewAllHistory = false;
        boolean listJobs = false;
        boolean listAllJobs = false;
        boolean listActiveTrackers = false;
        boolean listBlacklistedTrackers = false;
        boolean displayTasks = false;
        boolean killTask = false;
        boolean failTask = false;
        boolean setJobPriority = false;
        if ("-submit".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            submitJobFile = argv[1];
        } else if ("-status".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            jobid = argv[1];
            getStatus2 = true;
        } else if ("-counter".equals(cmd)) {
            if (argv.length != 4) {
                this.displayUsage(cmd);
                return exitCode;
            }
            getCounter2 = true;
            jobid = argv[1];
            counterGroupName = argv[2];
            counterName = argv[3];
        } else if ("-kill".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            jobid = argv[1];
            killJob = true;
        } else if ("-set-priority".equals(cmd)) {
            if (argv.length != 3) {
                this.displayUsage(cmd);
                return exitCode;
            }
            jobid = argv[1];
            newPriority = argv[2];
            try {
                JobPriority jp = JobPriority.valueOf(newPriority);
            }
            catch (IllegalArgumentException iae) {
                this.displayUsage(cmd);
                return exitCode;
            }
            setJobPriority = true;
        } else if ("-events".equals(cmd)) {
            if (argv.length != 4) {
                this.displayUsage(cmd);
                return exitCode;
            }
            jobid = argv[1];
            fromEvent = Integer.parseInt(argv[2]);
            nEvents = Integer.parseInt(argv[3]);
            listEvents = true;
        } else if ("-history".equals(cmd)) {
            if (!(argv.length == 2 || argv.length == 3 && "all".equals(argv[1]))) {
                this.displayUsage(cmd);
                return exitCode;
            }
            viewHistory = true;
            if (argv.length == 3 && "all".equals(argv[1])) {
                viewAllHistory = true;
                outputDir = argv[2];
            } else {
                outputDir = argv[1];
            }
        } else if ("-list".equals(cmd)) {
            if (!(argv.length == 1 || argv.length == 2 && "all".equals(argv[1]))) {
                this.displayUsage(cmd);
                return exitCode;
            }
            if (argv.length == 2 && "all".equals(argv[1])) {
                listAllJobs = true;
            } else {
                listJobs = true;
            }
        } else if ("-kill-task".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            killTask = true;
            taskid = argv[1];
        } else if ("-fail-task".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            failTask = true;
            taskid = argv[1];
        } else if ("-list-active-trackers".equals(cmd)) {
            if (argv.length != 1) {
                this.displayUsage(cmd);
                return exitCode;
            }
            listActiveTrackers = true;
        } else if ("-list-blacklisted-trackers".equals(cmd)) {
            if (argv.length != 1) {
                this.displayUsage(cmd);
                return exitCode;
            }
            listBlacklistedTrackers = true;
        } else if ("-list-attempt-ids".equals(cmd)) {
            if (argv.length != 4) {
                this.displayUsage(cmd);
                return exitCode;
            }
            jobid = argv[1];
            taskType = argv[2];
            taskState = argv[3];
            displayTasks = true;
        } else {
            this.displayUsage(cmd);
            return exitCode;
        }
        JobConf conf = null;
        conf = submitJobFile != null ? new JobConf(submitJobFile) : new JobConf(this.getConf());
        this.init(conf);
        try {
            if (submitJobFile != null) {
                RunningJob job = this.submitJob(conf);
                System.out.println("Created job " + job.getID());
                exitCode = 0;
            } else if (getStatus2) {
                RunningJob job = this.getJob(JobID.forName(jobid));
                if (job == null) {
                    System.out.println("Could not find job " + jobid);
                } else {
                    System.out.println();
                    System.out.println(job);
                    System.out.println(job.getCounters());
                    exitCode = 0;
                }
            } else if (getCounter2) {
                RunningJob job = this.getJob(JobID.forName(jobid));
                if (job == null) {
                    System.out.println("Could not find job " + jobid);
                } else {
                    Counters counters = job.getCounters();
                    Counters.Group group = counters.getGroup(counterGroupName);
                    Counters.Counter counter = group.getCounterForName(counterName);
                    System.out.println(counter.getCounter());
                    exitCode = 0;
                }
            } else if (killJob) {
                RunningJob job = this.getJob(JobID.forName(jobid));
                if (job == null) {
                    System.out.println("Could not find job " + jobid);
                } else {
                    job.killJob();
                    System.out.println("Killed job " + jobid);
                    exitCode = 0;
                }
            } else if (setJobPriority) {
                RunningJob job = this.getJob(JobID.forName(jobid));
                if (job == null) {
                    System.out.println("Could not find job " + jobid);
                } else {
                    job.setJobPriority(newPriority);
                    System.out.println("Changed job priority.");
                    exitCode = 0;
                }
            } else if (viewHistory) {
                this.viewHistory(outputDir, viewAllHistory);
                exitCode = 0;
            } else if (listEvents) {
                this.listEvents(JobID.forName(jobid), fromEvent, nEvents);
                exitCode = 0;
            } else if (listJobs) {
                this.listJobs();
                exitCode = 0;
            } else if (listAllJobs) {
                this.listAllJobs();
                exitCode = 0;
            } else if (listActiveTrackers) {
                this.listActiveTrackers();
                exitCode = 0;
            } else if (listBlacklistedTrackers) {
                this.listBlacklistedTrackers();
                exitCode = 0;
            } else if (displayTasks) {
                this.displayTasks(JobID.forName(jobid), taskType, taskState);
            } else if (killTask) {
                if (this.jobSubmitClient.killTask(TaskAttemptID.forName(taskid), false)) {
                    System.out.println("Killed task " + taskid);
                    exitCode = 0;
                } else {
                    System.out.println("Could not kill task " + taskid);
                    exitCode = -1;
                }
            } else if (failTask) {
                if (this.jobSubmitClient.killTask(TaskAttemptID.forName(taskid), true)) {
                    System.out.println("Killed task " + taskid + " by failing it");
                    exitCode = 0;
                } else {
                    System.out.println("Could not fail task " + taskid);
                    exitCode = -1;
                }
            }
        }
        finally {
            this.close();
        }
        return exitCode;
    }

    private void viewHistory(String outputDir, boolean all) throws IOException {
        HistoryViewer historyViewer = new HistoryViewer(outputDir, this.getConf(), all);
        historyViewer.print();
    }

    private void listEvents(JobID jobId, int fromEventId, int numEvents) throws IOException {
        TaskCompletionEvent[] events = this.jobSubmitClient.getTaskCompletionEvents(jobId, fromEventId, numEvents);
        System.out.println("Task completion events for " + jobId);
        System.out.println("Number of events (from " + fromEventId + ") are: " + events.length);
        for (TaskCompletionEvent event : events) {
            System.out.println((Object)((Object)event.getTaskStatus()) + " " + event.getTaskAttemptId() + " " + JobClient.getTaskLogURL(event.getTaskAttemptId(), event.getTaskTrackerHttp()));
        }
    }

    private void listJobs() throws IOException {
        JobStatus[] jobs = this.jobsToComplete();
        if (jobs == null) {
            jobs = new JobStatus[]{};
        }
        System.out.printf("%d jobs currently running\n", jobs.length);
        this.displayJobList(jobs);
    }

    private void listAllJobs() throws IOException {
        JobStatus[] jobs = this.getAllJobs();
        if (jobs == null) {
            jobs = new JobStatus[]{};
        }
        System.out.printf("%d jobs submitted\n", jobs.length);
        System.out.printf("States are:\n\tRunning : 1\tSucceded : 2\tFailed : 3\tPrep : 4\n", new Object[0]);
        this.displayJobList(jobs);
    }

    private void listActiveTrackers() throws IOException {
        ClusterStatus c = this.jobSubmitClient.getClusterStatus(true);
        Collection<String> trackers = c.getActiveTrackerNames();
        for (String trackerName : trackers) {
            System.out.println(trackerName);
        }
    }

    private void listBlacklistedTrackers() throws IOException {
        ClusterStatus c = this.jobSubmitClient.getClusterStatus(true);
        Collection<String> trackers = c.getBlacklistedTrackerNames();
        for (String trackerName : trackers) {
            System.out.println(trackerName);
        }
    }

    void displayJobList(JobStatus[] jobs) {
        System.out.printf("JobId\tState\tStartTime\tUserName\tPriority\tSchedulingInfo\n", new Object[0]);
        for (JobStatus job : jobs) {
            System.out.printf("%s\t%d\t%d\t%s\t%s\t%s\n", job.getJobID(), job.getRunState(), job.getStartTime(), job.getUsername(), job.getJobPriority().name(), job.getSchedulingInfo());
        }
    }

    public int getDefaultMaps() throws IOException {
        return this.getClusterStatus().getMaxMapTasks();
    }

    public int getDefaultReduces() throws IOException {
        return this.getClusterStatus().getMaxReduceTasks();
    }

    public Path getSystemDir() {
        if (this.sysDir == null) {
            this.sysDir = new Path(this.jobSubmitClient.getSystemDir());
        }
        return this.sysDir;
    }

    public JobQueueInfo[] getQueues() throws IOException {
        return this.jobSubmitClient.getQueues();
    }

    public JobStatus[] getJobsFromQueue(String queueName) throws IOException {
        return this.jobSubmitClient.getJobsFromQueue(queueName);
    }

    public JobQueueInfo getQueueInfo(String queueName) throws IOException {
        return this.jobSubmitClient.getQueueInfo(queueName);
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new JobClient(), argv);
        System.exit(res);
    }

    static {
        Configuration.addDefaultResource("mapred-default.xml");
        Configuration.addDefaultResource("mapred-site.xml");
        JOB_FILE_PERMISSION = FsPermission.createImmutable((short)420);
        JOB_DIR_PERMISSION = FsPermission.createImmutable((short)511);
        SPLIT_FILE_HEADER = "SPL".getBytes();
    }

    static class RawSplit
    implements Writable {
        private String splitClass;
        private BytesWritable bytes = new BytesWritable();
        private String[] locations;
        long dataLength;

        RawSplit() {
        }

        public void setBytes(byte[] data, int offset, int length) {
            this.bytes.set(data, offset, length);
        }

        public void setClassName(String className) {
            this.splitClass = className;
        }

        public String getClassName() {
            return this.splitClass;
        }

        public BytesWritable getBytes() {
            return this.bytes;
        }

        public void clearBytes() {
            this.bytes = null;
        }

        public void setLocations(String[] locations) {
            this.locations = locations;
        }

        public String[] getLocations() {
            return this.locations;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.splitClass = Text.readString(in);
            this.dataLength = in.readLong();
            this.bytes.readFields(in);
            int len = WritableUtils.readVInt(in);
            this.locations = new String[len];
            for (int i = 0; i < len; ++i) {
                this.locations[i] = Text.readString(in);
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            Text.writeString(out, this.splitClass);
            out.writeLong(this.dataLength);
            this.bytes.write(out);
            WritableUtils.writeVInt(out, this.locations.length);
            for (int i = 0; i < this.locations.length; ++i) {
                Text.writeString(out, this.locations[i]);
            }
        }

        public long getDataLength() {
            return this.dataLength;
        }

        public void setDataLength(long l) {
            this.dataLength = l;
        }
    }

    private static class NewSplitComparator
    implements Comparator<io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit> {
        private NewSplitComparator() {
        }

        @Override
        public int compare(io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit o1, io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("exception in compare", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("exception in compare", ie);
            }
        }
    }

    class NetworkedJob
    implements RunningJob {
        JobProfile profile;
        JobStatus status;
        long statustime;

        public NetworkedJob(JobStatus job) throws IOException {
            this.status = job;
            this.profile = JobClient.this.jobSubmitClient.getJobProfile(job.getJobID());
            this.statustime = System.currentTimeMillis();
        }

        synchronized void ensureFreshStatus() throws IOException {
            if (System.currentTimeMillis() - this.statustime > 2000L) {
                this.updateStatus();
            }
        }

        synchronized void updateStatus() throws IOException {
            this.status = JobClient.this.jobSubmitClient.getJobStatus(this.profile.getJobID());
            this.statustime = System.currentTimeMillis();
        }

        @Override
        public JobID getID() {
            return this.profile.getJobID();
        }

        @Override
        @Deprecated
        public String getJobID() {
            return this.profile.getJobID().toString();
        }

        @Override
        public String getJobName() {
            return this.profile.getJobName();
        }

        @Override
        public String getJobFile() {
            return this.profile.getJobFile();
        }

        @Override
        public String getTrackingURL() {
            return this.profile.getURL().toString();
        }

        @Override
        public float mapProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.mapProgress();
        }

        @Override
        public float reduceProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.reduceProgress();
        }

        @Override
        public float cleanupProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.cleanupProgress();
        }

        @Override
        public float setupProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.setupProgress();
        }

        @Override
        public synchronized boolean isComplete() throws IOException {
            this.updateStatus();
            return this.status.getRunState() == 2 || this.status.getRunState() == 3 || this.status.getRunState() == 5;
        }

        @Override
        public synchronized boolean isSuccessful() throws IOException {
            this.updateStatus();
            return this.status.getRunState() == 2;
        }

        @Override
        public void waitForCompletion() throws IOException {
            while (!this.isComplete()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public synchronized int getJobState() throws IOException {
            this.updateStatus();
            return this.status.getRunState();
        }

        @Override
        public synchronized void killJob() throws IOException {
            JobClient.this.jobSubmitClient.killJob(this.getID());
        }

        @Override
        public synchronized void setJobPriority(String priority) throws IOException {
            JobClient.this.jobSubmitClient.setJobPriority(this.getID(), priority);
        }

        @Override
        public synchronized void killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
            JobClient.this.jobSubmitClient.killTask(taskId, shouldFail);
        }

        @Override
        @Deprecated
        public synchronized void killTask(String taskId, boolean shouldFail) throws IOException {
            this.killTask(TaskAttemptID.forName(taskId), shouldFail);
        }

        @Override
        public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int startFrom) throws IOException {
            return JobClient.this.jobSubmitClient.getTaskCompletionEvents(this.getID(), startFrom, 10);
        }

        public String toString() {
            try {
                this.updateStatus();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "Job: " + this.profile.getJobID() + "\n" + "file: " + this.profile.getJobFile() + "\n" + "tracking URL: " + this.profile.getURL() + "\n" + "map() completion: " + this.status.mapProgress() + "\n" + "reduce() completion: " + this.status.reduceProgress();
        }

        @Override
        public Counters getCounters() throws IOException {
            return JobClient.this.jobSubmitClient.getJobCounters(this.getID());
        }

        @Override
        public String[] getTaskDiagnostics(TaskAttemptID id) throws IOException {
            return JobClient.this.jobSubmitClient.getTaskDiagnostics(id);
        }
    }

    public static enum TaskStatusFilter {
        NONE,
        KILLED,
        FAILED,
        SUCCEEDED,
        ALL;

    }
}

