/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobPriority;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JobStatus
implements Writable,
Cloneable {
    public static final int RUNNING = 1;
    public static final int SUCCEEDED = 2;
    public static final int FAILED = 3;
    public static final int PREP = 4;
    public static final int KILLED = 5;
    private JobID jobid;
    private float mapProgress;
    private float reduceProgress;
    private float cleanupProgress;
    private float setupProgress;
    private int runState;
    private long startTime;
    private String user;
    private JobPriority priority;
    private String schedulingInfo = "NA";

    public JobStatus() {
    }

    public JobStatus(JobID jobid, float mapProgress, float reduceProgress, float cleanupProgress, int runState) {
        this(jobid, mapProgress, reduceProgress, cleanupProgress, runState, JobPriority.NORMAL);
    }

    public JobStatus(JobID jobid, float mapProgress, float reduceProgress, int runState) {
        this(jobid, mapProgress, reduceProgress, 0.0f, runState);
    }

    public JobStatus(JobID jobid, float mapProgress, float reduceProgress, float cleanupProgress, int runState, JobPriority jp) {
        this(jobid, 0.0f, mapProgress, reduceProgress, cleanupProgress, runState, jp);
    }

    public JobStatus(JobID jobid, float setupProgress, float mapProgress, float reduceProgress, float cleanupProgress, int runState, JobPriority jp) {
        this.jobid = jobid;
        this.setupProgress = setupProgress;
        this.mapProgress = mapProgress;
        this.reduceProgress = reduceProgress;
        this.cleanupProgress = cleanupProgress;
        this.runState = runState;
        this.user = "nobody";
        if (jp == null) {
            throw new IllegalArgumentException("Job Priority cannot be null.");
        }
        this.priority = jp;
    }

    @Deprecated
    public String getJobId() {
        return this.jobid.toString();
    }

    public JobID getJobID() {
        return this.jobid;
    }

    public synchronized float mapProgress() {
        return this.mapProgress;
    }

    synchronized void setMapProgress(float p) {
        this.mapProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    public synchronized float cleanupProgress() {
        return this.cleanupProgress;
    }

    synchronized void setCleanupProgress(float p) {
        this.cleanupProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    public synchronized float setupProgress() {
        return this.setupProgress;
    }

    synchronized void setSetupProgress(float p) {
        this.setupProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    public synchronized float reduceProgress() {
        return this.reduceProgress;
    }

    synchronized void setReduceProgress(float p) {
        this.reduceProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    public synchronized int getRunState() {
        return this.runState;
    }

    public synchronized void setRunState(int state) {
        this.runState = state;
    }

    synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
    }

    synchronized void setUsername(String userName) {
        this.user = userName;
    }

    public synchronized String getUsername() {
        return this.user;
    }

    public synchronized String getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public synchronized void setSchedulingInfo(String schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
    }

    public synchronized JobPriority getJobPriority() {
        return this.priority;
    }

    public synchronized void setJobPriority(JobPriority jp) {
        if (jp == null) {
            throw new IllegalArgumentException("Job priority cannot be null.");
        }
        this.priority = jp;
    }

    public synchronized boolean isJobComplete() {
        return this.runState == 2 || this.runState == 3 || this.runState == 5;
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        this.jobid.write(out);
        out.writeFloat(this.setupProgress);
        out.writeFloat(this.mapProgress);
        out.writeFloat(this.reduceProgress);
        out.writeFloat(this.cleanupProgress);
        out.writeInt(this.runState);
        out.writeLong(this.startTime);
        Text.writeString(out, this.user);
        WritableUtils.writeEnum(out, this.priority);
        Text.writeString(out, this.schedulingInfo);
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        this.jobid = JobID.read(in);
        this.setupProgress = in.readFloat();
        this.mapProgress = in.readFloat();
        this.reduceProgress = in.readFloat();
        this.cleanupProgress = in.readFloat();
        this.runState = in.readInt();
        this.startTime = in.readLong();
        this.user = Text.readString(in);
        this.priority = WritableUtils.readEnum(in, JobPriority.class);
        this.schedulingInfo = Text.readString(in);
    }

    static {
        WritableFactories.setFactory(JobStatus.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new JobStatus();
            }
        });
    }
}

