/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.DataOutputBuffer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.OutputBuffer;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.SequenceFile;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.Progress;
import java.io.DataOutputStream;
import java.io.IOException;

class MRSortResultIterator
implements SequenceFile.Sorter.RawKeyValueIterator {
    private int count;
    private int[] pointers;
    private int[] startOffsets;
    private int[] keyLengths;
    private int[] valLengths;
    private int currStartOffsetIndex;
    private int currIndexInPointers;
    private OutputBuffer keyValBuffer;
    private DataOutputBuffer key = new DataOutputBuffer();
    private InMemUncompressedBytes value = new InMemUncompressedBytes();

    public MRSortResultIterator(OutputBuffer keyValBuffer, int[] pointers, int[] startOffsets, int[] keyLengths, int[] valLengths) {
        this.count = pointers.length;
        this.pointers = pointers;
        this.startOffsets = startOffsets;
        this.keyLengths = keyLengths;
        this.valLengths = valLengths;
        this.keyValBuffer = keyValBuffer;
    }

    @Override
    public Progress getProgress() {
        return null;
    }

    @Override
    public DataOutputBuffer getKey() throws IOException {
        int currKeyOffset = this.startOffsets[this.currStartOffsetIndex];
        int currKeyLength = this.keyLengths[this.currStartOffsetIndex];
        this.key.reset();
        this.key.write(this.keyValBuffer.getData(), currKeyOffset, currKeyLength);
        return this.key;
    }

    @Override
    public SequenceFile.ValueBytes getValue() throws IOException {
        this.value.reset(this.keyValBuffer, this.startOffsets[this.currStartOffsetIndex] + this.keyLengths[this.currStartOffsetIndex], this.valLengths[this.currStartOffsetIndex]);
        return this.value;
    }

    @Override
    public boolean next() throws IOException {
        if (this.count == this.currIndexInPointers) {
            return false;
        }
        this.currStartOffsetIndex = this.pointers[this.currIndexInPointers];
        ++this.currIndexInPointers;
        return true;
    }

    @Override
    public void close() {
    }

    private static class InMemUncompressedBytes
    implements SequenceFile.ValueBytes {
        private byte[] data;
        int start;
        int dataSize;

        private InMemUncompressedBytes() {
        }

        private void reset(OutputBuffer d, int start, int length) throws IOException {
            this.data = d.getData();
            this.start = start;
            this.dataSize = length;
        }

        @Override
        public int getSize() {
            return this.dataSize;
        }

        @Override
        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            outStream.write(this.data, this.start, this.dataSize);
        }

        @Override
        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new IllegalArgumentException("UncompressedBytes cannot be compressed!");
        }
    }
}

