/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.Counters;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TIPStatus;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class TaskReport
implements Writable {
    private TaskID taskid;
    private float progress;
    private String state;
    private String[] diagnostics;
    private long startTime;
    private long finishTime;
    private Counters counters;
    private TIPStatus currentStatus;
    private Collection<TaskAttemptID> runningAttempts = new ArrayList<TaskAttemptID>();
    private TaskAttemptID successfulAttempt = new TaskAttemptID();

    public TaskReport() {
        this.taskid = new TaskID();
    }

    @Deprecated
    TaskReport(TaskID taskid, float progress, String state, String[] diagnostics, long startTime, long finishTime, Counters counters) {
        this(taskid, progress, state, diagnostics, null, startTime, finishTime, counters);
    }

    TaskReport(TaskID taskid, float progress, String state, String[] diagnostics, TIPStatus currentStatus, long startTime, long finishTime, Counters counters) {
        this.taskid = taskid;
        this.progress = progress;
        this.state = state;
        this.diagnostics = diagnostics;
        this.currentStatus = currentStatus;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.counters = counters;
    }

    @Deprecated
    public String getTaskId() {
        return this.taskid.toString();
    }

    public TaskID getTaskID() {
        return this.taskid;
    }

    public float getProgress() {
        return this.progress;
    }

    public String getState() {
        return this.state;
    }

    public String[] getDiagnostics() {
        return this.diagnostics;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public TIPStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setSuccessfulAttempt(TaskAttemptID t) {
        this.successfulAttempt = t;
    }

    public TaskAttemptID getSuccessfulTaskAttempt() {
        return this.successfulAttempt;
    }

    public void setRunningTaskAttempts(Collection<TaskAttemptID> runningAttempts) {
        this.runningAttempts = runningAttempts;
    }

    public Collection<TaskAttemptID> getRunningTaskAttempts() {
        return this.runningAttempts;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(TaskReport.class)) {
            TaskReport report = (TaskReport)o;
            return this.counters.equals(report.getCounters()) && Arrays.toString(this.diagnostics).equals(Arrays.toString(report.getDiagnostics())) && this.finishTime == report.getFinishTime() && this.progress == report.getProgress() && this.startTime == report.getStartTime() && this.state.equals(report.getState()) && this.taskid.equals(report.getTaskID());
        }
        return false;
    }

    public int hashCode() {
        return (this.counters.toString() + Arrays.toString(this.diagnostics) + this.finishTime + this.progress + this.startTime + this.state + this.taskid.toString()).hashCode();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.taskid.write(out);
        out.writeFloat(this.progress);
        Text.writeString(out, this.state);
        out.writeLong(this.startTime);
        out.writeLong(this.finishTime);
        WritableUtils.writeStringArray(out, this.diagnostics);
        this.counters.write(out);
        WritableUtils.writeEnum(out, this.currentStatus);
        if (this.currentStatus == TIPStatus.RUNNING) {
            WritableUtils.writeVInt(out, this.runningAttempts.size());
            TaskAttemptID[] t = new TaskAttemptID[]{};
            t = this.runningAttempts.toArray(t);
            for (int i = 0; i < t.length; ++i) {
                t[i].write(out);
            }
        } else if (this.currentStatus == TIPStatus.COMPLETE) {
            this.successfulAttempt.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.taskid.readFields(in);
        this.progress = in.readFloat();
        this.state = Text.readString(in);
        this.startTime = in.readLong();
        this.finishTime = in.readLong();
        this.diagnostics = WritableUtils.readStringArray(in);
        this.counters = new Counters();
        this.counters.readFields(in);
        this.currentStatus = WritableUtils.readEnum(in, TIPStatus.class);
        if (this.currentStatus == TIPStatus.RUNNING) {
            int num = WritableUtils.readVInt(in);
            for (int i = 0; i < num; ++i) {
                TaskAttemptID t = new TaskAttemptID();
                t.readFields(in);
                this.runningAttempts.add(t);
            }
        } else if (this.currentStatus == TIPStatus.COMPLETE) {
            this.successfulAttempt.readFields(in);
        }
    }
}

