/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.NullWritable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionCodec;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.compress.GzipCodec;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.FileOutputFormat;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.RecordWriter;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.Progressable;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

@Deprecated
public class TextOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    @Override
    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        boolean isCompressed = TextOutputFormat.getCompressOutput(job);
        String keyValueSeparator = job.get("mapred.textoutputformat.separator", "\t");
        if (!isCompressed) {
            Path file = FileOutputFormat.getTaskOutputPath(job, name);
            FileSystem fs = file.getFileSystem(job);
            FSDataOutputStream fileOut = fs.create(file, progress);
            return new LineRecordWriter(fileOut, keyValueSeparator);
        }
        Class<CompressionCodec> codecClass = TextOutputFormat.getOutputCompressorClass(job, GzipCodec.class);
        CompressionCodec codec = ReflectionUtils.newInstance(codecClass, job);
        Path file = FileOutputFormat.getTaskOutputPath(job, name + codec.getDefaultExtension());
        FileSystem fs = file.getFileSystem(job);
        FSDataOutputStream fileOut = fs.create(file, progress);
        return new LineRecordWriter(new DataOutputStream(codec.createOutputStream(fileOut)), keyValueSeparator);
    }

    protected static class LineRecordWriter<K, V>
    implements RecordWriter<K, V> {
        private static final String utf8 = "UTF-8";
        private static final byte[] newline;
        protected DataOutputStream out;
        private final byte[] keyValueSeparator;

        public LineRecordWriter(DataOutputStream out, String keyValueSeparator) {
            this.out = out;
            try {
                this.keyValueSeparator = keyValueSeparator.getBytes(utf8);
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException("can't find UTF-8 encoding");
            }
        }

        public LineRecordWriter(DataOutputStream out) {
            this(out, "\t");
        }

        private void writeObject(Object o) throws IOException {
            if (o instanceof Text) {
                Text to = (Text)o;
                this.out.write(to.getBytes(), 0, to.getLength());
            } else {
                this.out.write(o.toString().getBytes(utf8));
            }
        }

        @Override
        public synchronized void write(K key, V value) throws IOException {
            boolean nullValue;
            boolean nullKey = key == null || key instanceof NullWritable;
            boolean bl = nullValue = value == null || value instanceof NullWritable;
            if (nullKey && nullValue) {
                return;
            }
            if (!nullKey) {
                this.writeObject(key);
            }
            if (!nullKey && !nullValue) {
                this.out.write(this.keyValueSeparator);
            }
            if (!nullValue) {
                this.writeObject(value);
            }
            this.out.write(newline);
        }

        @Override
        public synchronized void close(Reporter reporter) throws IOException {
            this.out.close();
        }

        static {
            try {
                newline = "\n".getBytes(utf8);
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException("can't find UTF-8 encoding");
            }
        }
    }
}

