/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.DoubleValueSum;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.LongValueMax;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.LongValueMin;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.LongValueSum;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.StringValueMax;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.StringValueMin;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.UniqValueCount;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorDescriptor;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.ValueHistogram;
import java.util.ArrayList;
import java.util.Map;

public class ValueAggregatorBaseDescriptor
implements ValueAggregatorDescriptor {
    public static final String UNIQ_VALUE_COUNT = "UniqValueCount";
    public static final String LONG_VALUE_SUM = "LongValueSum";
    public static final String DOUBLE_VALUE_SUM = "DoubleValueSum";
    public static final String VALUE_HISTOGRAM = "ValueHistogram";
    public static final String LONG_VALUE_MAX = "LongValueMax";
    public static final String LONG_VALUE_MIN = "LongValueMin";
    public static final String STRING_VALUE_MAX = "StringValueMax";
    public static final String STRING_VALUE_MIN = "StringValueMin";
    private static long maxNumItems = Long.MAX_VALUE;
    public String inputFile = null;

    public static Map.Entry<Text, Text> generateEntry(String type, String id, Text val) {
        Text key = new Text(type + ":" + id);
        return new MyEntry(key, val);
    }

    public static ValueAggregator generateValueAggregator(String type) {
        ValueAggregator retv = null;
        if (type.compareToIgnoreCase(LONG_VALUE_SUM) == 0) {
            retv = new LongValueSum();
        }
        if (type.compareToIgnoreCase(LONG_VALUE_MAX) == 0) {
            retv = new LongValueMax();
        } else if (type.compareToIgnoreCase(LONG_VALUE_MIN) == 0) {
            retv = new LongValueMin();
        } else if (type.compareToIgnoreCase(STRING_VALUE_MAX) == 0) {
            retv = new StringValueMax();
        } else if (type.compareToIgnoreCase(STRING_VALUE_MIN) == 0) {
            retv = new StringValueMin();
        } else if (type.compareToIgnoreCase(DOUBLE_VALUE_SUM) == 0) {
            retv = new DoubleValueSum();
        } else if (type.compareToIgnoreCase(UNIQ_VALUE_COUNT) == 0) {
            retv = new UniqValueCount(maxNumItems);
        } else if (type.compareToIgnoreCase(VALUE_HISTOGRAM) == 0) {
            retv = new ValueHistogram();
        }
        return retv;
    }

    @Override
    public ArrayList<Map.Entry<Text, Text>> generateKeyValPairs(Object key, Object val) {
        ArrayList<Map.Entry<Text, Text>> retv = new ArrayList<Map.Entry<Text, Text>>();
        String countType = LONG_VALUE_SUM;
        String id = "record_count";
        Map.Entry<Text, Text> e = ValueAggregatorBaseDescriptor.generateEntry(countType, id, ONE);
        if (e != null) {
            retv.add(e);
        }
        if (this.inputFile != null && (e = ValueAggregatorBaseDescriptor.generateEntry(countType, this.inputFile, ONE)) != null) {
            retv.add(e);
        }
        return retv;
    }

    @Override
    public void configure(JobConf job) {
        this.inputFile = job.get("map.input.file");
        maxNumItems = job.getLong("aggregate.max.num.unique.values", Long.MAX_VALUE);
    }

    private static class MyEntry
    implements Map.Entry<Text, Text> {
        Text key;
        Text val;

        @Override
        public Text getKey() {
            return this.key;
        }

        @Override
        public Text getValue() {
            return this.val;
        }

        @Override
        public Text setValue(Text val) {
            this.val = val;
            return val;
        }

        public MyEntry(Text key, Text val) {
            this.key = key;
            this.val = val;
        }
    }
}

