/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce;

import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.ID;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.mapreduce.JobID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;

public class TaskID
extends io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.ID {
    protected static final String TASK = "task";
    protected static final NumberFormat idFormat = NumberFormat.getInstance();
    private JobID jobId;
    private boolean isMap;

    public TaskID(JobID jobId, boolean isMap, int id) {
        super(id);
        if (jobId == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        this.jobId = jobId;
        this.isMap = isMap;
    }

    public TaskID(String jtIdentifier, int jobId, boolean isMap, int id) {
        this(new JobID(jtIdentifier, jobId), isMap, id);
    }

    public TaskID() {
        this.jobId = new JobID();
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public boolean isMap() {
        return this.isMap;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TaskID that = (TaskID)o;
        return this.isMap == that.isMap && this.jobId.equals(that.jobId);
    }

    @Override
    public int compareTo(ID o) {
        TaskID that = (TaskID)o;
        int jobComp = this.jobId.compareTo(that.jobId);
        if (jobComp == 0) {
            if (this.isMap == that.isMap) {
                return this.id - that.id;
            }
            return this.isMap ? -1 : 1;
        }
        return jobComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(TASK)).toString();
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.jobId.appendTo(builder).append('_').append(this.isMap ? (char)'m' : 'r').append('_').append(idFormat.format(this.id));
    }

    @Override
    public int hashCode() {
        return this.jobId.hashCode() * 524287 + this.id;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.jobId.readFields(in);
        this.isMap = in.readBoolean();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.jobId.write(out);
        out.writeBoolean(this.isMap);
    }

    public static TaskID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split("_");
            if (parts.length == 5 && parts[0].equals(TASK)) {
                boolean isMap = false;
                if (parts[3].equals("m")) {
                    isMap = true;
                } else if (parts[3].equals("r")) {
                    isMap = false;
                } else {
                    throw new Exception();
                }
                return new io.trino.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskID(parts[1], Integer.parseInt(parts[2]), isMap, Integer.parseInt(parts[4]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("TaskId string : " + str + " is not properly formed");
    }

    static {
        idFormat.setGroupingUsed(false);
        idFormat.setMinimumIntegerDigits(6);
    }
}

