/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class DNS {
    public static String reverseDns(InetAddress hostIp, String ns) throws NamingException {
        String[] parts = hostIp.getHostAddress().split("\\.");
        String reverseIP = parts[3] + "." + parts[2] + "." + parts[1] + "." + parts[0] + ".in-addr.arpa";
        InitialDirContext ictx = new InitialDirContext();
        Attributes attribute = ictx.getAttributes("dns://" + (ns == null ? "" : ns) + "/" + reverseIP, new String[]{"PTR"});
        ictx.close();
        return attribute.get("PTR").get().toString();
    }

    public static String[] getIPs(String strInterface) throws UnknownHostException {
        try {
            NetworkInterface netIF = NetworkInterface.getByName(strInterface);
            if (netIF == null) {
                return new String[]{InetAddress.getLocalHost().getHostAddress()};
            }
            Vector<String> ips = new Vector<String>();
            Enumeration<InetAddress> e = netIF.getInetAddresses();
            while (e.hasMoreElements()) {
                ips.add(e.nextElement().getHostAddress());
            }
            return ips.toArray(new String[0]);
        }
        catch (SocketException e) {
            return new String[]{InetAddress.getLocalHost().getHostAddress()};
        }
    }

    public static String getDefaultIP(String strInterface) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        return ips[0];
    }

    public static String[] getHosts(String strInterface, String nameserver) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        Vector<String> hosts = new Vector<String>();
        for (int ctr = 0; ctr < ips.length; ++ctr) {
            try {
                hosts.add(DNS.reverseDns(InetAddress.getByName(ips[ctr]), nameserver));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (hosts.size() == 0) {
            return new String[]{InetAddress.getLocalHost().getCanonicalHostName()};
        }
        return hosts.toArray(new String[0]);
    }

    public static String[] getHosts(String strInterface) throws UnknownHostException {
        return DNS.getHosts(strInterface, null);
    }

    public static String getDefaultHost(String strInterface, String nameserver) throws UnknownHostException {
        if (strInterface.equals("default")) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        if (nameserver != null && nameserver.equals("default")) {
            return DNS.getDefaultHost(strInterface);
        }
        String[] hosts = DNS.getHosts(strInterface, nameserver);
        return hosts[0];
    }

    public static String getDefaultHost(String strInterface) throws UnknownHostException {
        return DNS.getDefaultHost(strInterface, null);
    }
}

