/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hadoop.util;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;

public class NativeCodeLoader {
    private static final Log LOG = LogFactory.getLog(NativeCodeLoader.class);
    private static boolean nativeCodeLoaded = false;

    public static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    public boolean getLoadNativeLibraries(Configuration conf) {
        return conf.getBoolean("hadoop.native.lib", true);
    }

    public void setLoadNativeLibraries(Configuration conf, boolean loadNativeLibraries) {
        conf.setBoolean("hadoop.native.lib", loadNativeLibraries);
    }

    static {
        LOG.debug("Trying to load the custom-built native-hadoop library...");
        try {
            System.loadLibrary("hadoop");
            LOG.info("Loaded the native-hadoop library");
            nativeCodeLoaded = true;
        }
        catch (Throwable t) {
            LOG.debug("Failed to load native-hadoop with error: " + t);
            LOG.debug("java.library.path=" + System.getProperty("java.library.path"));
        }
        if (!nativeCodeLoaded) {
            LOG.warn("Unable to load native-hadoop library for your platform... using builtin-java classes where applicable");
        }
    }
}

