/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.common.util;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ShutdownHookManager {
    private static final ShutdownHookManager MGR = new ShutdownHookManager();
    private static final Log LOG = LogFactory.getLog(ShutdownHookManager.class);
    private final Set<HookEntry> hooks = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean shutdownInProgress = new AtomicBoolean(false);

    private ShutdownHookManager() {
    }

    static List<Runnable> getShutdownHooksInOrder() {
        return MGR.getShutdownHooksInOrderInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Runnable> getShutdownHooksInOrderInternal() {
        ArrayList<HookEntry> list;
        Set<HookEntry> set = ShutdownHookManager.MGR.hooks;
        synchronized (set) {
            list = new ArrayList<HookEntry>(ShutdownHookManager.MGR.hooks);
        }
        Collections.sort(list, new Comparator<HookEntry>(){

            @Override
            public int compare(HookEntry o1, HookEntry o2) {
                return o2.priority - o1.priority;
            }
        });
        ArrayList<Runnable> ordered = new ArrayList<Runnable>();
        for (HookEntry entry : list) {
            ordered.add(entry.hook);
        }
        return ordered;
    }

    public static void addShutdownHook(Runnable shutdownHook, int priority) {
        MGR.addShutdownHookInternal(shutdownHook, priority);
    }

    private void addShutdownHookInternal(Runnable shutdownHook, int priority) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority));
    }

    public static boolean removeShutdownHook(Runnable shutdownHook) {
        return MGR.removeShutdownHookInternal(shutdownHook);
    }

    private boolean removeShutdownHookInternal(Runnable shutdownHook) {
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot remove a shutdownHook");
        }
        return this.hooks.remove(new HookEntry(shutdownHook, 0));
    }

    public static boolean hasShutdownHook(Runnable shutdownHook) {
        return MGR.hasShutdownHookInternal(shutdownHook);
    }

    public boolean hasShutdownHookInternal(Runnable shutdownHook) {
        return this.hooks.contains(new HookEntry(shutdownHook, 0));
    }

    public static boolean isShutdownInProgress() {
        return MGR.isShutdownInProgressInternal();
    }

    private boolean isShutdownInProgressInternal() {
        return this.shutdownInProgress.get();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MGR.shutdownInProgress.set(true);
                MGR;
                for (Runnable hook : ShutdownHookManager.getShutdownHooksInOrder()) {
                    try {
                        hook.run();
                    }
                    catch (Throwable ex) {
                        LOG.warn("ShutdownHook '" + hook.getClass().getSimpleName() + "' failed, " + ex.toString(), ex);
                    }
                }
            }
        });
    }

    private static class HookEntry {
        Runnable hook;
        int priority;

        public HookEntry(Runnable hook, int priority) {
            this.hook = hook;
            this.priority = priority;
        }

        public int hashCode() {
            return this.hook.hashCode();
        }

        public boolean equals(Object obj) {
            boolean eq = false;
            if (obj != null && obj instanceof HookEntry) {
                eq = this.hook == ((HookEntry)obj).hook;
            }
            return eq;
        }
    }
}

