/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service;

import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.hive.conf.HiveConf;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.AbstractService;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.Service;

public final class ServiceOperations {
    private static final Log LOG = LogFactory.getLog(AbstractService.class);

    private ServiceOperations() {
    }

    public static void ensureCurrentState(Service.STATE state, Service.STATE expectedState) {
        if (state != expectedState) {
            throw new IllegalStateException("For this operation, the current service state must be " + (Object)((Object)expectedState) + " instead of " + (Object)((Object)state));
        }
    }

    public static void init(Service service, HiveConf configuration) {
        Service.STATE state = service.getServiceState();
        ServiceOperations.ensureCurrentState(state, Service.STATE.NOTINITED);
        service.init(configuration);
    }

    public static void start(Service service) {
        Service.STATE state = service.getServiceState();
        ServiceOperations.ensureCurrentState(state, Service.STATE.INITED);
        service.start();
    }

    public static void deploy(Service service, HiveConf configuration) {
        ServiceOperations.init(service, configuration);
        ServiceOperations.start(service);
    }

    public static void stop(Service service) {
        Service.STATE state;
        if (service != null && (state = service.getServiceState()) == Service.STATE.STARTED) {
            service.stop();
        }
    }

    public static Exception stopQuietly(Service service) {
        try {
            ServiceOperations.stop(service);
        }
        catch (Exception e) {
            LOG.warn("When stopping the service " + service.getName() + " : " + e, e);
            return e;
        }
        return null;
    }
}

