/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.auth;

import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.AuthenticationProviderFactory;
import java.io.IOException;
import java.security.Provider;
import java.util.ArrayDeque;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class PlainSaslServer
implements SaslServer {
    private final AuthenticationProviderFactory.AuthMethods authMethod;
    private String user;
    private String passwd;
    private String authzId;
    private final CallbackHandler handler;

    PlainSaslServer(CallbackHandler handler, String authMethodStr) throws SaslException {
        this.handler = handler;
        this.authMethod = AuthenticationProviderFactory.AuthMethods.getValidAuthMethod(authMethodStr);
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            ArrayDeque<String> tokenList = new ArrayDeque<String>();
            StringBuilder messageToken = new StringBuilder();
            for (byte b : response) {
                if (b == 0) {
                    tokenList.addLast(messageToken.toString());
                    messageToken = new StringBuilder();
                    continue;
                }
                messageToken.append((char)b);
            }
            tokenList.addLast(messageToken.toString());
            if (tokenList.size() < 2 || tokenList.size() > 3) {
                throw new SaslException("Invalid message format");
            }
            this.passwd = (String)tokenList.removeLast();
            this.user = (String)tokenList.removeLast();
            this.authzId = !tokenList.isEmpty() ? (String)tokenList.removeLast() : this.user;
            if (this.user == null || this.user.isEmpty()) {
                throw new SaslException("No user name provide");
            }
            if (this.passwd == null || this.passwd.isEmpty()) {
                throw new SaslException("No password name provide");
            }
            NameCallback nameCallback = new NameCallback("User");
            nameCallback.setName(this.user);
            PasswordCallback pcCallback = new PasswordCallback("Password", false);
            pcCallback.setPassword(this.passwd.toCharArray());
            AuthorizeCallback acCallback = new AuthorizeCallback(this.user, this.authzId);
            Callback[] cbList = new Callback[]{nameCallback, pcCallback, acCallback};
            this.handler.handle(cbList);
            if (!acCallback.isAuthorized()) {
                throw new SaslException("Authentication failed");
            }
        }
        catch (IllegalStateException eL) {
            throw new SaslException("Invalid message format", eL);
        }
        catch (IOException eI) {
            throw new SaslException("Error validating the login", eI);
        }
        catch (UnsupportedCallbackException eU) {
            throw new SaslException("Error validating the login", eU);
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.user != null;
    }

    @Override
    public String getAuthorizationID() {
        return this.user;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() {
    }

    public static class SaslPlainProvider
    extends Provider {
        public SaslPlainProvider() {
            super("HiveSaslPlain", 1.0, "Hive Plain SASL provider");
            this.put("SaslServerFactory.PLAIN", SaslPlainServerFactory.class.getName());
        }
    }

    public static class SaslPlainServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) {
            if ("PLAIN".equals(mechanism)) {
                try {
                    return new PlainSaslServer(cbh, protocol);
                }
                catch (SaslException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{"PLAIN"};
        }
    }
}

