/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.cli;

import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.HiveSQLException;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TOperationState;

public enum OperationState {
    INITIALIZED(TOperationState.INITIALIZED_STATE),
    RUNNING(TOperationState.RUNNING_STATE),
    FINISHED(TOperationState.FINISHED_STATE),
    CANCELED(TOperationState.CANCELED_STATE),
    CLOSED(TOperationState.CLOSED_STATE),
    ERROR(TOperationState.ERROR_STATE),
    UNKNOWN(TOperationState.UKNOWN_STATE),
    PENDING(TOperationState.PENDING_STATE);

    private final TOperationState tOperationState;

    private OperationState(TOperationState tOperationState) {
        this.tOperationState = tOperationState;
    }

    public static OperationState getOperationState(TOperationState tOperationState) {
        for (OperationState opState : OperationState.values()) {
            if (!tOperationState.equals(opState.tOperationState)) continue;
            return opState;
        }
        return UNKNOWN;
    }

    public static void validateTransition(OperationState oldState, OperationState newState) throws HiveSQLException {
        switch (oldState) {
            case INITIALIZED: {
                switch (newState) {
                    case PENDING: 
                    case RUNNING: 
                    case CANCELED: 
                    case CLOSED: {
                        return;
                    }
                }
                break;
            }
            case PENDING: {
                switch (newState) {
                    case RUNNING: 
                    case CANCELED: 
                    case CLOSED: 
                    case FINISHED: 
                    case ERROR: {
                        return;
                    }
                }
                break;
            }
            case RUNNING: {
                switch (newState) {
                    case CANCELED: 
                    case CLOSED: 
                    case FINISHED: 
                    case ERROR: {
                        return;
                    }
                }
                break;
            }
            case CANCELED: 
            case FINISHED: 
            case ERROR: {
                if (!CLOSED.equals((Object)newState)) break;
                return;
            }
        }
        throw new HiveSQLException("Illegal Operation state transition");
    }

    public void validateTransition(OperationState newState) throws HiveSQLException {
        OperationState.validateTransition(this, newState);
    }

    public TOperationState toTOperationState() {
        return this.tOperationState;
    }
}

