/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.cli;

import io.trino.hive.jdbc.;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.ColumnDescriptor;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.Type;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TColumnDesc;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TTableSchema;
import java.util.ArrayList;
import java.util.List;

public class TableSchema {
    private final List<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();

    public TableSchema() {
    }

    public TableSchema(int numColumns) {
    }

    public TableSchema(TTableSchema tTableSchema) {
        for (TColumnDesc tColumnDesc : tTableSchema.getColumns()) {
            this.columns.add(new ColumnDescriptor(tColumnDesc));
        }
    }

    public TableSchema(List<.FieldSchema> fieldSchemas) {
        int pos = 1;
        for (.FieldSchema field : fieldSchemas) {
            this.columns.add(new ColumnDescriptor(field, pos++));
        }
    }

    public TableSchema(.Schema schema) {
        this(schema.getFieldSchemas());
    }

    public List<ColumnDescriptor> getColumnDescriptors() {
        return new ArrayList<ColumnDescriptor>(this.columns);
    }

    public ColumnDescriptor getColumnDescriptorAt(int pos) {
        return this.columns.get(pos);
    }

    public int getSize() {
        return this.columns.size();
    }

    public void clear() {
        this.columns.clear();
    }

    public TTableSchema toTTableSchema() {
        TTableSchema tTableSchema = new TTableSchema();
        for (ColumnDescriptor col : this.columns) {
            tTableSchema.addToColumns(col.toTColumnDesc());
        }
        return tTableSchema;
    }

    public Type[] toTypes() {
        Type[] types = new Type[this.columns.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.columns.get(i).getType();
        }
        return types;
    }

    public TableSchema addPrimitiveColumn(String columnName, Type columnType, String columnComment) {
        this.columns.add(ColumnDescriptor.newPrimitiveColumnDescriptor(columnName, columnComment, columnType, this.columns.size() + 1));
        return this;
    }

    public TableSchema addStringColumn(String columnName, String columnComment) {
        this.columns.add(ColumnDescriptor.newPrimitiveColumnDescriptor(columnName, columnComment, Type.STRING_TYPE, this.columns.size() + 1));
        return this;
    }
}

