/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.thrift;

import io.trino.hive.jdbc.;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.trino.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.trino.hive.jdbc.$internal.org.apache.hadoop.security.UserGroupInformation;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.AuthenticationProviderFactory;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.HiveAuthFactory;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.HttpAuthenticationException;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.auth.PasswdAuthenticationProvider;
import io.trino.hive.jdbc.$internal.org.apache.hive.service.cli.session.SessionManager;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TProcessor;
import io.trino.hive.jdbc.$internal.org.apache.thrift.protocol.TProtocolFactory;
import io.trino.hive.jdbc.$internal.org.apache.thrift.server.TServlet;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ThriftHttpServlet
extends TServlet {
    private static final long serialVersionUID = 1L;
    public static final Log LOG = LogFactory.getLog(ThriftHttpServlet.class.getName());
    private final String authType;
    private final UserGroupInformation serviceUGI;
    private final UserGroupInformation httpUGI;

    public ThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory, String authType, UserGroupInformation serviceUGI, UserGroupInformation httpUGI) {
        super(processor, protocolFactory);
        this.authType = authType;
        this.serviceUGI = serviceUGI;
        this.httpUGI = httpUGI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String clientUserName;
            if (this.isKerberosAuthMode(this.authType)) {
                clientUserName = this.doKerberosAuth(request);
                String doAsQueryParam = ThriftHttpServlet.getDoAsQueryParam(request.getQueryString());
                if (doAsQueryParam != null) {
                    SessionManager.setProxyUserName(doAsQueryParam);
                }
            } else {
                clientUserName = this.doPasswdAuth(request, this.authType);
            }
            LOG.debug("Client username: " + clientUserName);
            SessionManager.setUserName(clientUserName);
            String clientIpAddress = request.getRemoteAddr();
            LOG.debug("Client IP Address: " + clientIpAddress);
            SessionManager.setIpAddress(clientIpAddress);
            super.doPost(request, response);
        }
        catch (HttpAuthenticationException e) {
            LOG.error("Error: ", e);
            response.setStatus(401);
            if (this.isKerberosAuthMode(this.authType)) {
                response.addHeader("WWW-Authenticate", "Negotiate");
            }
            response.getWriter().println("Authentication Error: " + e.getMessage());
        }
        finally {
            SessionManager.clearUserName();
            SessionManager.clearIpAddress();
            SessionManager.clearProxyUserName();
        }
    }

    private String doPasswdAuth(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String userName = this.getUsername(request, authType);
        if (!authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.NOSASL.toString())) {
            try {
                AuthenticationProviderFactory.AuthMethods authMethod = AuthenticationProviderFactory.AuthMethods.getValidAuthMethod(authType);
                PasswdAuthenticationProvider provider = AuthenticationProviderFactory.getAuthenticationProvider(authMethod);
                provider.Authenticate(userName, this.getPassword(request, authType));
            }
            catch (Exception e) {
                throw new HttpAuthenticationException(e);
            }
        }
        return userName;
    }

    private String doKerberosAuth(HttpServletRequest request) throws HttpAuthenticationException {
        if (this.httpUGI != null) {
            try {
                return (String)this.httpUGI.doAs(new HttpKerberosServerAction(request, this.httpUGI));
            }
            catch (Exception e) {
                LOG.info("Failed to authenticate with http/_HOST kerberos principal, trying with hive/_HOST kerberos principal");
            }
        }
        try {
            return (String)this.serviceUGI.doAs(new HttpKerberosServerAction(request, this.serviceUGI));
        }
        catch (Exception e) {
            LOG.error("Failed to authenticate with hive/_HOST kerberos principal");
            throw new HttpAuthenticationException(e);
        }
    }

    private String getUsername(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String[] creds = this.getAuthHeaderTokens(request, authType);
        if (creds[0] == null || creds[0].isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain username.");
        }
        return creds[0];
    }

    private String getPassword(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String[] creds = this.getAuthHeaderTokens(request, authType);
        if (creds[1] == null || creds[1].isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain username.");
        }
        return creds[1];
    }

    private String[] getAuthHeaderTokens(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String authHeaderBase64 = this.getAuthHeader(request, authType);
        String authHeaderString = .StringUtils.newStringUtf8((byte[]).Base64.decodeBase64((byte[])authHeaderBase64.getBytes()));
        String[] creds = authHeaderString.split(":");
        return creds;
    }

    private String getAuthHeader(HttpServletRequest request, String authType) throws HttpAuthenticationException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client is empty.");
        }
        int beginIndex = this.isKerberosAuthMode(authType) ? "Negotiate ".length() : "Basic ".length();
        String authHeaderBase64String = authHeader.substring(beginIndex);
        if (authHeaderBase64String == null || authHeaderBase64String.isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain any data.");
        }
        return authHeaderBase64String;
    }

    private boolean isKerberosAuthMode(String authType) {
        return authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.KERBEROS.toString());
    }

    private static String getDoAsQueryParam(String queryString) {
        if (queryString == null) {
            return null;
        }
        Hashtable params = HttpUtils.parseQueryString((String)queryString);
        Set keySet = params.keySet();
        for (String key : keySet) {
            if (!key.equalsIgnoreCase("doAs")) continue;
            return ((String[])params.get(key))[0];
        }
        return null;
    }

    class HttpKerberosServerAction
    implements PrivilegedExceptionAction<String> {
        HttpServletRequest request;
        UserGroupInformation serviceUGI;

        HttpKerberosServerAction(HttpServletRequest request, UserGroupInformation serviceUGI) {
            this.request = request;
            this.serviceUGI = serviceUGI;
        }

        @Override
        public String run() throws HttpAuthenticationException {
            GSSManager manager = GSSManager.getInstance();
            GSSContext gssContext = null;
            String serverPrincipal = this.getPrincipalWithoutRealm(this.serviceUGI.getUserName());
            try {
                Oid kerberosMechOid = new Oid("1.2.840.113554.1.2.2");
                Oid spnegoMechOid = new Oid("1.3.6.1.5.5.2");
                Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
                GSSName serverName = manager.createName(serverPrincipal, krb5PrincipalOid);
                GSSCredential serverCreds = manager.createCredential(serverName, 0, new Oid[]{kerberosMechOid, spnegoMechOid}, 2);
                gssContext = manager.createContext(serverCreds);
                String serviceTicketBase64 = ThriftHttpServlet.this.getAuthHeader(this.request, ThriftHttpServlet.this.authType);
                byte[] inToken = .Base64.decodeBase64((byte[])serviceTicketBase64.getBytes());
                gssContext.acceptSecContext(inToken, 0, inToken.length);
                if (!gssContext.isEstablished()) {
                    throw new HttpAuthenticationException("Kerberos authentication failed: unable to establish context with the service ticket provided by the client.");
                }
                String string = this.getPrincipalWithoutRealm(((Object)gssContext.getSrcName()).toString());
                return string;
            }
            catch (GSSException e) {
                throw new HttpAuthenticationException("Kerberos authentication failed: ", e);
            }
            finally {
                if (gssContext != null) {
                    try {
                        gssContext.dispose();
                    }
                    catch (GSSException e) {}
                }
            }
        }

        private String getPrincipalWithoutRealm(String fullPrincipal) {
            String[] names = fullPrincipal.split("[@]");
            return names[0];
        }
    }
}

