/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.thrift;

public class ShortStack {
    private short[] vector;
    private int top = -1;

    public ShortStack(int initialCapacity) {
        this.vector = new short[initialCapacity];
    }

    public short pop() {
        return this.vector[this.top--];
    }

    public void push(short pushed) {
        if (this.vector.length == this.top + 1) {
            this.grow();
        }
        this.vector[++this.top] = pushed;
    }

    private void grow() {
        short[] newVector = new short[this.vector.length * 2];
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        this.vector = newVector;
    }

    public short peek() {
        return this.vector[this.top];
    }

    public void clear() {
        this.top = -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<ShortStack vector:[");
        for (int i = 0; i < this.vector.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            if (i == this.top) {
                sb.append(">>");
            }
            sb.append(this.vector[i]);
            if (i != this.top) continue;
            sb.append("<<");
        }
        sb.append("]>");
        return sb.toString();
    }
}

