/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.jdbc.$internal.org.apache.thrift;

import io.trino.hive.jdbc.;
import io.trino.hive.jdbc.$internal.org.apache.thrift.ProcessFunction;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TApplicationException;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TException;
import io.trino.hive.jdbc.$internal.org.apache.thrift.TProcessor;
import io.trino.hive.jdbc.$internal.org.apache.thrift.protocol.TMessage;
import io.trino.hive.jdbc.$internal.org.apache.thrift.protocol.TProtocol;
import io.trino.hive.jdbc.$internal.org.apache.thrift.protocol.TProtocolUtil;
import java.util.Collections;
import java.util.Map;

public abstract class TBaseProcessor<I>
implements TProcessor {
    private final I iface;
    private final Map<String, ProcessFunction<I, ? extends .TBase>> processMap;

    protected TBaseProcessor(I iface, Map<String, ProcessFunction<I, ? extends .TBase>> processFunctionMap) {
        this.iface = iface;
        this.processMap = processFunctionMap;
    }

    public Map<String, ProcessFunction<I, ? extends .TBase>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public boolean process(TProtocol in, TProtocol out) throws TException {
        TMessage msg = in.readMessageBegin();
        ProcessFunction<I, .TBase> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            return true;
        }
        fn.process(msg.seqid, in, out, this.iface);
        return true;
    }
}

