/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import javax.management.NotificationEmitter;

public class HeapMemoryMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(HeapMemoryMonitor.class.getName());
    private static final double DEFAULT_THRESHOLD = 0.7;
    private static final MemoryPoolMXBean tenuredGenPool = HeapMemoryMonitor.getTenuredGenPool();
    private final double threshold;
    private List<Listener> listeners = new ArrayList<Listener>();

    public HeapMemoryMonitor(double threshold) {
        this.threshold = threshold <= 0.0 || threshold > 1.0 ? 0.7 : threshold;
        this.setupTenuredGenPoolThreshold(tenuredGenPool);
    }

    private void setupTenuredGenPoolThreshold(MemoryPoolMXBean tenuredGenPool) {
        if (tenuredGenPool == null) {
            return;
        }
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            long memoryThreshold = (int)Math.floor((double)pool.getUsage().getMax() * this.threshold);
            boolean isTenured = HeapMemoryMonitor.isTenured(pool);
            if (!isTenured) continue;
            boolean isCollectionUsageThresholdSupported = pool.isCollectionUsageThresholdSupported();
            if (isCollectionUsageThresholdSupported) {
                LOG.info("Setting collection usage threshold to {}", (Object)memoryThreshold);
                pool.setCollectionUsageThreshold(memoryThreshold);
                return;
            }
            boolean isUsageThresholdSupported = pool.isUsageThresholdSupported();
            if (!isUsageThresholdSupported) continue;
            LOG.info("Setting usage threshold to {}", (Object)memoryThreshold);
            pool.setUsageThreshold(memoryThreshold);
            return;
        }
    }

    private static MemoryPoolMXBean getTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            String vendor = System.getProperty("java.vendor");
            boolean isTenured = HeapMemoryMonitor.isTenured(pool);
            if (!isTenured) continue;
            boolean isCollectionUsageThresholdSupported = pool.isCollectionUsageThresholdSupported();
            if (isCollectionUsageThresholdSupported) {
                return pool;
            }
            boolean isUsageThresholdSupported = pool.isUsageThresholdSupported();
            if (isUsageThresholdSupported) {
                return pool;
            }
            LOG.error("{} vendor does not support isCollectionUsageThresholdSupported() and isUsageThresholdSupported() for tenured memory pool '{}'.", (Object)vendor, (Object)pool.getName());
        }
        return null;
    }

    private static boolean isTenured(MemoryPoolMXBean memoryPoolMXBean) {
        if (memoryPoolMXBean.getType() != MemoryType.HEAP) {
            return false;
        }
        String name = memoryPoolMXBean.getName();
        return name.equals("CMS Old Gen") || name.equals("PS Old Gen") || name.equals("G1 Old Gen") || name.equals("Old Space") || name.equals("Tenured Gen") || name.equals("Java heap") || name.equals("GenPauseless Old Gen");
    }

    public void registerListener(Listener listener) {
        this.listeners.add(listener);
    }

    public MemoryUsage getTenuredGenMemoryUsage() {
        if (tenuredGenPool == null) {
            return null;
        }
        return tenuredGenPool.getUsage();
    }

    public void start() {
        if (tenuredGenPool == null) {
            return;
        }
        MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mxBean);
        emitter.addNotificationListener((n, hb) -> {
            if (n.getType().equals("java.management.memory.collection.threshold.exceeded")) {
                long maxMemory = tenuredGenPool.getUsage().getMax();
                long usedMemory = tenuredGenPool.getUsage().getUsed();
                for (Listener listener : this.listeners) {
                    listener.memoryUsageAboveThreshold(usedMemory, maxMemory);
                }
            }
        }, null, null);
    }

    public static interface Listener {
        public void memoryUsageAboveThreshold(long var1, long var3);
    }
}

