/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.HashTableDummyDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;

public class HashTableDummyOperator
extends Operator<HashTableDummyDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected HashTableDummyOperator() {
    }

    public HashTableDummyOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        TableDesc tbl = ((HashTableDummyDesc)this.getConf()).getTbl();
        try {
            Deserializer serde = tbl.getDeserializerClass().newInstance();
            SerDeUtils.initializeSerDe(serde, hconf, tbl.getProperties(), null);
            this.outputObjInspector = serde.getObjectInspector();
        }
        catch (Exception e) {
            this.LOG.error("Generating output obj inspector from dummy object error", e);
            e.printStackTrace();
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        throw new HiveException();
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
    }

    @Override
    public String getName() {
        return HashTableDummyOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "HASHTABLEDUMMY";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.HASHTABLEDUMMY;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || obj instanceof HashTableDummyOperator && ((HashTableDummyOperator)obj).operatorId.equals(this.operatorId);
    }

    public int hashCode() {
        return this.operatorId.hashCode();
    }
}

