/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;

public class AbortTxnHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        if (!AcidUtils.isAcidEnabled(context.hiveConf)) {
            context.log.error("Cannot load transaction events as acid is not enabled");
            throw new SemanticException("Cannot load transaction events as acid is not enabled");
        }
        AbortTxnMessage msg = this.deserializer.getAbortTxnMessage(context.dmd.getPayload());
        Task<ReplTxnWork> abortTxnTask = TaskFactory.get(new ReplTxnWork(HiveUtils.getReplPolicy(context.dbName, context.tableName), context.dbName, context.tableName, msg.getTxnId(), ReplTxnWork.OperationType.REPL_ABORT_TXN, context.eventOnlyReplicationSpec()), context.hiveConf);
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), context.dbName, context.tableName, null);
        context.log.debug("Added Abort txn task : {}", (Object)abortTxnTask.getId());
        return Collections.singletonList(abortTxnTask);
    }
}

