/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFRank;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@WindowFunctionDescription(description=@Description(name="percent_rank", value="_FUNC_(x) PERCENT_RANK is similar to CUME_DIST, but it uses rank values rather than row counts in its numerator. PERCENT_RANK of a row is calculated as: (rank of row in its partition - 1) / (number of rows in the partition - 1)"), supportsWindow=false, pivotResult=true, rankingFunction=true, impliesOrder=true)
public class GenericUDAFPercentRank
extends GenericUDAFRank {
    static final Logger LOG = LoggerFactory.getLogger(GenericUDAFPercentRank.class.getName());

    @Override
    protected GenericUDAFRank.GenericUDAFAbstractRankEvaluator createEvaluator() {
        return new GenericUDAFPercentRankEvaluator();
    }

    public static class GenericUDAFPercentRankEvaluator
    extends GenericUDAFRank.GenericUDAFAbstractRankEvaluator {
        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ArrayList<IntWritable> ranks = ((GenericUDAFRank.RankBuffer)agg).rowNums;
            double sz = ranks.size();
            if (sz > 1.0) {
                sz -= 1.0;
            }
            ArrayList<DoubleWritable> pranks = new ArrayList<DoubleWritable>(ranks.size());
            for (IntWritable i : ranks) {
                double pr = ((double)i.get() - 1.0) / sz;
                pranks.add(new DoubleWritable(pr));
            }
            return pranks;
        }
    }
}

