/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import io.trino.hive.$internal.com.google.common.cache.Cache;
import io.trino.hive.$internal.com.google.common.cache.CacheBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;

public class ReflectionUtil {
    private static final Cache<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE;
    private static final Class<?>[] EMPTY_ARRAY;
    private static final Class<?> jobConfClass;
    private static final Class<?> jobConfigurableClass;
    private static final Method configureMethod;

    public static <T> T newInstance(Class<T> theClass, Configuration conf) {
        Object result;
        try {
            Constructor<Object> ctor = CONSTRUCTOR_CACHE.getIfPresent(theClass);
            if (ctor == null) {
                ctor = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                ctor.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, ctor);
            }
            result = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtil.setConf(result, conf);
        return (T)result;
    }

    public static void setConf(Object theObject, Configuration conf) {
        if (conf != null) {
            if (theObject instanceof Configurable) {
                ((Configurable)theObject).setConf(conf);
            }
            ReflectionUtil.setJobConf(theObject, conf);
        }
    }

    private static void setJobConf(Object theObject, Configuration conf) {
        if (configureMethod == null) {
            return;
        }
        try {
            if (jobConfClass.isAssignableFrom(conf.getClass()) && jobConfigurableClass.isAssignableFrom(theObject.getClass())) {
                configureMethod.invoke(theObject, conf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error in configuring object", e);
        }
    }

    static {
        Method configureMethodLocal;
        Class<?> jobConfigurableClassLocal;
        Class<?> jobConfClassLocal;
        CONSTRUCTOR_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).concurrencyLevel(64).weakKeys().weakValues().build();
        EMPTY_ARRAY = new Class[0];
        try {
            jobConfClassLocal = Class.forName("org.apache.hadoop.mapred.JobConf");
            jobConfigurableClassLocal = Class.forName("org.apache.hadoop.mapred.JobConfigurable");
            configureMethodLocal = jobConfigurableClassLocal.getMethod("configure", jobConfClassLocal);
        }
        catch (Throwable t) {
            jobConfigurableClassLocal = null;
            jobConfClassLocal = null;
            configureMethodLocal = null;
        }
        jobConfClass = jobConfClassLocal;
        jobConfigurableClass = jobConfigurableClassLocal;
        configureMethod = configureMethodLocal;
    }
}

