package io.trino.hive.$internal.org.codehaus.jackson.map.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;

import io.trino.hive.$internal.org.codehaus.jackson.JsonGenerationException;
import io.trino.hive.$internal.org.codehaus.jackson.JsonGenerator;
import io.trino.hive.$internal.org.codehaus.jackson.JsonNode;
import io.trino.hive.$internal.org.codehaus.jackson.map.*;
import io.trino.hive.$internal.org.codehaus.jackson.map.ser.std.SerializerBase;

public class UnknownSerializer
    extends SerializerBase<Object>
{
    public UnknownSerializer() {
        super(Object.class);
    }
    
    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonMappingException
    {
        // 27-Nov-2009, tatu: As per [JACKSON-201] may or may not fail...
        if (provider.isEnabled(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS)) {
            failForEmpty(value);
        }
        // But if it's fine, we'll just output empty JSON Object:
        jgen.writeStartObject();
        jgen.writeEndObject();
    }

    // since 1.6.2; needed to retain type information
    @Override
    public final void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider,
            TypeSerializer typeSer)
        throws IOException, JsonGenerationException
    {
        if (provider.isEnabled(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS)) {
            failForEmpty(value);
        }
        typeSer.writeTypePrefixForObject(value, jgen);
        typeSer.writeTypeSuffixForObject(value, jgen);
    }
    
    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    protected void failForEmpty(Object value) throws JsonMappingException
    {
        throw new JsonMappingException("No serializer found for class "+value.getClass().getName()+" and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS) )");
    }
}
