/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import io.trino.hive.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.Reader;
import org.apache.orc.impl.AcidStats;
import org.apache.orc.impl.OrcAcidUtils;

public class VectorizedOrcAcidRowBatchReader
implements org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> {
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedOrcAcidRowBatchReader.class);
    private org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> baseReader;
    private final VectorizedRowBatchCtx rbCtx;
    private VectorizedRowBatch vectorizedRowBatchBase;
    private long offset;
    private long length;
    protected float progress = 0.0f;
    protected Object[] partitionValues;
    private boolean addPartitionCols = true;
    private final boolean isFlatPayload;
    private final ValidWriteIdList validWriteIdList;
    private final DeleteEventRegistry deleteEventRegistry;
    private final StructColumnVector recordIdColumnVector;
    private final Reader.Options readerOptions;
    private final boolean isOriginal;
    private final boolean rowIdProjected;
    private final Path rootPath;
    private final OffsetAndBucketProperty syntheticProps;
    private RecordReader innerReader;

    VectorizedOrcAcidRowBatchReader(OrcSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        this(inputSplit, conf, reporter, null);
    }

    @VisibleForTesting
    VectorizedOrcAcidRowBatchReader(OrcSplit inputSplit, JobConf conf, Reporter reporter, final VectorizedRowBatchCtx rbCtx) throws IOException {
        this(conf, inputSplit, reporter, rbCtx == null ? Utilities.getVectorizedRowBatchCtx((Configuration)conf) : rbCtx, false);
        Reader reader = OrcInputFormat.createOrcReaderForSplit((Configuration)conf, inputSplit);
        this.innerReader = reader.rowsOptions(this.readerOptions.range(this.offset, this.length), (Configuration)conf);
        this.baseReader = new org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch>(){

            public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
                return VectorizedOrcAcidRowBatchReader.this.innerReader.nextBatch(value);
            }

            public NullWritable createKey() {
                return NullWritable.get();
            }

            public VectorizedRowBatch createValue() {
                return rbCtx.createVectorizedRowBatch();
            }

            public long getPos() throws IOException {
                return 0L;
            }

            public void close() throws IOException {
                VectorizedOrcAcidRowBatchReader.this.innerReader.close();
            }

            public float getProgress() throws IOException {
                return VectorizedOrcAcidRowBatchReader.this.innerReader.getProgress();
            }
        };
        boolean useDecimal64ColumnVectors = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
        this.vectorizedRowBatchBase = useDecimal64ColumnVectors ? ((RecordReaderImpl)this.innerReader).createRowBatch(true) : ((RecordReaderImpl)this.innerReader).createRowBatch(false);
    }

    public VectorizedOrcAcidRowBatchReader(OrcSplit inputSplit, JobConf conf, Reporter reporter, org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> baseReader, VectorizedRowBatchCtx rbCtx, boolean isFlatPayload) throws IOException {
        this(conf, inputSplit, reporter, rbCtx, isFlatPayload);
        if (baseReader != null) {
            this.setBaseAndInnerReader(baseReader);
        }
    }

    private VectorizedOrcAcidRowBatchReader(JobConf conf, OrcSplit orcSplit, Reporter reporter, VectorizedRowBatchCtx rowBatchCtx, boolean isFlatPayload) throws IOException {
        DeleteEventRegistry der;
        int partitionColumnCount;
        boolean isReadNotAllowed;
        this.isFlatPayload = isFlatPayload;
        this.rbCtx = rowBatchCtx;
        boolean isAcidRead = AcidUtils.isFullAcidScan((Configuration)conf);
        AcidUtils.AcidOperationalProperties acidOperationalProperties = AcidUtils.getAcidOperationalProperties((Configuration)conf);
        boolean bl = isReadNotAllowed = !isAcidRead || !acidOperationalProperties.isSplitUpdate();
        if (isReadNotAllowed) {
            OrcInputFormat.raiseAcidTablesMustBeReadWithAcidReaderException((Configuration)conf);
        }
        reporter.setStatus(orcSplit.toString());
        this.readerOptions = OrcInputFormat.createOptionsForReader((Configuration)conf);
        this.offset = orcSplit.getStart();
        this.length = orcSplit.getLength();
        int n = partitionColumnCount = this.rbCtx != null ? this.rbCtx.getPartitionColumnCount() : 0;
        if (partitionColumnCount > 0) {
            this.partitionValues = new Object[partitionColumnCount];
            VectorizedRowBatchCtx.getPartitionValues(this.rbCtx, (Configuration)conf, (FileSplit)orcSplit, this.partitionValues);
        } else {
            this.partitionValues = null;
        }
        String txnString = conf.get("hive.txn.valid.writeids");
        this.validWriteIdList = txnString == null ? new ValidReaderWriteIdList() : new ValidReaderWriteIdList(txnString);
        LOG.debug("VectorizedOrcAcidRowBatchReader:: Read ValidWriteIdList: " + this.validWriteIdList.toString() + " isFullAcidTable: " + AcidUtils.isFullAcidScan((Configuration)conf));
        Reader.Options deleteEventReaderOptions = this.readerOptions.clone();
        deleteEventReaderOptions.range(0L, Long.MAX_VALUE);
        deleteEventReaderOptions.searchArgument(null, null);
        try {
            der = new ColumnizedDeleteEventRegistry(conf, orcSplit, deleteEventReaderOptions);
        }
        catch (DeleteEventsOverflowMemoryException e) {
            der = new SortMergedDeleteEventRegistry(conf, orcSplit, deleteEventReaderOptions);
        }
        this.deleteEventRegistry = der;
        this.isOriginal = orcSplit.isOriginal();
        this.recordIdColumnVector = this.isOriginal ? new StructColumnVector(1024, new LongColumnVector(), new LongColumnVector(), new LongColumnVector()) : new StructColumnVector(1024, null, null, null);
        this.rowIdProjected = VectorizedOrcAcidRowBatchReader.areRowIdsProjected(this.rbCtx);
        this.rootPath = orcSplit.getRootDir();
        this.syntheticProps = this.computeOffsetAndBucket(orcSplit, conf, this.validWriteIdList);
    }

    public void setBaseAndInnerReader(org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> baseReader) {
        this.baseReader = baseReader;
        this.innerReader = null;
        this.vectorizedRowBatchBase = (VectorizedRowBatch)baseReader.createValue();
    }

    private OffsetAndBucketProperty computeOffsetAndBucket(OrcSplit split, JobConf conf, ValidWriteIdList validWriteIdList) throws IOException {
        if (!VectorizedOrcAcidRowBatchReader.needSyntheticRowIds(split.isOriginal(), !this.deleteEventRegistry.isEmpty(), this.rowIdProjected)) {
            if (split.isOriginal()) {
                OrcRawRecordMerger.TransactionMetaData syntheticTxnInfo = OrcRawRecordMerger.TransactionMetaData.findWriteIDForSynthetcRowIDs(split.getPath(), split.getRootDir(), (Configuration)conf);
                return new OffsetAndBucketProperty(-1L, -1, syntheticTxnInfo.syntheticWriteId);
            }
            return null;
        }
        long rowIdOffset = 0L;
        OrcRawRecordMerger.TransactionMetaData syntheticTxnInfo = OrcRawRecordMerger.TransactionMetaData.findWriteIDForSynthetcRowIDs(split.getPath(), split.getRootDir(), (Configuration)conf);
        int bucketId = AcidUtils.parseBucketId(split.getPath());
        int bucketProperty = BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)conf).statementId(syntheticTxnInfo.statementId).bucket(bucketId));
        AcidUtils.Directory directoryState = AcidUtils.getAcidState(syntheticTxnInfo.folder, (Configuration)conf, validWriteIdList, false, true);
        for (HadoopShims.HdfsFileStatusWithId f : directoryState.getOriginalFiles()) {
            int bucketIdFromPath = AcidUtils.parseBucketId(f.getFileStatus().getPath());
            if (bucketIdFromPath != bucketId) continue;
            if (f.getFileStatus().getPath().equals((Object)split.getPath())) break;
            Reader reader = OrcFile.createReader(f.getFileStatus().getPath(), OrcFile.readerOptions((Configuration)conf));
            rowIdOffset += reader.getNumberOfRows();
        }
        return new OffsetAndBucketProperty(rowIdOffset, bucketProperty, syntheticTxnInfo.syntheticWriteId);
    }

    static boolean canUseLlapForAcid(OrcSplit split, boolean hasDeletes, Configuration conf) {
        if (!split.isOriginal()) {
            return true;
        }
        VectorizedRowBatchCtx rbCtx = Utilities.getVectorizedRowBatchCtx(conf);
        if (rbCtx == null) {
            throw new IllegalStateException("Could not create VectorizedRowBatchCtx for " + split.getPath());
        }
        return !VectorizedOrcAcidRowBatchReader.needSyntheticRowIds(split.isOriginal(), hasDeletes, VectorizedOrcAcidRowBatchReader.areRowIdsProjected(rbCtx));
    }

    private static boolean needSyntheticRowIds(boolean isOriginal, boolean hasDeletes, boolean rowIdProjected) {
        return isOriginal && (hasDeletes || rowIdProjected);
    }

    private static boolean areRowIdsProjected(VectorizedRowBatchCtx rbCtx) {
        if (rbCtx.getVirtualColumnCount() == 0) {
            return false;
        }
        for (VirtualColumn vc : rbCtx.getNeededVirtualColumns()) {
            if (vc != VirtualColumn.ROWID) continue;
            return true;
        }
        return false;
    }

    static Path[] getDeleteDeltaDirsFromSplit(OrcSplit orcSplit) throws IOException {
        Path root;
        Path path = orcSplit.getPath();
        if (orcSplit.hasBase()) {
            if (orcSplit.isOriginal()) {
                root = orcSplit.getRootDir();
            } else {
                root = path.getParent().getParent();
                assert (root.equals((Object)orcSplit.getRootDir())) : "root mismatch: baseDir=" + orcSplit.getRootDir() + " path.p.p=" + root;
            }
        } else {
            throw new IllegalStateException("Split w/o base w/Acid 2.0??: " + path);
        }
        return AcidUtils.deserializeDeleteDeltas(root, orcSplit.getDeltas());
    }

    public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
        try {
            if (this.addPartitionCols) {
                if (this.partitionValues != null) {
                    this.rbCtx.addPartitionColsToBatch(value, this.partitionValues);
                }
                this.addPartitionCols = false;
            }
            if (!this.baseReader.next(null, (Object)this.vectorizedRowBatchBase)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new IOException("error iterating", e);
        }
        BitSet selectedBitSet = new BitSet(this.vectorizedRowBatchBase.size);
        if (this.vectorizedRowBatchBase.selectedInUse) {
            selectedBitSet.set(0, this.vectorizedRowBatchBase.size, false);
            for (int j = 0; j < this.vectorizedRowBatchBase.size; ++j) {
                int i = this.vectorizedRowBatchBase.selected[j];
                selectedBitSet.set(i);
            }
        } else {
            selectedBitSet.set(0, this.vectorizedRowBatchBase.size, true);
        }
        ColumnVector[] innerRecordIdColumnVector = this.vectorizedRowBatchBase.cols;
        if (this.isOriginal) {
            innerRecordIdColumnVector = this.handleOriginalFile(selectedBitSet, innerRecordIdColumnVector);
        } else {
            this.findRecordsWithInvalidWriteIds(this.vectorizedRowBatchBase, selectedBitSet);
        }
        this.deleteEventRegistry.findDeletedRecords(innerRecordIdColumnVector, this.vectorizedRowBatchBase.size, selectedBitSet);
        if (selectedBitSet.cardinality() == this.vectorizedRowBatchBase.size) {
            value.size = this.vectorizedRowBatchBase.size;
            value.selected = this.vectorizedRowBatchBase.selected;
            value.selectedInUse = this.vectorizedRowBatchBase.selectedInUse;
        } else {
            value.size = selectedBitSet.cardinality();
            value.selectedInUse = true;
            value.selected = new int[selectedBitSet.cardinality()];
            int setBitIndex = selectedBitSet.nextSetBit(0);
            int selectedItr = 0;
            while (setBitIndex >= 0) {
                value.selected[selectedItr] = setBitIndex;
                setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
                ++selectedItr;
            }
        }
        if (this.isOriginal) {
            System.arraycopy(this.vectorizedRowBatchBase.cols, 0, value.cols, 0, value.getDataColumnCount());
        } else {
            int payloadCol = 5;
            if (this.isFlatPayload) {
                System.arraycopy(this.vectorizedRowBatchBase.cols, payloadCol + 1, value.cols, 0, this.vectorizedRowBatchBase.cols.length - payloadCol - 1);
            } else {
                StructColumnVector payloadStruct = (StructColumnVector)this.vectorizedRowBatchBase.cols[payloadCol];
                System.arraycopy(payloadStruct.fields, 0, value.cols, 0, value.getDataColumnCount());
            }
            if (this.rowIdProjected) {
                this.recordIdColumnVector.fields[0] = this.vectorizedRowBatchBase.cols[1];
                this.recordIdColumnVector.fields[1] = this.vectorizedRowBatchBase.cols[2];
                this.recordIdColumnVector.fields[2] = this.vectorizedRowBatchBase.cols[3];
            }
        }
        if (this.rowIdProjected) {
            int ix = this.rbCtx.findVirtualColumnNum(VirtualColumn.ROWID);
            value.cols[ix] = this.recordIdColumnVector;
        }
        this.progress = this.baseReader.getProgress();
        return true;
    }

    private ColumnVector[] handleOriginalFile(BitSet selectedBitSet, ColumnVector[] innerRecordIdColumnVector) throws IOException {
        boolean needSyntheticRowId = VectorizedOrcAcidRowBatchReader.needSyntheticRowIds(true, !this.deleteEventRegistry.isEmpty(), this.rowIdProjected);
        if (needSyntheticRowId) {
            assert (this.syntheticProps != null && this.syntheticProps.rowIdOffset >= 0L) : "" + this.syntheticProps;
            assert (this.syntheticProps != null && this.syntheticProps.bucketProperty >= 0) : "" + this.syntheticProps;
            if (this.innerReader == null) {
                throw new IllegalStateException(this.getClass().getName() + " requires " + org.apache.orc.RecordReader.class + " to handle original files that require ROW__IDs: " + this.rootPath);
            }
            this.recordIdColumnVector.fields[0].noNulls = true;
            this.recordIdColumnVector.fields[0].isRepeating = true;
            ((LongColumnVector)this.recordIdColumnVector.fields[0]).vector[0] = this.syntheticProps.syntheticWriteId;
            this.recordIdColumnVector.fields[1].noNulls = true;
            this.recordIdColumnVector.fields[1].isRepeating = true;
            ((LongColumnVector)this.recordIdColumnVector.fields[1]).vector[0] = this.syntheticProps.bucketProperty;
            this.recordIdColumnVector.fields[2].noNulls = true;
            this.recordIdColumnVector.fields[2].isRepeating = false;
            long[] rowIdVector = ((LongColumnVector)this.recordIdColumnVector.fields[2]).vector;
            for (int i = 0; i < this.vectorizedRowBatchBase.size; ++i) {
                rowIdVector[i] = this.syntheticProps.rowIdOffset + this.innerReader.getRowNumber() + (long)i;
            }
            innerRecordIdColumnVector = new ColumnVector[6];
            innerRecordIdColumnVector[1] = this.recordIdColumnVector.fields[0];
            innerRecordIdColumnVector[2] = this.recordIdColumnVector.fields[1];
            innerRecordIdColumnVector[3] = this.recordIdColumnVector.fields[2];
            innerRecordIdColumnVector[4] = this.recordIdColumnVector.fields[0];
        }
        if (this.syntheticProps.syntheticWriteId > 0L) {
            if (needSyntheticRowId) {
                this.findRecordsWithInvalidWriteIds(innerRecordIdColumnVector, this.vectorizedRowBatchBase.size, selectedBitSet);
            } else if (!this.validWriteIdList.isWriteIdValid(this.syntheticProps.syntheticWriteId)) {
                selectedBitSet.clear(0, this.vectorizedRowBatchBase.size);
            }
        }
        return innerRecordIdColumnVector;
    }

    private void findRecordsWithInvalidWriteIds(VectorizedRowBatch batch, BitSet selectedBitSet) {
        this.findRecordsWithInvalidWriteIds(batch.cols, batch.size, selectedBitSet);
    }

    private void findRecordsWithInvalidWriteIds(ColumnVector[] cols, int size, BitSet selectedBitSet) {
        if (cols[4].isRepeating) {
            long currentWriteIdForBatch = ((LongColumnVector)cols[4]).vector[0];
            if (!this.validWriteIdList.isWriteIdValid(currentWriteIdForBatch)) {
                selectedBitSet.clear(0, size);
            }
            return;
        }
        long[] currentWriteIdVector = ((LongColumnVector)cols[4]).vector;
        int setBitIndex = selectedBitSet.nextSetBit(0);
        while (setBitIndex >= 0) {
            if (!this.validWriteIdList.isWriteIdValid(currentWriteIdVector[setBitIndex])) {
                selectedBitSet.clear(setBitIndex);
            }
            setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
        }
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        return this.rbCtx.createVectorizedRowBatch();
    }

    public long getPos() throws IOException {
        return this.offset + (long)(this.progress * (float)this.length);
    }

    public void close() throws IOException {
        try {
            this.baseReader.close();
        }
        finally {
            this.deleteEventRegistry.close();
        }
    }

    public float getProgress() throws IOException {
        return this.progress;
    }

    @VisibleForTesting
    DeleteEventRegistry getDeleteEventRegistry() {
        return this.deleteEventRegistry;
    }

    static class DeleteEventsOverflowMemoryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        DeleteEventsOverflowMemoryException() {
        }
    }

    static class ColumnizedDeleteEventRegistry
    implements DeleteEventRegistry {
        private TreeMap<DeleteRecordKey, DeleteReaderValue> sortMerger;
        private long[] rowIds;
        private CompressedOwid[] compressedOwids;
        private ValidWriteIdList validWriteIdList;
        private Boolean isEmpty = null;

        ColumnizedDeleteEventRegistry(JobConf conf, OrcSplit orcSplit, Reader.Options readerOptions) throws IOException, DeleteEventsOverflowMemoryException {
            int bucket = AcidUtils.parseBucketId(orcSplit.getPath());
            String txnString = conf.get("hive.txn.valid.writeids");
            this.validWriteIdList = txnString == null ? new ValidReaderWriteIdList() : new ValidReaderWriteIdList(txnString);
            LOG.debug("ColumnizedDeleteEventRegistry:: Read ValidWriteIdList: " + this.validWriteIdList.toString() + " isFullAcidTable: " + AcidUtils.isFullAcidScan((Configuration)conf));
            this.sortMerger = new TreeMap();
            this.rowIds = null;
            this.compressedOwids = null;
            int maxEventsInMemory = HiveConf.getIntVar((Configuration)conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY);
            boolean isBucketedTable = conf.getInt("bucket_count", 0) > 0;
            try {
                Path[] deleteDeltaDirs = VectorizedOrcAcidRowBatchReader.getDeleteDeltaDirsFromSplit(orcSplit);
                if (deleteDeltaDirs.length > 0) {
                    int totalDeleteEventCount = 0;
                    for (Path deleteDeltaDir : deleteDeltaDirs) {
                        Path[] deleteDeltaFiles;
                        FileSystem fs = deleteDeltaDir.getFileSystem((Configuration)conf);
                        for (Path deleteDeltaFile : deleteDeltaFiles = OrcRawRecordMerger.getDeltaFiles(deleteDeltaDir, bucket, (Configuration)conf, new OrcRawRecordMerger.Options().isCompacting(false), isBucketedTable)) {
                            long length = OrcAcidUtils.getLastFlushLength(fs, deleteDeltaFile);
                            if (length == -1L || !fs.exists(deleteDeltaFile)) continue;
                            Reader deleteDeltaReader = OrcFile.createReader(deleteDeltaFile, OrcFile.readerOptions((Configuration)conf).maxLength(length));
                            AcidStats acidStats = OrcAcidUtils.parseAcidStats(deleteDeltaReader);
                            if (acidStats.deletes == 0L) continue;
                            if ((totalDeleteEventCount = (int)((long)totalDeleteEventCount + acidStats.deletes)) > maxEventsInMemory) {
                                LOG.info("Total number of delete events exceeds the maximum number of delete events that can be loaded into memory for the delete deltas in the directory at : " + deleteDeltaDirs.toString() + ". The max limit is currently set at " + maxEventsInMemory + " and can be changed by setting the Hive config variable " + HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname);
                                throw new DeleteEventsOverflowMemoryException();
                            }
                            DeleteReaderValue deleteReaderValue = new DeleteReaderValue(deleteDeltaReader, readerOptions, bucket, this.validWriteIdList, isBucketedTable, conf);
                            DeleteRecordKey deleteRecordKey = new DeleteRecordKey();
                            if (deleteReaderValue.next(deleteRecordKey)) {
                                this.sortMerger.put(deleteRecordKey, deleteReaderValue);
                                continue;
                            }
                            deleteReaderValue.close();
                        }
                    }
                    if (totalDeleteEventCount > 0) {
                        this.readAllDeleteEventsFromDeleteDeltas(totalDeleteEventCount);
                    }
                }
                this.isEmpty = this.compressedOwids == null || this.rowIds == null;
            }
            catch (IOException | DeleteEventsOverflowMemoryException e) {
                this.close();
                throw e;
            }
        }

        private void readAllDeleteEventsFromDeleteDeltas(int totalDeleteEventCount) throws IOException {
            if (this.sortMerger == null || this.sortMerger.isEmpty()) {
                this.rowIds = new long[0];
                return;
            }
            this.rowIds = new long[totalDeleteEventCount];
            int index = 0;
            ArrayList<CompressedOwid> compressedOwids = new ArrayList<CompressedOwid>();
            CompressedOwid lastCo = null;
            while (!this.sortMerger.isEmpty()) {
                Map.Entry<DeleteRecordKey, DeleteReaderValue> entry = this.sortMerger.pollFirstEntry();
                DeleteRecordKey deleteRecordKey = entry.getKey();
                DeleteReaderValue deleteReaderValue = entry.getValue();
                long owid = deleteRecordKey.originalWriteId;
                int bp = deleteRecordKey.bucketProperty;
                this.rowIds[index] = deleteRecordKey.rowId;
                if (lastCo == null || lastCo.originalWriteId != owid || lastCo.bucketProperty != bp) {
                    if (lastCo != null) {
                        lastCo.toIndex = index;
                    }
                    lastCo = new CompressedOwid(owid, bp, index, -1);
                    compressedOwids.add(lastCo);
                }
                ++index;
                if (deleteReaderValue.next(deleteRecordKey)) {
                    this.sortMerger.put(deleteRecordKey, deleteReaderValue);
                    continue;
                }
                deleteReaderValue.close();
            }
            if (lastCo != null) {
                lastCo.toIndex = index;
                lastCo = null;
            }
            if (this.rowIds.length > index) {
                this.rowIds = Arrays.copyOf(this.rowIds, index);
            }
            this.compressedOwids = compressedOwids.toArray(new CompressedOwid[compressedOwids.size()]);
        }

        private boolean isDeleted(long owid, int bucketProperty, long rowId) {
            if (this.compressedOwids == null || this.rowIds == null) {
                return false;
            }
            if (owid < this.compressedOwids[0].originalWriteId || owid > this.compressedOwids[this.compressedOwids.length - 1].originalWriteId) {
                return false;
            }
            CompressedOwid key = new CompressedOwid(owid, bucketProperty, -1, -1);
            int pos = Arrays.binarySearch(this.compressedOwids, key);
            if (pos >= 0) {
                key = this.compressedOwids[pos];
                if (rowId < this.rowIds[key.fromIndex] || rowId > this.rowIds[key.toIndex - 1]) {
                    return false;
                }
                if (Arrays.binarySearch(this.rowIds, key.fromIndex, key.toIndex, rowId) >= 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            if (this.isEmpty == null) {
                throw new IllegalStateException("Not yet initialized");
            }
            return this.isEmpty;
        }

        @Override
        public void findDeletedRecords(ColumnVector[] cols, int size, BitSet selectedBitSet) throws IOException {
            if (this.rowIds == null || this.compressedOwids == null) {
                return;
            }
            long[] originalWriteIdVector = cols[1].isRepeating ? null : ((LongColumnVector)cols[1]).vector;
            long repeatedOriginalWriteId = originalWriteIdVector != null ? -1L : ((LongColumnVector)cols[1]).vector[0];
            long[] bucketProperties = cols[2].isRepeating ? null : ((LongColumnVector)cols[2]).vector;
            int repeatedBucketProperty = bucketProperties != null ? -1 : (int)((LongColumnVector)cols[2]).vector[0];
            long[] rowIdVector = ((LongColumnVector)cols[3]).vector;
            int setBitIndex = selectedBitSet.nextSetBit(0);
            while (setBitIndex >= 0) {
                long rowId;
                int bucketProperty;
                long owid = originalWriteIdVector != null ? originalWriteIdVector[setBitIndex] : repeatedOriginalWriteId;
                if (this.isDeleted(owid, bucketProperty = bucketProperties != null ? (int)bucketProperties[setBitIndex] : repeatedBucketProperty, rowId = rowIdVector[setBitIndex])) {
                    selectedBitSet.clear(setBitIndex);
                }
                setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
            }
        }

        @Override
        public void close() throws IOException {
            while (!this.sortMerger.isEmpty()) {
                Map.Entry<DeleteRecordKey, DeleteReaderValue> entry = this.sortMerger.pollFirstEntry();
                entry.getValue().close();
            }
        }

        private final class CompressedOwid
        implements Comparable<CompressedOwid> {
            final long originalWriteId;
            final int bucketProperty;
            final int fromIndex;
            int toIndex;

            CompressedOwid(long owid, int bucketProperty, int fromIndex, int toIndex) {
                this.originalWriteId = owid;
                this.bucketProperty = bucketProperty;
                this.fromIndex = fromIndex;
                this.toIndex = toIndex;
            }

            @Override
            public int compareTo(CompressedOwid other) {
                if (this.originalWriteId != other.originalWriteId) {
                    return this.originalWriteId < other.originalWriteId ? -1 : 1;
                }
                if (this.bucketProperty != other.bucketProperty) {
                    return this.bucketProperty < other.bucketProperty ? -1 : 1;
                }
                return 0;
            }
        }

        static class DeleteReaderValue {
            private VectorizedRowBatch batch;
            private final RecordReader recordReader;
            private int indexPtrInBatch;
            private final int bucketForSplit;
            private final ValidWriteIdList validWriteIdList;
            private boolean isBucketPropertyRepeating;
            private final boolean isBucketedTable;
            private final Reader reader;

            DeleteReaderValue(Reader deleteDeltaReader, Reader.Options readerOptions, int bucket, ValidWriteIdList validWriteIdList, boolean isBucketedTable, JobConf conf) throws IOException {
                this.reader = deleteDeltaReader;
                this.recordReader = deleteDeltaReader.rowsOptions(readerOptions, (Configuration)conf);
                this.bucketForSplit = bucket;
                boolean useDecimal64ColumnVector = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
                this.batch = useDecimal64ColumnVector ? deleteDeltaReader.getSchema().createRowBatchV2() : deleteDeltaReader.getSchema().createRowBatch();
                if (!this.recordReader.nextBatch(this.batch)) {
                    this.batch = null;
                }
                this.indexPtrInBatch = 0;
                this.validWriteIdList = validWriteIdList;
                this.isBucketedTable = isBucketedTable;
                this.checkBucketId();
            }

            public boolean next(DeleteRecordKey deleteRecordKey) throws IOException {
                if (this.batch == null) {
                    return false;
                }
                boolean isValidNext = false;
                while (!isValidNext) {
                    if (this.indexPtrInBatch >= this.batch.size) {
                        if (this.recordReader.nextBatch(this.batch)) {
                            this.checkBucketId();
                            this.indexPtrInBatch = 0;
                        } else {
                            return false;
                        }
                    }
                    long currentWriteId = this.setCurrentDeleteKey(deleteRecordKey);
                    if (!this.isBucketPropertyRepeating) {
                        this.checkBucketId(deleteRecordKey.bucketProperty);
                    }
                    ++this.indexPtrInBatch;
                    if (!this.validWriteIdList.isWriteIdValid(currentWriteId)) continue;
                    isValidNext = true;
                }
                return true;
            }

            public void close() throws IOException {
                this.recordReader.close();
            }

            private long setCurrentDeleteKey(DeleteRecordKey deleteRecordKey) {
                int originalWriteIdIndex = this.batch.cols[1].isRepeating ? 0 : this.indexPtrInBatch;
                long originalWriteId = ((LongColumnVector)this.batch.cols[1]).vector[originalWriteIdIndex];
                int bucketPropertyIndex = this.batch.cols[2].isRepeating ? 0 : this.indexPtrInBatch;
                int bucketProperty = (int)((LongColumnVector)this.batch.cols[2]).vector[bucketPropertyIndex];
                long rowId = ((LongColumnVector)this.batch.cols[3]).vector[this.indexPtrInBatch];
                int currentWriteIdIndex = this.batch.cols[4].isRepeating ? 0 : this.indexPtrInBatch;
                long currentWriteId = ((LongColumnVector)this.batch.cols[4]).vector[currentWriteIdIndex];
                deleteRecordKey.set(originalWriteId, bucketProperty, rowId);
                return currentWriteId;
            }

            private void checkBucketId() throws IOException {
                this.isBucketPropertyRepeating = this.batch.cols[2].isRepeating;
                if (this.isBucketPropertyRepeating) {
                    int bucketPropertyFromRecord = (int)((LongColumnVector)this.batch.cols[2]).vector[0];
                    this.checkBucketId(bucketPropertyFromRecord);
                }
            }

            private void checkBucketId(int bucketPropertyFromRecord) throws IOException {
                if (!this.isBucketedTable) {
                    return;
                }
                int bucketIdFromRecord = BucketCodec.determineVersion(bucketPropertyFromRecord).decodeWriterId(bucketPropertyFromRecord);
                if (bucketIdFromRecord != this.bucketForSplit) {
                    DeleteRecordKey dummy = new DeleteRecordKey();
                    long curTxnId = this.setCurrentDeleteKey(dummy);
                    throw new IOException("Corrupted records with different bucket ids from the containing bucket file found! Expected bucket id " + this.bucketForSplit + ", however found the bucket id " + bucketIdFromRecord + " from " + dummy + " curTxnId: " + curTxnId);
                }
            }

            public String toString() {
                return "{reader=" + this.reader + ", isBucketPropertyRepeating=" + this.isBucketPropertyRepeating + ", bucketForSplit=" + this.bucketForSplit + ", isBucketedTable=" + this.isBucketedTable + "}";
            }
        }

        static class DeleteRecordKey
        implements Comparable<DeleteRecordKey> {
            private long originalWriteId = -1L;
            private int bucketProperty;
            private long rowId = -1L;

            DeleteRecordKey() {
            }

            public void set(long owid, int bucketProperty, long rowId) {
                this.originalWriteId = owid;
                this.bucketProperty = bucketProperty;
                this.rowId = rowId;
            }

            @Override
            public int compareTo(DeleteRecordKey other) {
                if (other == null) {
                    return -1;
                }
                if (this.originalWriteId != other.originalWriteId) {
                    return this.originalWriteId < other.originalWriteId ? -1 : 1;
                }
                if (this.bucketProperty != other.bucketProperty) {
                    return this.bucketProperty < other.bucketProperty ? -1 : 1;
                }
                if (this.rowId != other.rowId) {
                    return this.rowId < other.rowId ? -1 : 1;
                }
                return 0;
            }

            public String toString() {
                return "owid: " + this.originalWriteId + " bucketP:" + this.bucketProperty + " rowid: " + this.rowId;
            }
        }
    }

    static class SortMergedDeleteEventRegistry
    implements DeleteEventRegistry {
        private OrcRawRecordMerger deleteRecords;
        private OrcRawRecordMerger.ReaderKey deleteRecordKey;
        private OrcStruct deleteRecordValue;
        private Boolean isDeleteRecordAvailable = null;
        private ValidWriteIdList validWriteIdList;

        SortMergedDeleteEventRegistry(JobConf conf, OrcSplit orcSplit, Reader.Options readerOptions) throws IOException {
            Path[] deleteDeltas = VectorizedOrcAcidRowBatchReader.getDeleteDeltaDirsFromSplit(orcSplit);
            if (deleteDeltas.length > 0) {
                int bucket = AcidUtils.parseBucketId(orcSplit.getPath());
                String txnString = conf.get("hive.txn.valid.writeids");
                this.validWriteIdList = txnString == null ? new ValidReaderWriteIdList() : new ValidReaderWriteIdList(txnString);
                LOG.debug("SortMergedDeleteEventRegistry:: Read ValidWriteIdList: " + this.validWriteIdList.toString() + " isFullAcidTable: " + AcidUtils.isFullAcidScan((Configuration)conf));
                OrcRawRecordMerger.Options mergerOptions = new OrcRawRecordMerger.Options().isDeleteReader(true);
                assert (!orcSplit.isOriginal()) : "If this now supports Original splits, set up mergeOptions properly";
                this.deleteRecords = new OrcRawRecordMerger((Configuration)conf, true, null, false, bucket, this.validWriteIdList, readerOptions, deleteDeltas, mergerOptions);
                this.deleteRecordKey = new OrcRawRecordMerger.ReaderKey();
                this.deleteRecordValue = this.deleteRecords.createValue();
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
            } else {
                this.isDeleteRecordAvailable = false;
                this.deleteRecordKey = null;
                this.deleteRecordValue = null;
                this.deleteRecords = null;
            }
        }

        @Override
        public boolean isEmpty() {
            if (this.isDeleteRecordAvailable == null) {
                throw new IllegalStateException("Not yet initialized");
            }
            return this.isDeleteRecordAvailable == false;
        }

        @Override
        public void findDeletedRecords(ColumnVector[] cols, int size, BitSet selectedBitSet) throws IOException {
            if (!this.isDeleteRecordAvailable.booleanValue()) {
                return;
            }
            long[] originalWriteId = cols[1].isRepeating ? null : ((LongColumnVector)cols[1]).vector;
            long[] bucket = cols[2].isRepeating ? null : ((LongColumnVector)cols[2]).vector;
            long[] rowId = cols[3].isRepeating ? null : ((LongColumnVector)cols[3]).vector;
            long repeatedOriginalWriteId = originalWriteId != null ? -1L : ((LongColumnVector)cols[1]).vector[0];
            long repeatedBucket = bucket != null ? -1L : ((LongColumnVector)cols[2]).vector[0];
            long repeatedRowId = rowId != null ? -1L : ((LongColumnVector)cols[3]).vector[0];
            int firstValidIndex = selectedBitSet.nextSetBit(0);
            if (firstValidIndex == -1) {
                return;
            }
            RecordIdentifier firstRecordIdInBatch = new RecordIdentifier(originalWriteId != null ? originalWriteId[firstValidIndex] : repeatedOriginalWriteId, bucket != null ? (int)bucket[firstValidIndex] : (int)repeatedBucket, rowId != null ? (long)((int)rowId[firstValidIndex]) : repeatedRowId);
            int lastValidIndex = selectedBitSet.previousSetBit(size - 1);
            RecordIdentifier lastRecordIdInBatch = new RecordIdentifier(originalWriteId != null ? originalWriteId[lastValidIndex] : repeatedOriginalWriteId, bucket != null ? (int)bucket[lastValidIndex] : (int)repeatedBucket, rowId != null ? (long)((int)rowId[lastValidIndex]) : repeatedRowId);
            while (this.deleteRecordKey.compareRow(firstRecordIdInBatch) == -1) {
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
                if (this.isDeleteRecordAvailable.booleanValue()) continue;
                return;
            }
            int currIndex = firstValidIndex;
            RecordIdentifier currRecordIdInBatch = new RecordIdentifier();
            while (this.isDeleteRecordAvailable.booleanValue() && currIndex != -1 && currIndex <= lastValidIndex) {
                currRecordIdInBatch.setValues(originalWriteId != null ? originalWriteId[currIndex] : repeatedOriginalWriteId, bucket != null ? (int)bucket[currIndex] : (int)repeatedBucket, rowId != null ? rowId[currIndex] : repeatedRowId);
                if (this.deleteRecordKey.compareRow(currRecordIdInBatch) == 0) {
                    selectedBitSet.clear(currIndex);
                    currIndex = selectedBitSet.nextSetBit(currIndex + 1);
                    continue;
                }
                if (this.deleteRecordKey.compareRow(currRecordIdInBatch) == 1) {
                    if (this.deleteRecordKey.compareRow(lastRecordIdInBatch) == 1) {
                        return;
                    }
                    currIndex = selectedBitSet.nextSetBit(currIndex + 1);
                    continue;
                }
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.deleteRecords != null) {
                this.deleteRecords.close();
            }
        }
    }

    protected static interface DeleteEventRegistry {
        public void findDeletedRecords(ColumnVector[] var1, int var2, BitSet var3) throws IOException;

        public void close() throws IOException;

        public boolean isEmpty();
    }

    private static final class OffsetAndBucketProperty {
        private final long rowIdOffset;
        private final int bucketProperty;
        private final long syntheticWriteId;

        private OffsetAndBucketProperty(long rowIdOffset, int bucketProperty, long syntheticWriteId) {
            this.rowIdOffset = rowIdOffset;
            this.bucketProperty = bucketProperty;
            this.syntheticWriteId = syntheticWriteId;
        }
    }
}

