/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;

public class VectorizedOrcSerde
extends OrcSerde {
    private final OrcStruct[] orcStructArray = new OrcStruct[1024];
    private final Writable[] orcRowArray = new Writable[1024];
    private final ObjectWritable ow = new ObjectWritable();
    private final ObjectInspector inspector = null;
    private final VectorExpressionWriter[] valueWriters;

    public VectorizedOrcSerde(ObjectInspector objInspector) {
        for (int i = 0; i < this.orcStructArray.length; ++i) {
            this.orcRowArray[i] = new OrcSerde.OrcSerdeRow();
        }
        try {
            this.valueWriters = VectorExpressionWriterFactory.getExpressionWriters((StructObjectInspector)objInspector);
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector inspector) {
        VectorizedRowBatch batch = (VectorizedRowBatch)obj;
        try {
            for (int i = 0; i < batch.size; ++i) {
                OrcStruct ost = this.orcStructArray[i];
                if (ost == null) {
                    this.orcStructArray[i] = ost = new OrcStruct(batch.numCols);
                }
                int index = 0;
                index = batch.selectedInUse ? batch.selected[i] : i;
                for (int p = 0; p < batch.projectionSize; ++p) {
                    int k = batch.projectedColumns[p];
                    if (batch.cols[k].isRepeating) {
                        this.valueWriters[p].setValue(ost, batch.cols[k], 0);
                        continue;
                    }
                    this.valueWriters[p].setValue(ost, batch.cols[k], index);
                }
                OrcSerde.OrcSerdeRow row = (OrcSerde.OrcSerdeRow)this.orcRowArray[i];
                row.realRow = ost;
                row.inspector = inspector;
            }
        }
        catch (HiveException ex) {
            throw new RuntimeException(ex);
        }
        this.ow.set((Object)this.orcRowArray);
        return this.ow;
    }
}

