/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import io.trino.hive.$internal.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.spark.SparkPlan;
import org.apache.hadoop.hive.ql.exec.spark.SparkTran;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.storage.StorageLevel;
import scala.Tuple2;

public class MapInput
implements SparkTran<WritableComparable, Writable, WritableComparable, Writable> {
    private JavaPairRDD<WritableComparable, Writable> hadoopRDD;
    private boolean toCache;
    private final SparkPlan sparkPlan;
    private final String name;

    public MapInput(SparkPlan sparkPlan, JavaPairRDD<WritableComparable, Writable> hadoopRDD) {
        this(sparkPlan, hadoopRDD, false, "MapInput");
    }

    public MapInput(SparkPlan sparkPlan, JavaPairRDD<WritableComparable, Writable> hadoopRDD, boolean toCache, String name) {
        this.hadoopRDD = hadoopRDD;
        this.toCache = toCache;
        this.sparkPlan = sparkPlan;
        this.name = name;
    }

    public void setToCache(boolean toCache) {
        this.toCache = toCache;
    }

    @Override
    public JavaPairRDD<WritableComparable, Writable> transform(JavaPairRDD<WritableComparable, Writable> input) {
        JavaPairRDD result;
        Preconditions.checkArgument(input == null, "AssertionError: MapInput doesn't take any input");
        if (this.toCache) {
            result = this.hadoopRDD.mapToPair((PairFunction)new CopyFunction());
            this.sparkPlan.addCachedRDDId(result.id());
            result = result.persist(StorageLevel.MEMORY_AND_DISK());
        } else {
            result = this.hadoopRDD;
        }
        result.setName(this.name);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean isCacheEnable() {
        return new Boolean(this.toCache);
    }

    private static class CopyFunction
    implements PairFunction<Tuple2<WritableComparable, Writable>, WritableComparable, Writable> {
        private transient Configuration conf;

        private CopyFunction() {
        }

        public Tuple2<WritableComparable, Writable> call(Tuple2<WritableComparable, Writable> tuple) throws Exception {
            if (this.conf == null) {
                this.conf = new Configuration();
            }
            return new Tuple2(tuple._1(), (Object)WritableUtils.clone((Writable)((Writable)tuple._2()), (Configuration)this.conf));
        }
    }
}

