/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.HCatRecordSerDe;
import org.apache.hive.hcatalog.data.schema.HCatSchema;

public class LazyHCatRecord
extends HCatRecord {
    public static final Logger LOG = LoggerFactory.getLogger(LazyHCatRecord.class.getName());
    private Object wrappedObject;
    private StructObjectInspector soi;

    @Override
    public Object get(int fieldNum) {
        try {
            StructField fref = this.soi.getAllStructFieldRefs().get(fieldNum);
            return HCatRecordSerDe.serializeField(this.soi.getStructFieldData(this.wrappedObject, fref), fref.getFieldObjectInspector());
        }
        catch (SerDeException e) {
            throw new IllegalStateException("SerDe Exception deserializing", e);
        }
    }

    @Override
    public List<Object> getAll() {
        ArrayList<Object> r = new ArrayList<Object>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            r.add(i, this.get(i));
        }
        return r;
    }

    @Override
    public void set(int fieldNum, Object value) {
        throw new UnsupportedOperationException("not allowed to run set() on LazyHCatRecord");
    }

    @Override
    public int size() {
        return this.soi.getAllStructFieldRefs().size();
    }

    public void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException("LazyHCatRecord is intended to wrap an object/object inspector as a HCatRecord - it does not need to be read from DataInput.");
    }

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("LazyHCatRecord is intended to wrap an object/object inspector as a HCatRecord - it does not need to be written to a DataOutput.");
    }

    @Override
    public Object get(String fieldName, HCatSchema recordSchema) throws HCatException {
        int idx = recordSchema.getPosition(fieldName);
        return this.get(idx);
    }

    @Override
    public void set(String fieldName, HCatSchema recordSchema, Object value) throws HCatException {
        throw new UnsupportedOperationException("not allowed to run set() on LazyHCatRecord");
    }

    @Override
    public void remove(int idx) throws HCatException {
        throw new UnsupportedOperationException("not allowed to run remove() on LazyHCatRecord");
    }

    @Override
    public void copy(HCatRecord r) throws HCatException {
        throw new UnsupportedOperationException("not allowed to run copy() on LazyHCatRecord");
    }

    public LazyHCatRecord(Object wrappedObject, ObjectInspector oi) throws Exception {
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only make a lazy hcat record from objects of struct types, but we got: " + oi.getTypeName());
        }
        this.soi = (StructObjectInspector)oi;
        this.wrappedObject = wrappedObject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.get(i) + "\t");
        }
        return sb.toString();
    }

    public HCatRecord getWritable() throws HCatException {
        DefaultHCatRecord d = new DefaultHCatRecord();
        d.copy(this);
        return d;
    }
}

