/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.orc.impl.mask;

import io.trino.hive.orc.DataMask;
import io.trino.hive.orc.TypeDescription;
import io.trino.hive.orc.impl.mask.MaskFactory;
import io.trino.hive.orc.impl.mask.NullifyMask;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;

public class SHA256MaskFactory
extends MaskFactory {
    final MessageDigest md;

    public SHA256MaskFactory(String ... params) {
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    void maskString(BytesColumnVector source, int row, BytesColumnVector target, TypeDescription schema) {
        byte[] result;
        ByteBuffer sourceBytes = ByteBuffer.wrap(source.vector[row], source.start[row], source.length[row]);
        byte[] hash = DatatypeConverter.printHexBinary((byte[])this.md.digest(sourceBytes.array())).getBytes(StandardCharsets.UTF_8);
        int targetLength = hash.length;
        switch (schema.getCategory()) {
            case VARCHAR: {
                if (schema.getMaxLength() >= hash.length) break;
                targetLength = schema.getMaxLength();
                break;
            }
            case CHAR: {
                targetLength = schema.getMaxLength();
                break;
            }
            default: {
                targetLength = hash.length;
            }
        }
        if (targetLength > hash.length) {
            result = new byte[targetLength];
            System.arraycopy(hash, 0, result, 0, hash.length);
            Arrays.fill(result, hash.length, targetLength - 1, (byte)32);
        } else {
            result = new byte[targetLength];
            System.arraycopy(hash, 0, result, 0, targetLength);
        }
        target.vector[row] = result;
        target.start[row] = 0;
        target.length[row] = targetLength;
    }

    void maskBinary(BytesColumnVector source, int row, BytesColumnVector target) {
        ByteBuffer sourceBytes = ByteBuffer.wrap(source.vector[row], source.start[row], source.length[row]);
        byte[] hash = this.md.digest(sourceBytes.array());
        int targetLength = hash.length;
        target.vector[row] = hash;
        target.start[row] = 0;
        target.length[row] = targetLength;
    }

    @Override
    protected DataMask buildBinaryMask(TypeDescription schema) {
        return new BinaryMask();
    }

    @Override
    protected DataMask buildBooleanMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildLongMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildDecimalMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildDoubleMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildStringMask(TypeDescription schema) {
        return new StringMask(schema);
    }

    @Override
    protected DataMask buildDateMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildTimestampMask(TypeDescription schema) {
        return new NullifyMask();
    }

    class BinaryMask
    implements DataMask {
        @Override
        public void maskData(ColumnVector original, ColumnVector masked, int start, int length) {
            BytesColumnVector target = (BytesColumnVector)masked;
            BytesColumnVector source = (BytesColumnVector)original;
            target.noNulls = original.noNulls;
            target.isRepeating = original.isRepeating;
            if (original.isRepeating) {
                target.isNull[0] = source.isNull[0];
                if (target.noNulls || !target.isNull[0]) {
                    SHA256MaskFactory.this.maskBinary(source, 0, target);
                }
            } else {
                for (int r = start; r < start + length; ++r) {
                    target.isNull[r] = source.isNull[r];
                    if (!target.noNulls && target.isNull[r]) continue;
                    SHA256MaskFactory.this.maskBinary(source, r, target);
                }
            }
        }
    }

    class StringMask
    implements DataMask {
        final TypeDescription schema;

        public StringMask(TypeDescription schema) {
            this.schema = schema;
        }

        @Override
        public void maskData(ColumnVector original, ColumnVector masked, int start, int length) {
            BytesColumnVector target = (BytesColumnVector)masked;
            BytesColumnVector source = (BytesColumnVector)original;
            target.noNulls = original.noNulls;
            target.isRepeating = original.isRepeating;
            if (original.isRepeating) {
                target.isNull[0] = source.isNull[0];
                if (target.noNulls || !target.isNull[0]) {
                    SHA256MaskFactory.this.maskString(source, 0, target, this.schema);
                }
            } else {
                for (int r = start; r < start + length; ++r) {
                    target.isNull[r] = source.isNull[r];
                    if (!target.noNulls && target.isNull[r]) continue;
                    SHA256MaskFactory.this.maskString(source, r, target, this.schema);
                }
            }
        }
    }
}

