/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import io.trino.hive.$internal.com.google.common.collect.Lists;
import io.trino.hive.$internal.com.google.common.collect.Sets;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import io.trino.hive.orc.OrcConf;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;

public class SetProcessor
implements CommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SetProcessor.class);
    private static final String prefix = "set: ";
    private static final Set<String> removedConfigs = Sets.newHashSet("hive.mapred.supports.subdirectories", "hive.enforce.sorting", "hive.enforce.bucketing", "hive.outerjoin.supports.filters", "hive.llap.zk.sm.principal", "hive.llap.zk.sm.keytab.file");
    private static final String[] PASSWORD_STRINGS;
    private static final Pattern TIME_ZONE_PATTERN;

    public static boolean getBoolean(String value) {
        if (value.equals("on") || value.equals("true")) {
            return true;
        }
        if (value.equals("off") || value.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("set: '" + value + "' is not a boolean");
    }

    private void dumpOptions(Properties p) {
        SessionState ss = SessionState.get();
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.put("silent", ss.getIsSilent() ? "on" : "off");
        for (Object object : p.keySet()) {
            String oneProp = (String)object;
            String oneValue = p.getProperty(oneProp);
            if (ss.getConf().isHiddenConfig(oneProp)) continue;
            sortedMap.put(oneProp, oneValue);
        }
        for (String string : ss.getHiveVariables().keySet()) {
            sortedMap.put("hivevar:" + string, ss.getHiveVariables().get(string));
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            ss.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        for (Map.Entry entry : this.mapToSortedMap(System.getenv()).entrySet()) {
            if (this.isHidden((String)entry.getKey())) continue;
            ss.out.println("env:" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        for (Map.Entry entry : this.propertiesToSortedMap(System.getProperties()).entrySet()) {
            if (this.isHidden((String)entry.getKey())) continue;
            ss.out.println("system:" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }

    private boolean isHidden(String key) {
        for (String p : PASSWORD_STRINGS) {
            if (!key.toLowerCase().contains(p)) continue;
            return true;
        }
        return false;
    }

    private void dumpOption(String s) {
        SessionState ss = SessionState.get();
        if (ss.getConf().isHiddenConfig(s)) {
            ss.out.println(s + " is a hidden config");
        } else if (ss.getConf().get(s) != null) {
            ss.getConf();
            if (HiveConf.isEncodedPar(s)) {
                ss.out.println(s + "=" + HiveConf.EncoderDecoderFactory.URL_ENCODER_DECODER.decode(ss.getConf().get(s)));
            } else {
                ss.out.println(s + "=" + ss.getConf().get(s));
            }
        } else if (ss.getHiveVariables().containsKey(s)) {
            ss.out.println(s + "=" + ss.getHiveVariables().get(s));
        } else {
            ss.out.println(s + " is undefined");
        }
    }

    public CommandProcessorResponse executeSetVariable(String varname, String varvalue) {
        try {
            return SetProcessor.setVariable(varname, varvalue);
        }
        catch (Exception e) {
            return new CommandProcessorResponse(1, e.getMessage(), "42000", e instanceof IllegalArgumentException ? null : e);
        }
    }

    public static CommandProcessorResponse setVariable(String varname, String varvalue) throws Exception {
        SessionState ss = SessionState.get();
        if (varvalue.contains("\n")) {
            ss.err.println("Warning: Value had a \\n character in it.");
        }
        varname = varname.trim();
        String nonErrorMessage = null;
        if (varname.startsWith("env:")) {
            ss.err.println("env:* variables can not be set.");
            return new CommandProcessorResponse(1);
        }
        if (varname.startsWith("system:")) {
            String propName = varname.substring("system:".length());
            System.getProperties().setProperty(propName, new VariableSubstitution(new HiveVariableSource(){

                @Override
                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), varvalue));
        } else if (varname.startsWith("hiveconf:")) {
            String propName = varname.substring("hiveconf:".length());
            nonErrorMessage = SetProcessor.setConf(varname, propName, varvalue, false);
        } else if (varname.startsWith("hivevar:")) {
            String propName = varname.substring("hivevar:".length());
            ss.getHiveVariables().put(propName, new VariableSubstitution(new HiveVariableSource(){

                @Override
                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), varvalue));
        } else if (varname.startsWith("metaconf:")) {
            String propName = varname.substring("metaconf:".length());
            Hive hive = Hive.get(ss.getConf());
            hive.setMetaConf(propName, new VariableSubstitution(new HiveVariableSource(){

                @Override
                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), varvalue));
        } else {
            nonErrorMessage = SetProcessor.setConf(varname, varname, varvalue, true);
            if (varname.equals(HiveConf.ConfVars.HIVE_SESSION_HISTORY_ENABLED.toString())) {
                SessionState.get().updateHistory(Boolean.parseBoolean(varvalue), ss);
            }
        }
        return nonErrorMessage == null ? new CommandProcessorResponse(0) : new CommandProcessorResponse(0, Lists.newArrayList(nonErrorMessage));
    }

    static String setConf(String varname, String key, String varvalue, boolean register) throws IllegalArgumentException {
        return SetProcessor.setConf(SessionState.get(), varname, key, varvalue, register);
    }

    static String setConf(final SessionState ss, String varname, String key, String varvalue, boolean register) throws IllegalArgumentException {
        String result = null;
        HiveConf conf = ss.getConf();
        String value = new VariableSubstitution(new HiveVariableSource(){

            @Override
            public Map<String, String> getHiveVariable() {
                return ss.getHiveVariables();
            }
        }).substitute(conf, varvalue);
        if (conf.getBoolVar(HiveConf.ConfVars.HIVECONFVALIDATION)) {
            HiveConf.ConfVars confVars = HiveConf.getConfVars(key);
            if (confVars != null) {
                if (!confVars.isType(value)) {
                    StringBuilder message = new StringBuilder();
                    message.append("'SET ").append(varname).append('=').append(varvalue);
                    message.append("' FAILED because ").append(key).append(" expects ");
                    message.append(confVars.typeString()).append(" type value.");
                    throw new IllegalArgumentException(message.toString());
                }
                String fail = confVars.validate(value);
                if (fail != null) {
                    StringBuilder message = new StringBuilder();
                    message.append("'SET ").append(varname).append('=').append(varvalue);
                    message.append("' FAILED in validation : ").append(fail).append('.');
                    throw new IllegalArgumentException(message.toString());
                }
            } else if (!removedConfigs.contains(key) && key.startsWith("hive.")) {
                throw new IllegalArgumentException("hive configuration " + key + " does not exists.");
            }
        }
        conf.verifyAndSet(key, value);
        if (HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname.equals(key)) {
            if (!"spark".equals(value)) {
                ss.closeSparkSession();
            }
            if ("mr".equals(value)) {
                result = HiveConf.generateMrDeprecationWarning();
                LOG.warn(result);
            }
        }
        if (register) {
            ss.getOverriddenConfigurations().put(key, value);
        }
        return result;
    }

    private SortedMap<String, String> propertiesToSortedMap(Properties p) {
        TreeMap<String, String> sortedPropMap = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            sortedPropMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return sortedPropMap;
    }

    private SortedMap<String, String> mapToSortedMap(Map<String, String> data) {
        TreeMap<String, String> sortedEnvMap = new TreeMap<String, String>();
        sortedEnvMap.putAll(data);
        return sortedEnvMap;
    }

    private CommandProcessorResponse getVariable(String varname) throws Exception {
        SessionState ss = SessionState.get();
        if (varname.equals("silent")) {
            ss.out.println("silent=" + ss.getIsSilent());
            return this.createProcessorSuccessResponse();
        }
        if (varname.startsWith("system:")) {
            String propName = varname.substring("system:".length());
            String result = System.getProperty(propName);
            if (result != null) {
                if (this.isHidden(propName)) {
                    ss.out.println("system:" + propName + " is a hidden config");
                } else {
                    ss.out.println("system:" + propName + "=" + result);
                }
                return this.createProcessorSuccessResponse();
            }
            ss.out.println(propName + " is undefined as a system property");
            return new CommandProcessorResponse(1);
        }
        if (varname.indexOf("env:") == 0) {
            String var = varname.substring("env:".length());
            if (System.getenv(var) != null) {
                if (this.isHidden(var)) {
                    ss.out.println("env:" + var + " is a hidden config");
                } else {
                    ss.out.println("env:" + var + "=" + System.getenv(var));
                }
                return this.createProcessorSuccessResponse();
            }
            ss.out.println(varname + " is undefined as an environmental variable");
            return new CommandProcessorResponse(1);
        }
        if (varname.indexOf("hiveconf:") == 0) {
            String var = varname.substring("hiveconf:".length());
            if (ss.getConf().isHiddenConfig(var)) {
                ss.out.println("hiveconf:" + var + " is a hidden config");
                return this.createProcessorSuccessResponse();
            }
            if (ss.getConf().get(var) != null) {
                ss.out.println("hiveconf:" + var + "=" + ss.getConf().get(var));
                return this.createProcessorSuccessResponse();
            }
            ss.out.println(varname + " is undefined as a hive configuration variable");
            return new CommandProcessorResponse(1);
        }
        if (varname.indexOf("hivevar:") == 0) {
            String var = varname.substring("hivevar:".length());
            if (ss.getHiveVariables().get(var) != null) {
                ss.out.println("hivevar:" + var + "=" + ss.getHiveVariables().get(var));
                return this.createProcessorSuccessResponse();
            }
            ss.out.println(varname + " is undefined as a hive variable");
            return new CommandProcessorResponse(1);
        }
        if (varname.indexOf("metaconf:") == 0) {
            String var = varname.substring("metaconf:".length());
            Hive hive = Hive.get(ss.getConf());
            String value = hive.getMetaConf(var);
            if (value != null) {
                ss.out.println("metaconf:" + var + "=" + value);
                return this.createProcessorSuccessResponse();
            }
            ss.out.println(varname + " is undefined as a hive meta variable");
            return new CommandProcessorResponse(1);
        }
        this.dumpOption(varname);
        return this.createProcessorSuccessResponse();
    }

    private CommandProcessorResponse createProcessorSuccessResponse() {
        return new CommandProcessorResponse(0, null, null, this.getSchema());
    }

    @Override
    public CommandProcessorResponse run(String command) {
        SessionState ss = SessionState.get();
        String nwcmd = command.trim();
        if (nwcmd.equals("")) {
            this.dumpOptions(ss.getConf().getChangedProperties());
            return this.createProcessorSuccessResponse();
        }
        if (nwcmd.equals("-v")) {
            Properties properties = null;
            if (ss.getConf().getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                try {
                    Class<?> clazz = Class.forName("org.apache.tez.dag.api.TezConfiguration");
                    Configuration tezConf = (Configuration)clazz.getConstructor(Configuration.class).newInstance(new Object[]{ss.getConf()});
                    properties = HiveConf.getProperties(tezConf);
                }
                catch (Exception e) {
                    return new CommandProcessorResponse(1, e.getMessage(), "42000", e);
                }
            } else {
                properties = ss.getConf().getAllProperties();
            }
            this.dumpOptions(properties);
            return this.createProcessorSuccessResponse();
        }
        Matcher matcher = TIME_ZONE_PATTERN.matcher(nwcmd);
        if (matcher.find()) {
            nwcmd = HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE.varname + "=" + nwcmd.substring(matcher.end());
        }
        String[] part = new String[2];
        int eqIndex = nwcmd.indexOf(61);
        if (nwcmd.contains("=")) {
            if (eqIndex == nwcmd.length() - 1) {
                part[0] = nwcmd.substring(0, nwcmd.length() - 1);
                part[1] = "";
            } else {
                part[0] = nwcmd.substring(0, eqIndex).trim();
                part[1] = nwcmd.substring(eqIndex + 1).trim();
            }
            if (part[0].equals("silent")) {
                ss.setIsSilent(SetProcessor.getBoolean(part[1]));
                return new CommandProcessorResponse(0);
            }
            return this.executeSetVariable(part[0], part[1]);
        }
        try {
            return this.getVariable(nwcmd);
        }
        catch (Exception e) {
            return new CommandProcessorResponse(1, e.getMessage(), "42000", e);
        }
    }

    private Schema getSchema() {
        Schema sch = new Schema();
        FieldSchema tmpFieldSchema = new FieldSchema();
        tmpFieldSchema.setName("set");
        tmpFieldSchema.setType("string");
        sch.putToProperties("serialization.null.format", "\\N");
        sch.addToFieldSchemas(tmpFieldSchema);
        return sch;
    }

    @Override
    public void close() throws Exception {
    }

    static {
        for (OrcConf var : OrcConf.values()) {
            String name = var.getHiveConfName();
            if (name == null || !name.startsWith("hive.")) continue;
            removedConfigs.add(name);
        }
        PASSWORD_STRINGS = new String[]{"password", "paswd", "pswd"};
        TIME_ZONE_PATTERN = Pattern.compile("^time(\\s)+zone\\s", 2);
    }
}

