/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeRegistry;
import org.apache.hadoop.hive.ql.session.SessionState;

public class CreateTableAutomaticGrant {
    private Map<String, List<PrivilegeGrantInfo>> userGrants;
    private Map<String, List<PrivilegeGrantInfo>> groupGrants;
    private Map<String, List<PrivilegeGrantInfo>> roleGrants;
    private List<PrivilegeGrantInfo> ownerGrant;

    public static CreateTableAutomaticGrant create(HiveConf conf) throws HiveException {
        CreateTableAutomaticGrant grants = new CreateTableAutomaticGrant();
        grants.userGrants = CreateTableAutomaticGrant.getGrantMap(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_TABLE_USER_GRANTS));
        grants.groupGrants = CreateTableAutomaticGrant.getGrantMap(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_TABLE_GROUP_GRANTS));
        grants.roleGrants = CreateTableAutomaticGrant.getGrantMap(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_TABLE_ROLE_GRANTS));
        grants.ownerGrant = CreateTableAutomaticGrant.getGrantorInfoList(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_TABLE_OWNER_GRANTS));
        return grants;
    }

    private static Map<String, List<PrivilegeGrantInfo>> getGrantMap(String grantMapStr) throws HiveException {
        if (grantMapStr != null && !grantMapStr.trim().equals("")) {
            String[] grantArrayStr = grantMapStr.split(";");
            HashMap<String, List<PrivilegeGrantInfo>> grantsMap = new HashMap<String, List<PrivilegeGrantInfo>>();
            for (String grantStr : grantArrayStr) {
                String[] users;
                String[] principalListAndPrivList = grantStr.split(":");
                if (principalListAndPrivList.length != 2 || principalListAndPrivList[0] == null || principalListAndPrivList[0].trim().equals("")) {
                    throw new HiveException("Can not understand the config privilege definition " + grantStr);
                }
                String userList = principalListAndPrivList[0];
                String privList = principalListAndPrivList[1];
                List<PrivilegeGrantInfo> grantInfoList = CreateTableAutomaticGrant.getGrantorInfoList(privList);
                if (grantInfoList == null) continue;
                for (String user : users = userList.split(",")) {
                    grantsMap.put(user, grantInfoList);
                }
            }
            return grantsMap;
        }
        return null;
    }

    private static List<PrivilegeGrantInfo> getGrantorInfoList(String privList) throws HiveException {
        if (privList == null || privList.trim().equals("")) {
            return null;
        }
        CreateTableAutomaticGrant.validatePrivilege(privList);
        String[] grantArray = privList.split(",");
        ArrayList<PrivilegeGrantInfo> grantInfoList = new ArrayList<PrivilegeGrantInfo>();
        String grantor = SessionState.getUserFromAuthenticator();
        for (String grant : grantArray) {
            grantInfoList.add(new PrivilegeGrantInfo(grant, -1, grantor, PrincipalType.USER, true));
        }
        return grantInfoList;
    }

    private static void validatePrivilege(String ownerGrantsInConfig) throws HiveException {
        String[] ownerGrantArray;
        for (String ownerGrant : ownerGrantArray = ownerGrantsInConfig.split(",")) {
            Privilege prive = PrivilegeRegistry.getPrivilege(ownerGrant);
            if (prive != null) continue;
            throw new HiveException("Privilege " + ownerGrant + " is not found.");
        }
    }

    public Map<String, List<PrivilegeGrantInfo>> getUserGrants() {
        HashMap<String, List<PrivilegeGrantInfo>> curUserGrants = new HashMap<String, List<PrivilegeGrantInfo>>();
        String owner = SessionState.getUserFromAuthenticator();
        if (owner != null && this.ownerGrant != null) {
            curUserGrants.put(owner, this.ownerGrant);
        }
        if (this.userGrants != null) {
            curUserGrants.putAll(this.userGrants);
        }
        return curUserGrants;
    }

    public Map<String, List<PrivilegeGrantInfo>> getGroupGrants() {
        return this.groupGrants;
    }

    public Map<String, List<PrivilegeGrantInfo>> getRoleGrants() {
        return this.roleGrants;
    }
}

