/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.keytools;

import io.trino.hive.$internal.parquet.com.fasterxml.jackson.core.type.TypeReference;
import io.trino.hive.$internal.parquet.com.fasterxml.jackson.databind.JsonNode;
import io.trino.hive.$internal.parquet.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.keytools.FileKeyMaterialStore;

public class HadoopFSKeyMaterialStore
implements FileKeyMaterialStore {
    public static final String KEY_MATERIAL_FILE_PREFIX = "_KEY_MATERIAL_FOR_";
    public static final String TEMP_FILE_PREFIX = "_TMP";
    public static final String KEY_MATERIAL_FILE_SUFFFIX = ".json";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private FileSystem hadoopFileSystem;
    private Map<String, String> keyMaterialMap;
    private Path keyMaterialFile;

    HadoopFSKeyMaterialStore(FileSystem hadoopFileSystem) {
        this.hadoopFileSystem = hadoopFileSystem;
    }

    @Override
    public void initialize(Path parquetFilePath, Configuration hadoopConfig, boolean tempStore) {
        String fullPrefix = tempStore ? TEMP_FILE_PREFIX : "";
        fullPrefix = fullPrefix + KEY_MATERIAL_FILE_PREFIX;
        this.keyMaterialFile = new Path(parquetFilePath.getParent(), fullPrefix + parquetFilePath.getName() + KEY_MATERIAL_FILE_SUFFFIX);
    }

    @Override
    public void addKeyMaterial(String keyIDInFile, String keyMaterial) throws ParquetCryptoRuntimeException {
        if (null == this.keyMaterialMap) {
            this.keyMaterialMap = new HashMap<String, String>();
        }
        this.keyMaterialMap.put(keyIDInFile, keyMaterial);
    }

    @Override
    public String getKeyMaterial(String keyIDInFile) throws ParquetCryptoRuntimeException {
        if (null == this.keyMaterialMap) {
            this.loadKeyMaterialMap();
        }
        return this.keyMaterialMap.get(keyIDInFile);
    }

    private void loadKeyMaterialMap() {
        try (FSDataInputStream keyMaterialStream = this.hadoopFileSystem.open(this.keyMaterialFile);){
            JsonNode keyMaterialJson = objectMapper.readTree((InputStream)keyMaterialStream);
            this.keyMaterialMap = objectMapper.readValue(keyMaterialJson.traverse(), new TypeReference<Map<String, String>>(){});
        }
        catch (FileNotFoundException e) {
            throw new ParquetCryptoRuntimeException("External key material not found at " + this.keyMaterialFile, e);
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException("Failed to get key material from " + this.keyMaterialFile, e);
        }
    }

    @Override
    public void saveMaterial() throws ParquetCryptoRuntimeException {
        try (FSDataOutputStream keyMaterialStream = this.hadoopFileSystem.create(this.keyMaterialFile);){
            objectMapper.writeValue((OutputStream)keyMaterialStream, this.keyMaterialMap);
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException("Failed to save key material in " + this.keyMaterialFile, e);
        }
    }

    @Override
    public Set<String> getKeyIDSet() throws ParquetCryptoRuntimeException {
        if (null == this.keyMaterialMap) {
            this.loadKeyMaterialMap();
        }
        return this.keyMaterialMap.keySet();
    }

    @Override
    public void removeMaterial() throws ParquetCryptoRuntimeException {
        try {
            this.hadoopFileSystem.delete(this.keyMaterialFile, false);
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException("Failed to delete key material file " + this.keyMaterialFile, e);
        }
    }

    @Override
    public void moveMaterialTo(FileKeyMaterialStore keyMaterialStore) throws ParquetCryptoRuntimeException {
        HadoopFSKeyMaterialStore targetStore;
        try {
            targetStore = (HadoopFSKeyMaterialStore)keyMaterialStore;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Currently supports only moving to HadoopFSKeyMaterialStore, not to " + keyMaterialStore.getClass(), e);
        }
        Path targetKeyMaterialFile = targetStore.getStorageFilePath();
        try {
            this.hadoopFileSystem.rename(this.keyMaterialFile, targetKeyMaterialFile);
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException("Failed to rename file " + this.keyMaterialFile, e);
        }
    }

    private Path getStorageFilePath() {
        return this.keyMaterialFile;
    }
}

